/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.elements;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.modules.parsing.spi.indexing.support.IndexResult;
import org.netbeans.modules.php.api.PhpVersion;
import org.netbeans.modules.php.editor.api.ElementQuery;
import org.netbeans.modules.php.editor.api.NameKind;
import org.netbeans.modules.php.editor.api.PhpElementKind;
import org.netbeans.modules.php.editor.api.PhpModifiers;
import org.netbeans.modules.php.editor.api.elements.BaseFunctionElement;
import org.netbeans.modules.php.editor.api.elements.EnumElement;
import org.netbeans.modules.php.editor.api.elements.MethodElement;
import org.netbeans.modules.php.editor.api.elements.ParameterElement;
import org.netbeans.modules.php.editor.api.elements.TypeElement;
import org.netbeans.modules.php.editor.api.elements.TypeNameResolver;
import org.netbeans.modules.php.editor.api.elements.TypeResolver;
import org.netbeans.modules.php.editor.elements.BaseFunctionElementSupport;
import org.netbeans.modules.php.editor.elements.IndexQueryImpl;
import org.netbeans.modules.php.editor.elements.ParameterElementImpl;
import org.netbeans.modules.php.editor.elements.PhpElementImpl;
import org.netbeans.modules.php.editor.elements.TypeNameResolverImpl;
import org.netbeans.modules.php.editor.elements.TypeResolverImpl;
import org.netbeans.modules.php.editor.index.Signature;
import org.netbeans.modules.php.editor.model.impl.VariousUtils;
import org.netbeans.modules.php.editor.model.nodes.MethodDeclarationInfo;
import org.netbeans.modules.php.editor.parser.astnodes.MethodDeclaration;
import org.openide.util.Pair;
import org.openide.util.Parameters;

public final class MethodElementImpl
extends PhpElementImpl
implements MethodElement {
    public static final String IDX_FIELD = "method";
    public static final String IDX_CONSTRUCTOR_FIELD = "constructor";
    private final PhpModifiers modifiers;
    private final TypeElement enclosingType;
    private final BaseFunctionElementSupport functionSupport;
    private final boolean isMagic;

    private MethodElementImpl(TypeElement enclosingType, String methodName, boolean isMagic, int offset, int flags, String fileUrl, ElementQuery elementQuery, BaseFunctionElementSupport.Parameters parameters, BaseFunctionElementSupport.ReturnTypes returnTypes, boolean isDeprecated) {
        super(methodName, enclosingType.getName(), fileUrl, offset, elementQuery, isDeprecated);
        boolean isFromInterface = enclosingType.isInterface();
        this.modifiers = PhpModifiers.fromBitMask(isFromInterface ? flags | 0x400 | 1 : flags);
        this.isMagic = isMagic;
        this.enclosingType = enclosingType;
        this.functionSupport = new BaseFunctionElementSupport(parameters, returnTypes);
    }

    public static Set<MethodElement> getMagicMethods(TypeElement type) {
        HashSet<MethodElement> retval = new HashSet<MethodElement>();
        retval.add(MethodElementImpl.createMagicMethod(type, "__callStatic", 9, Arrays.asList(Pair.of((Object)"string", (Object)"$name"), Pair.of((Object)"array", (Object)"$arguments")), "mixed"));
        retval.add(MethodElementImpl.createMagicMethod(type, "__call", 1, Arrays.asList(Pair.of((Object)"string", (Object)"$name"), Pair.of((Object)"array", (Object)"$arguments")), "mixed"));
        retval.add(MethodElementImpl.createMagicMethod(type, "__invoke", 1, Collections.emptyList(), "mixed"));
        if (!(type instanceof EnumElement)) {
            retval.add(MethodElementImpl.createMagicMethod(type, "__set_state", 9, Arrays.asList(Pair.of((Object)"array", (Object)"$properties")), "object"));
            retval.add(MethodElementImpl.createMagicMethod(type, "__clone", 1, Collections.emptyList(), "void"));
            retval.add(MethodElementImpl.forIntroduceHint(type, "__construct", 1, new String[0]));
            retval.add(MethodElementImpl.forIntroduceHint(type, "__destruct", 1, new String[0]));
            retval.add(MethodElementImpl.createMagicMethod(type, "__get", 1, Arrays.asList(Pair.of((Object)"string", (Object)"$name")), "mixed"));
            retval.add(MethodElementImpl.createMagicMethod(type, "__set", 1, Arrays.asList(Pair.of((Object)"string", (Object)"$name"), Pair.of((Object)"mixed", (Object)"$value")), "void"));
            retval.add(MethodElementImpl.createMagicMethod(type, "__isset", 1, Arrays.asList(Pair.of((Object)"string", (Object)"$name")), "bool"));
            retval.add(MethodElementImpl.createMagicMethod(type, "__unset", 1, Arrays.asList(Pair.of((Object)"string", (Object)"$name")), "void"));
            retval.add(MethodElementImpl.createMagicMethod(type, "__sleep", 1, Collections.emptyList(), "array"));
            retval.add(MethodElementImpl.createMagicMethod(type, "__wakeup", 1, Collections.emptyList(), "void"));
            retval.add(MethodElementImpl.createMagicMethod(type, "__toString", 1, Collections.emptyList(), "string"));
            retval.add(MethodElementImpl.createMagicMethod(type, "__debugInfo", 1, Collections.emptyList(), "array"));
            retval.add(MethodElementImpl.createMagicMethod(type, "__serialize", 1, Collections.emptyList(), "array"));
            retval.add(MethodElementImpl.createMagicMethod(type, "__unserialize", 1, Arrays.asList(Pair.of((Object)"array", (Object)"$data")), "void"));
        }
        return retval;
    }

    public static MethodElement forIntroduceHint(TypeElement type, String methodName, int flags, String ... arguments) {
        MethodElementImpl retval = new MethodElementImpl(type, methodName, true, 0, flags, type.getFilenameUrl(), null, BaseFunctionElementSupport.ParametersImpl.create(MethodElementImpl.fromParameterNames(arguments)), BaseFunctionElementSupport.ReturnTypes.NONE, type.isDeprecated());
        return retval;
    }

    public static MethodElement createMagicMethod(TypeElement type, String methodName, int flags, List<Pair<String, String>> arguments, String returnType) {
        MethodElementImpl retval = new MethodElementImpl(type, methodName, true, 0, flags, type.getFilenameUrl(), null, BaseFunctionElementSupport.ParametersImpl.create(MethodElementImpl.fromParameterNames(arguments)), BaseFunctionElementSupport.ReturnTypesImpl.create(returnType), type.isDeprecated());
        return retval;
    }

    static String getValidType(@NullAllowed String declaredType, @NullAllowed PhpVersion phpVersion) {
        if (declaredType == null) {
            return "";
        }
        String type = declaredType.trim();
        if (phpVersion == null) {
            return type;
        }
        switch (type) {
            case "mixed": {
                return phpVersion.hasMixedType() ? type : "";
            }
            case "object": {
                return phpVersion.hasObjectType() ? type : "";
            }
            case "void": {
                return phpVersion.hasVoidReturnType() ? type : "";
            }
        }
        return type;
    }

    private static List<ParameterElement> fromParameterNames(String ... names) {
        ArrayList<ParameterElement> retval = new ArrayList<ParameterElement>();
        for (String parameterName : names) {
            ParameterElement parameterElement = new ParameterElementImpl.Builder(parameterName).isMagicMethod(false).isMandatory(true).isRawType(true).build();
            retval.add(parameterElement);
        }
        return retval;
    }

    private static List<ParameterElement> fromParameterNames(List<Pair<String, String>> parameterTypeAndNamePairs) {
        ArrayList<ParameterElement> retval = new ArrayList<ParameterElement>();
        for (Pair<String, String> parameterTypeAndName : parameterTypeAndNamePairs) {
            String declaredType = (String)parameterTypeAndName.first();
            String parameterName = (String)parameterTypeAndName.second();
            ParameterElement parameterElement = new ParameterElementImpl.Builder(parameterName).isMagicMethod(true).isMandatory(true).isRawType(declaredType != null).declaredType(declaredType).build();
            retval.add(parameterElement);
        }
        return retval;
    }

    public static Set<MethodElement> fromSignature(TypeElement type, IndexQueryImpl indexQuery, IndexResult indexResult) {
        return MethodElementImpl.fromSignature(type, (NameKind)NameKind.empty(), indexQuery, indexResult);
    }

    public static Set<MethodElement> fromSignature(TypeElement type, NameKind query, IndexQueryImpl indexQuery, IndexResult indexResult) {
        String[] values = indexResult.getValues(IDX_FIELD);
        HashSet<MethodElement> retval = values.length > 0 ? new HashSet<MethodElement>() : Collections.emptySet();
        for (String val : values) {
            MethodElement method = MethodElementImpl.fromSignature(type, query, indexQuery, Signature.get(val));
            if (method == null) continue;
            retval.add(method);
        }
        return retval;
    }

    private static MethodElement fromSignature(TypeElement type, NameKind query, IndexQueryImpl indexScopeQuery, Signature sig) {
        Parameters.notNull((CharSequence)"NameKind query: can't be null", (Object)query);
        MethodSignatureParser signParser = new MethodSignatureParser(sig);
        MethodElementImpl retval = null;
        if (MethodElementImpl.matchesQuery(query, signParser)) {
            retval = new MethodElementImpl(type, signParser.getMethodName(), false, signParser.getOffset(), signParser.getFlags(), signParser.getFileUrl(), indexScopeQuery, new ParametersFromSignature(signParser), new ReturnTypesFromSignature(signParser), signParser.isDeprecated());
        }
        return retval;
    }

    public static MethodElement fromNode(TypeElement type, MethodDeclaration node, ElementQuery.File fileQuery) {
        Parameters.notNull((CharSequence)"type", (Object)type);
        Parameters.notNull((CharSequence)"node", (Object)node);
        Parameters.notNull((CharSequence)"fileQuery", (Object)fileQuery);
        MethodDeclarationInfo info = MethodDeclarationInfo.create(fileQuery.getResult().getProgram(), node, type.isInterface());
        return new MethodElementImpl(type, info.getName(), false, info.getRange().getStart(), info.getAccessModifiers().toFlags(), fileQuery.getURL().toExternalForm(), fileQuery, BaseFunctionElementSupport.ParametersImpl.create(info.getParameters()), BaseFunctionElementSupport.ReturnTypesImpl.create(TypeResolverImpl.parseTypes(VariousUtils.getReturnType(fileQuery.getResult().getProgram(), node.getFunction())), node.getFunction().getReturnType()), VariousUtils.isDeprecatedFromPHPDoc(fileQuery.getResult().getProgram(), node.getFunction()));
    }

    private static boolean matchesQuery(NameKind query, MethodSignatureParser signParser) {
        Parameters.notNull((CharSequence)"NameKind query: can't be null", (Object)query);
        return query instanceof NameKind.Empty || query.matchesName(MethodElement.KIND, signParser.getMethodName());
    }

    public static Set<MethodElement> fromConstructorSignature(TypeElement type, IndexQueryImpl indexQuery, IndexResult indexResult) {
        String[] values = indexResult.getValues(IDX_CONSTRUCTOR_FIELD);
        HashSet<MethodElement> retval = new HashSet<MethodElement>();
        for (String val : values) {
            retval.add(MethodElementImpl.fromConstructorSignature(type, indexQuery, indexResult, Signature.get(val)));
        }
        return retval;
    }

    public static MethodElement fromConstructorSignature(TypeElement type, IndexQueryImpl indexScopeQuery, IndexResult indexResult, Signature sig) {
        MethodSignatureParser signParser = new MethodSignatureParser(sig);
        MethodElementImpl retval = new MethodElementImpl(type, "__construct", false, signParser.getOffset(), signParser.getFlags(), indexResult.getUrl().toString(), indexScopeQuery, new ParametersFromSignature(signParser), new ReturnTypesFromSignature(signParser), signParser.isDeprecated());
        return retval;
    }

    @Override
    public List<ParameterElement> getParameters() {
        return this.functionSupport.getParameters();
    }

    @Override
    public Collection<TypeResolver> getReturnTypes() {
        return this.functionSupport.getReturnTypes();
    }

    @Override
    public String getDeclaredReturnType() {
        return this.functionSupport.getDeclaredReturnType();
    }

    @Override
    public boolean isReturnUnionType() {
        return this.functionSupport.isReturnUnionType();
    }

    @Override
    public boolean isReturnIntersectionType() {
        return this.functionSupport.isReturnIntersectionType();
    }

    @Override
    public String asString(BaseFunctionElement.PrintAs as) {
        return this.asString(as, TypeNameResolverImpl.forNull());
    }

    @Override
    public String asString(BaseFunctionElement.PrintAs as, TypeNameResolver typeNameResolver) {
        return this.functionSupport.asString(as, this, typeNameResolver);
    }

    @Override
    public String asString(BaseFunctionElement.PrintAs as, TypeNameResolver typeNameResolver, PhpVersion phpVersion) {
        return this.functionSupport.asString(as, this, typeNameResolver, phpVersion);
    }

    @Override
    public PhpElementKind getPhpElementKind() {
        return MethodElement.KIND;
    }

    @Override
    public PhpModifiers getPhpModifiers() {
        return this.modifiers;
    }

    @Override
    public TypeElement getType() {
        return this.enclosingType;
    }

    @Override
    public boolean isConstructor() {
        NameKind.Exact exactName = NameKind.exact(this.getName());
        return exactName.matchesName(this.getPhpElementKind(), "__construct") || exactName.matchesName(this.getPhpElementKind(), this.getType().getName());
    }

    @Override
    public String getSignature() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName().toLowerCase(Locale.ROOT)).append((Object)PhpElementImpl.Separator.SEMICOLON);
        sb.append(this.getName()).append((Object)PhpElementImpl.Separator.SEMICOLON);
        sb.append(this.getSignatureLastPart());
        this.checkSignature(sb);
        return sb.toString();
    }

    public String getConstructorSignature() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getType().getName().toLowerCase()).append((Object)PhpElementImpl.Separator.SEMICOLON);
        sb.append(this.getType().getName()).append((Object)PhpElementImpl.Separator.SEMICOLON);
        sb.append(this.getSignatureLastPart());
        this.checkConstructorSignature(sb);
        return sb.toString();
    }

    private String getSignatureLastPart() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getOffset()).append((Object)PhpElementImpl.Separator.SEMICOLON);
        List<ParameterElement> parameterList = this.getParameters();
        for (int idx = 0; idx < parameterList.size(); ++idx) {
            ParameterElementImpl parameter = (ParameterElementImpl)parameterList.get(idx);
            if (idx > 0) {
                sb.append((Object)PhpElementImpl.Separator.COMMA);
            }
            sb.append(parameter.getSignature());
        }
        sb.append((Object)PhpElementImpl.Separator.SEMICOLON);
        for (TypeResolver typeResolver : this.getReturnTypes()) {
            TypeResolverImpl resolverImpl = (TypeResolverImpl)typeResolver;
            sb.append(resolverImpl.getSignature());
        }
        sb.append((Object)PhpElementImpl.Separator.SEMICOLON);
        sb.append(this.getPhpModifiers().toFlags()).append((Object)PhpElementImpl.Separator.SEMICOLON);
        sb.append(this.isDeprecated() ? 1 : 0).append((Object)PhpElementImpl.Separator.SEMICOLON);
        sb.append(this.getFilenameUrl()).append((Object)PhpElementImpl.Separator.SEMICOLON);
        sb.append(this.isReturnUnionType() ? 1 : 0).append((Object)PhpElementImpl.Separator.SEMICOLON);
        sb.append(this.isReturnIntersectionType() ? 1 : 0).append((Object)PhpElementImpl.Separator.SEMICOLON);
        sb.append(this.getDeclaredReturnType()).append((Object)PhpElementImpl.Separator.SEMICOLON);
        return sb.toString();
    }

    @Override
    public boolean isStatic() {
        return this.getPhpModifiers().isStatic();
    }

    @Override
    public boolean isPublic() {
        return this.getPhpModifiers().isPublic();
    }

    @Override
    public boolean isProtected() {
        return this.getPhpModifiers().isProtected();
    }

    @Override
    public boolean isPrivate() {
        return this.getPhpModifiers().isPrivate();
    }

    @Override
    public boolean isFinal() {
        return this.getPhpModifiers().isFinal();
    }

    @Override
    public boolean isAbstract() {
        return this.getPhpModifiers().isAbstract();
    }

    @Override
    public boolean isMagic() {
        return this.isMagic;
    }

    private void checkSignature(StringBuilder sb) {
        boolean checkEnabled = false;
        if (!$assertionsDisabled) {
            checkEnabled = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (checkEnabled) {
            String retval = sb.toString();
            MethodSignatureParser parser = new MethodSignatureParser(Signature.get(retval));
            assert (this.getName().equals(parser.getMethodName()));
            assert (this.getOffset() == parser.getOffset());
            assert (this.getPhpModifiers().toFlags() == parser.getFlags());
            assert (this.getParameters().size() == parser.getParameters().size());
            assert (this.getReturnTypes().size() == parser.getReturnTypes().size());
            assert (this.getDeclaredReturnType().equals(parser.getDeclaredReturnType()));
        }
    }

    private void checkConstructorSignature(StringBuilder sb) {
        boolean checkEnabled = false;
        if (!$assertionsDisabled) {
            checkEnabled = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (checkEnabled) {
            String retval = sb.toString();
            MethodSignatureParser parser = new MethodSignatureParser(Signature.get(retval));
            assert (this.getName().equals("__construct"));
            assert (this.getOffset() == parser.getOffset());
            assert (this.getPhpModifiers().toFlags() == parser.getFlags());
            assert (this.getParameters().size() == parser.getParameters().size());
        }
    }

    private static class MethodSignatureParser {
        private final Signature signature;

        MethodSignatureParser(Signature signature) {
            this.signature = signature;
        }

        String getMethodName() {
            return this.signature.string(1);
        }

        int getOffset() {
            return this.signature.integer(2);
        }

        List<ParameterElement> getParameters() {
            return ParameterElementImpl.parseParameters(this.signature.string(3));
        }

        int getFlags() {
            return this.signature.integer(5);
        }

        Set<TypeResolver> getReturnTypes() {
            return TypeResolverImpl.parseTypes(this.signature.string(4));
        }

        boolean isDeprecated() {
            return this.signature.integer(6) == 1;
        }

        String getFileUrl() {
            return this.signature.string(7);
        }

        boolean isUnionType() {
            return this.signature.integer(8) == 1;
        }

        boolean isIntersectionType() {
            return this.signature.integer(9) == 1;
        }

        String getDeclaredReturnType() {
            return this.signature.string(10);
        }
    }

    private static final class ParametersFromSignature
    implements BaseFunctionElementSupport.Parameters {
        private final MethodSignatureParser methodSignatureParser;
        private List<ParameterElement> retrievedParameters = null;

        public ParametersFromSignature(MethodSignatureParser methodSignatureParser) {
            this.methodSignatureParser = methodSignatureParser;
        }

        @Override
        public synchronized List<ParameterElement> getParameters() {
            if (this.retrievedParameters == null) {
                this.retrievedParameters = this.methodSignatureParser.getParameters();
            }
            return this.retrievedParameters;
        }
    }

    private static final class ReturnTypesFromSignature
    implements BaseFunctionElementSupport.ReturnTypes {
        private final MethodSignatureParser methodSignatureParser;
        private Set<TypeResolver> retrievedReturnTypes = null;
        private final boolean isUnionType;
        private final boolean isIntersectionType;
        @NullAllowed
        private final String declaredReturnType;

        public ReturnTypesFromSignature(MethodSignatureParser methodSignatureParser) {
            this.methodSignatureParser = methodSignatureParser;
            this.isUnionType = methodSignatureParser.isUnionType();
            this.isIntersectionType = methodSignatureParser.isIntersectionType();
            this.declaredReturnType = methodSignatureParser.getDeclaredReturnType();
        }

        @Override
        public synchronized Set<TypeResolver> getReturnTypes() {
            if (this.retrievedReturnTypes == null) {
                this.retrievedReturnTypes = this.methodSignatureParser.getReturnTypes();
            }
            return this.retrievedReturnTypes;
        }

        @Override
        public boolean isUnionType() {
            return this.isUnionType;
        }

        @Override
        public boolean isIntersectionType() {
            return this.isIntersectionType;
        }

        @Override
        @CheckForNull
        public String getDeclaredReturnType() {
            return this.declaredReturnType;
        }
    }
}

