/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.tag;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Collections;
import java.util.Date;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.mercurial.ui.log.HgLogMessage;
import org.netbeans.modules.mercurial.ui.repository.ChangesetPickerPanel;
import org.netbeans.modules.mercurial.ui.tag.CreateTagPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

class CreateTag
implements ActionListener {
    private final CreateTagPanel panel = new CreateTagPanel();
    private static final HgLogMessage PARENT_REVISION = new HgLogMessage(null, Collections.emptyList(), null, null, null, null, Long.toString(new Date().getTime()), NbBundle.getMessage(CreateTag.class, (String)"MSG_Revision_Parent"), null, null, null, null, null, "", "");
    private HgLogMessage selectedRevision;
    private final File repository;
    private ChangesetPickerSimplePanel changesetPickerPanel;

    public CreateTag(File repository) {
        this.repository = repository;
        this.setSelectedRevision(null);
        this.attachListeners();
    }

    boolean showDialog() {
        final JButton okButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)okButton, (String)NbBundle.getMessage(CreateTag.class, (String)"CTL_CreateTag.ok.text"));
        DialogDescriptor dd = new DialogDescriptor((Object)this.panel, NbBundle.getMessage(CreateTag.class, (String)"LBL_CreateTagPanel.title"), true, new Object[]{okButton, DialogDescriptor.CANCEL_OPTION}, (Object)okButton, 0, new HelpCtx("org.netbeans.modules.mercurial.ui.tag.CreateTagPanel"), null);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dd);
        okButton.setEnabled(false);
        this.panel.txtTagName.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.tagNameChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.tagNameChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }

            private void tagNameChanged() {
                okButton.setEnabled(!((CreateTag)CreateTag.this).panel.txtTagName.getText().trim().isEmpty());
            }
        });
        dialog.setVisible(true);
        return dd.getValue() == okButton;
    }

    String getTagName() {
        return this.panel.txtTagName.getText().trim();
    }

    String getMessage() {
        return this.panel.txtMessage.getText().trim();
    }

    String getRevision() {
        return this.selectedRevision.getRevisionNumber();
    }

    boolean isLocalTag() {
        return this.panel.cbLocal.isSelected();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.panel.cbLocal) {
            this.panel.txtMessage.setEnabled(!this.panel.cbLocal.isSelected());
        } else if (e.getSource() == this.panel.btnSelectRevision) {
            if (this.changesetPickerPanel == null) {
                this.changesetPickerPanel = new ChangesetPickerSimplePanel(this.repository);
            }
            if (this.changesetPickerPanel.selectRevision()) {
                HgLogMessage revisionWithChangeset = this.changesetPickerPanel.getSelectedRevision();
                this.setSelectedRevision(revisionWithChangeset);
            }
        }
    }

    private void setSelectedRevision(HgLogMessage message) {
        String value;
        this.selectedRevision = message == null ? PARENT_REVISION : message;
        if ((message = this.selectedRevision) == PARENT_REVISION) {
            value = message.getCSetShortID();
        } else {
            StringBuilder sb = new StringBuilder().append(message.getRevisionNumber());
            StringBuilder labels = new StringBuilder();
            for (String branch : message.getBranches()) {
                labels.append(branch).append(' ');
            }
            int n = 0;
            String[] stringArray = message.getTags();
            int n2 = stringArray.length;
            if (n < n2) {
                String tag = stringArray[n];
                labels.append(tag).append(' ');
            }
            sb.append(" (").append((CharSequence)labels).append(labels.length() == 0 ? "" : "- ").append(message.getCSetShortID().substring(0, 7)).append(")");
            value = sb.toString();
        }
        this.panel.txtRevision.setText(value);
        this.panel.txtRevision.setCaretPosition(0);
    }

    private void attachListeners() {
        this.panel.cbLocal.addActionListener(this);
        this.panel.btnSelectRevision.addActionListener(this);
    }

    private static class ChangesetPickerSimplePanel
    extends ChangesetPickerPanel
    implements PropertyChangeListener {
        private boolean initialized;
        private JButton selectButton;

        public ChangesetPickerSimplePanel(File repository) {
            super(repository, null);
            this.initComponents();
        }

        @Override
        protected String getRefreshLabel() {
            return NbBundle.getMessage(CreateTag.class, (String)"MSG_Fetching_Revisions");
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (this.selectButton != null && "prop.valid".equals(evt.getPropertyName())) {
                boolean valid = (Boolean)evt.getNewValue();
                this.selectButton.setEnabled(valid);
            }
        }

        private void initRevisions() {
            if (!this.initialized) {
                this.initialized = true;
                this.loadRevisions();
            }
        }

        private void initComponents() {
            Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(CreateTag.class, (String)"CreateTag.ChangesetPicker.jLabel1.text"));
            Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(CreateTag.class, (String)"CreateTag.ChangesetPicker.jLabel2.text"));
        }

        private boolean selectRevision() {
            if (this.selectButton == null) {
                this.selectButton = new JButton();
            }
            Mnemonics.setLocalizedText((AbstractButton)this.selectButton, (String)NbBundle.getMessage(CreateTag.class, (String)"CTL_CreateTag.ChangesetPicker_SelectButton"));
            DialogDescriptor dd = new DialogDescriptor((Object)this, NbBundle.getMessage(CreateTag.class, (String)"CTL_CreateTag.ChangesetPicker_Title"), true, new Object[]{this.selectButton, DialogDescriptor.CANCEL_OPTION}, (Object)this.selectButton, 0, new HelpCtx(this.getClass()), null);
            this.selectButton.setEnabled(this.getSelectedRevision() != null);
            this.addPropertyChangeListener(this);
            this.initRevisions();
            Dialog dialog = DialogDisplayer.getDefault().createDialog(dd);
            dialog.setVisible(true);
            this.removePropertyChangeListener(this);
            return dd.getValue() == this.selectButton;
        }
    }
}

