/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.containerengine.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.containerengine.model.NodeSourceOption;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class NodePoolOptions
extends ExplicitlySetBmcModel {
    @JsonProperty(value="kubernetesVersions")
    private final List<String> kubernetesVersions;
    @JsonProperty(value="shapes")
    private final List<String> shapes;
    @JsonProperty(value="images")
    private final List<String> images;
    @JsonProperty(value="sources")
    private final List<NodeSourceOption> sources;

    @Deprecated
    @ConstructorProperties(value={"kubernetesVersions", "shapes", "images", "sources"})
    public NodePoolOptions(List<String> kubernetesVersions, List<String> shapes, List<String> images, List<NodeSourceOption> sources) {
        this.kubernetesVersions = kubernetesVersions;
        this.shapes = shapes;
        this.images = images;
        this.sources = sources;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public List<String> getKubernetesVersions() {
        return this.kubernetesVersions;
    }

    public List<String> getShapes() {
        return this.shapes;
    }

    public List<String> getImages() {
        return this.images;
    }

    public List<NodeSourceOption> getSources() {
        return this.sources;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("NodePoolOptions(");
        sb.append("super=").append(super.toString());
        sb.append("kubernetesVersions=").append(String.valueOf(this.kubernetesVersions));
        sb.append(", shapes=").append(String.valueOf(this.shapes));
        sb.append(", images=").append(String.valueOf(this.images));
        sb.append(", sources=").append(String.valueOf(this.sources));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NodePoolOptions)) {
            return false;
        }
        NodePoolOptions other = (NodePoolOptions)((Object)o);
        return Objects.equals(this.kubernetesVersions, other.kubernetesVersions) && Objects.equals(this.shapes, other.shapes) && Objects.equals(this.images, other.images) && Objects.equals(this.sources, other.sources) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.kubernetesVersions == null ? 43 : this.kubernetesVersions.hashCode());
        result = result * 59 + (this.shapes == null ? 43 : this.shapes.hashCode());
        result = result * 59 + (this.images == null ? 43 : this.images.hashCode());
        result = result * 59 + (this.sources == null ? 43 : this.sources.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="kubernetesVersions")
        private List<String> kubernetesVersions;
        @JsonProperty(value="shapes")
        private List<String> shapes;
        @JsonProperty(value="images")
        private List<String> images;
        @JsonProperty(value="sources")
        private List<NodeSourceOption> sources;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder kubernetesVersions(List<String> kubernetesVersions) {
            this.kubernetesVersions = kubernetesVersions;
            this.__explicitlySet__.add("kubernetesVersions");
            return this;
        }

        public Builder shapes(List<String> shapes) {
            this.shapes = shapes;
            this.__explicitlySet__.add("shapes");
            return this;
        }

        public Builder images(List<String> images) {
            this.images = images;
            this.__explicitlySet__.add("images");
            return this;
        }

        public Builder sources(List<NodeSourceOption> sources) {
            this.sources = sources;
            this.__explicitlySet__.add("sources");
            return this;
        }

        public NodePoolOptions build() {
            NodePoolOptions model = new NodePoolOptions(this.kubernetesVersions, this.shapes, this.images, this.sources);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(NodePoolOptions model) {
            if (model.wasPropertyExplicitlySet("kubernetesVersions")) {
                this.kubernetesVersions(model.getKubernetesVersions());
            }
            if (model.wasPropertyExplicitlySet("shapes")) {
                this.shapes(model.getShapes());
            }
            if (model.wasPropertyExplicitlySet("images")) {
                this.images(model.getImages());
            }
            if (model.wasPropertyExplicitlySet("sources")) {
                this.sources(model.getSources());
            }
            return this;
        }
    }
}

