/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.transport.tcp.io;

import com.sun.xml.ws.util.ByteArrayBuffer;
import java.io.IOException;
import java.io.InputStream;

public class BufferedMessageInputStream
extends InputStream {
    private InputStream inputStream;
    private boolean isClosed;
    private boolean isBuffered;
    private int bufferedSize;

    public BufferedMessageInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
        this.isBuffered = false;
    }

    @Override
    public int read() throws IOException {
        return this.inputStream.read();
    }

    @Override
    public int read(byte[] b, int offset, int length) throws IOException {
        return this.inputStream.read(b, offset, length);
    }

    public void bufferMessage() throws IOException {
        if (!this.isBuffered) {
            try (ByteArrayBuffer baBuffer = new ByteArrayBuffer();){
                baBuffer.write(this.inputStream);
                this.inputStream = baBuffer.newInputStream();
                this.bufferedSize = baBuffer.size();
                this.isBuffered = true;
            }
        }
    }

    public InputStream getSourceInputStream() {
        return this.inputStream;
    }

    public int getBufferedSize() {
        if (this.isBuffered) {
            return this.bufferedSize;
        }
        return 0;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public boolean isBuffered() {
        return this.isBuffered;
    }

    @Override
    public void close() throws IOException {
        this.isClosed = true;
        this.inputStream.close();
    }
}

