/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.entitygenerator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.netbeans.modules.j2ee.persistence.entitygenerator.CMPMappingModel;
import org.netbeans.modules.j2ee.persistence.entitygenerator.EntityMember;
import org.netbeans.modules.j2ee.persistence.entitygenerator.RelationshipRole;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.UpdateType;
import org.openide.filesystems.FileObject;

public class EntityClass {
    private final String catalogName;
    private final String schemaName;
    private final String tableName;
    private final FileObject rootFolder;
    private final String className;
    private final String packageName;
    private final Set<List<String>> uniqueConstraints;
    private final UpdateType updateType;
    private List<RelationshipRole> roles;
    private List<EntityMember> fields;
    private boolean usePkField;
    private boolean derivedIdCandidate;
    private String pkFieldName;
    private CMPMappingModel mappingModel;
    private boolean forTable = true;
    private final boolean useDefaults;

    public EntityClass(String catalogName, String schemaName, String tableName, FileObject rootFolder, String packageName, String className, UpdateType updateType, boolean useDefaults, Set<List<String>> uniqueConstraints) {
        this.catalogName = catalogName;
        this.schemaName = schemaName;
        this.tableName = tableName;
        this.rootFolder = rootFolder;
        this.packageName = packageName;
        this.className = className;
        this.updateType = updateType;
        this.uniqueConstraints = uniqueConstraints;
        this.useDefaults = useDefaults;
        this.roles = Collections.emptyList();
        this.fields = new ArrayList<EntityMember>();
        this.mappingModel = new CMPMappingModel();
    }

    public boolean isForTable() {
        return this.forTable;
    }

    public void setIsForTable(boolean forTable) {
        this.forTable = forTable;
    }

    public Set<List<String>> getUniqueConstraints() {
        return this.uniqueConstraints;
    }

    public void addRole(RelationshipRole role) {
        if (this.roles == Collections.emptyList()) {
            this.roles = new ArrayList<RelationshipRole>();
        }
        this.roles.add(role);
    }

    public List<RelationshipRole> getRoles() {
        return this.roles;
    }

    public List<EntityMember> getFields() {
        return this.fields;
    }

    public boolean getUseDefaults() {
        return this.useDefaults;
    }

    public void setFields(List<EntityMember> fields) {
        this.fields = fields;
    }

    public String toString() {
        String cmpFields = "";
        for (EntityMember entityMember : this.getFields()) {
            cmpFields = cmpFields + " " + entityMember.getMemberName() + (entityMember.isPrimaryKey() ? " (PK) " : " ");
        }
        return "bean name " + this.getClassName() + "\ncmp-fields " + cmpFields;
    }

    public FileObject getRootFolder() {
        return this.rootFolder;
    }

    public String getPackage() {
        return this.packageName;
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getClassName() {
        return this.className;
    }

    public UpdateType getUpdateType() {
        return this.updateType;
    }

    public FileObject getPackageFileObject() {
        String relative = this.packageName.replace('.', '/');
        return this.rootFolder.getFileObject(relative);
    }

    public CMPMappingModel getCMPMapping() {
        this.mappingModel.getCMPFieldMapping().clear();
        for (EntityMember entityMember : this.getFields()) {
            this.mappingModel.setTableName(entityMember.getTableName());
            this.mappingModel.getCMPFieldMapping().put(entityMember.getMemberName(), entityMember.getColumnName());
        }
        return this.mappingModel;
    }

    public void usePkField(boolean usePkField) {
        this.usePkField = usePkField;
    }

    public boolean isUsePkField() {
        return this.usePkField;
    }

    public String getPkFieldName() {
        return this.pkFieldName;
    }

    public void setPkFieldName(String pkFieldName) {
        this.pkFieldName = pkFieldName;
    }

    public boolean isDerivedIdCandidate() {
        return this.derivedIdCandidate;
    }

    public void setDerivedIdCandidate(boolean derivedIdCandidate) {
        this.derivedIdCandidate = derivedIdCandidate;
    }
}

