/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.lang.JavaScriptLanguage;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.interop.ExportValueNode;
import com.oracle.truffle.js.nodes.interop.JSInteropExecuteNode;
import com.oracle.truffle.js.nodes.interop.JSInteropInstantiateNode;
import com.oracle.truffle.js.nodes.unary.IsCallableNode;
import com.oracle.truffle.js.runtime.JSException;
import com.oracle.truffle.js.runtime.JSFrameUtil;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.builtins.JSFunctionData;
import com.oracle.truffle.js.runtime.builtins.JSProxy;
import com.oracle.truffle.js.runtime.interop.InteropFunction;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSNonProxyObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.Null;
import com.oracle.truffle.js.runtime.objects.Undefined;

@ExportLibrary(value=InteropLibrary.class)
public abstract class JSFunctionObject
extends JSNonProxyObject {
    private final JSFunctionData functionData;
    private final MaterializedFrame enclosingFrame;
    private final JSRealm realm;
    private Object classPrototype;

    protected JSFunctionObject(Shape shape, JSDynamicObject proto, JSFunctionData functionData, MaterializedFrame enclosingFrame, JSRealm realm, Object classPrototype) {
        super(shape, proto);
        this.functionData = functionData;
        this.enclosingFrame = enclosingFrame;
        this.realm = realm;
        this.classPrototype = classPrototype;
    }

    public final JSFunctionData getFunctionData() {
        return this.functionData;
    }

    public final MaterializedFrame getEnclosingFrame() {
        return this.enclosingFrame;
    }

    public final JSRealm getRealm() {
        return this.realm;
    }

    public final Object getClassPrototype() {
        return this.classPrototype;
    }

    public void setClassPrototype(Object classPrototype) {
        this.classPrototype = classPrototype;
    }

    public Object getLexicalThis() {
        return this.classPrototype;
    }

    @Override
    public TruffleString getClassName() {
        return JSFunction.INSTANCE.getClassName(this);
    }

    @Override
    public TruffleString getBuiltinToStringTag() {
        return JSFunction.INSTANCE.getBuiltinToStringTag(this);
    }

    @ExportMessage
    public final boolean isExecutable(@Cached IsCallableNode isCallable) {
        return isCallable.executeBoolean((Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExportMessage
    public final Object execute(Object[] args, @CachedLibrary(value="this") InteropLibrary self, @Cached JSInteropExecuteNode callNode, @Cached.Shared(value="exportValue") @Cached ExportValueNode exportNode) throws UnsupportedMessageException {
        JavaScriptLanguage language = JavaScriptLanguage.get((Node)self);
        language.interopBoundaryEnter(this.realm);
        try {
            Object result = callNode.execute(this, (Object)Undefined.instance, args);
            Object object = exportNode.execute(result);
            return object;
        }
        finally {
            language.interopBoundaryExit(this.realm);
        }
    }

    @ExportMessage
    public final boolean isInstantiable() {
        return JSRuntime.isConstructor((Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExportMessage
    public final Object instantiate(Object[] args, @CachedLibrary(value="this") InteropLibrary self, @Cached JSInteropInstantiateNode callNode, @Cached.Shared(value="exportValue") @Cached ExportValueNode exportNode) throws UnsupportedMessageException {
        JavaScriptLanguage language = JavaScriptLanguage.get((Node)self);
        language.interopBoundaryEnter(this.realm);
        try {
            Object result = callNode.execute(this, args);
            Object object = exportNode.execute(result);
            return object;
        }
        finally {
            language.interopBoundaryExit(this.realm);
        }
    }

    @ExportMessage
    public final boolean hasSourceLocation() {
        return JSFunctionObject.getSourceLocationImpl(this) != null;
    }

    @ExportMessage
    public final SourceSection getSourceLocation() throws UnsupportedMessageException {
        SourceSection sourceSection = JSFunctionObject.getSourceLocationImpl(this);
        if (sourceSection == null) {
            throw UnsupportedMessageException.create();
        }
        return sourceSection;
    }

    @CompilerDirectives.TruffleBoundary
    private static SourceSection getSourceLocationImpl(JSDynamicObject receiver) {
        CallTarget ct;
        Object function = receiver;
        while (JSFunction.isBoundFunction(function)) {
            function = JSFunction.getBoundTargetFunction((JSFunctionObject)((Object)function));
        }
        if (JSFunction.isJSFunction(function) && (ct = JSFunction.getCallTarget((JSFunctionObject)((Object)function))) instanceof RootCallTarget) {
            return ((RootCallTarget)ct).getRootNode().getSourceSection();
        }
        return null;
    }

    @ExportMessage
    public final boolean isMetaObject() {
        return true;
    }

    @CompilerDirectives.TruffleBoundary
    @ExportMessage.Repeat(value={@ExportMessage(name="getMetaQualifiedName"), @ExportMessage(name="getMetaSimpleName")})
    public final Object getMetaObjectName() {
        Object name = JSRuntime.getDataProperty(this, JSFunction.NAME);
        if (Strings.isTString(name)) {
            return name;
        }
        return Strings.EMPTY_STRING;
    }

    @CompilerDirectives.TruffleBoundary
    @ExportMessage
    public final boolean isMetaInstance(Object instance) {
        Object constructorPrototype = JSRuntime.getDataProperty(this, JSObject.PROTOTYPE);
        if (JSGuards.isJSObject(constructorPrototype)) {
            Object obj = instance;
            if (obj instanceof InteropFunction) {
                obj = ((InteropFunction)obj).getFunction();
            }
            if (obj instanceof JSException) {
                obj = ((JSException)((Object)obj)).getErrorObject();
            }
            if (JSGuards.isJSObject(obj) && !JSProxy.isJSProxy(obj)) {
                JSDynamicObject proto = JSObject.getPrototype((JSDynamicObject)((Object)obj));
                while (proto != Null.instance) {
                    if (proto == constructorPrototype) {
                        return true;
                    }
                    if (JSProxy.isJSProxy((Object)proto)) break;
                    proto = JSObject.getPrototype(proto);
                }
            }
        }
        return false;
    }

    public static JSFunctionObject create(Shape shape, JSDynamicObject proto, JSFunctionData functionData, MaterializedFrame enclosingFrame, JSRealm realm, Object classPrototype) {
        return new Unbound(shape, proto, functionData, enclosingFrame, realm, classPrototype);
    }

    public static JSFunctionObject createBound(Shape shape, JSDynamicObject proto, JSFunctionData functionData, JSRealm realm, Object classPrototype, Object boundTargetFunction, Object boundThis, Object[] boundArguments) {
        return new Bound(shape, proto, functionData, realm, classPrototype, boundTargetFunction, boundThis, boundArguments);
    }

    public static JSFunctionObject createWrapped(Shape shape, JSDynamicObject proto, JSFunctionData functionData, JSRealm realm, Object boundTargetFunction) {
        return new Wrapped(shape, proto, functionData, realm, boundTargetFunction);
    }

    public static final class Unbound
    extends JSFunctionObject {
        protected Unbound(Shape shape, JSDynamicObject proto, JSFunctionData functionData, MaterializedFrame enclosingFrame, JSRealm realm, Object classPrototype) {
            super(shape, proto, functionData, enclosingFrame, realm, classPrototype);
        }
    }

    public static final class Bound
    extends BoundOrWrapped {
        private final Object boundTargetFunction;
        private final Object boundThis;
        private final Object[] boundArguments;

        protected Bound(Shape shape, JSDynamicObject proto, JSFunctionData functionData, JSRealm realm, Object classPrototype, Object boundTargetFunction, Object boundThis, Object[] boundArguments) {
            super(shape, proto, functionData, JSFrameUtil.NULL_MATERIALIZED_FRAME, realm, classPrototype);
            this.boundTargetFunction = boundTargetFunction;
            this.boundThis = boundThis;
            this.boundArguments = boundArguments;
        }

        public Object getBoundTargetFunction() {
            return this.boundTargetFunction;
        }

        public Object getBoundThis() {
            return this.boundThis;
        }

        public Object[] getBoundArguments() {
            return this.boundArguments;
        }

        @Override
        protected void initializeName() {
            this.setBoundName(Bound.getFunctionName((JSFunctionObject)((Object)this.getBoundTargetFunction())), Strings.BOUND_SPC);
        }
    }

    public static final class Wrapped
    extends BoundOrWrapped {
        private final Object wrappedTargetFunction;

        protected Wrapped(Shape shape, JSDynamicObject proto, JSFunctionData functionData, JSRealm realm, Object wrappedTargetFunction) {
            super(shape, proto, functionData, JSFrameUtil.NULL_MATERIALIZED_FRAME, realm, JSFunction.CLASS_PROTOTYPE_PLACEHOLDER);
            this.wrappedTargetFunction = wrappedTargetFunction;
        }

        public Object getWrappedTargetFunction() {
            return this.wrappedTargetFunction;
        }

        @Override
        protected void initializeName() {
            this.setBoundName(Wrapped.getFunctionName((JSFunctionObject)((Object)this.getWrappedTargetFunction())), Strings.EMPTY_STRING);
        }
    }

    public static abstract class BoundOrWrapped
    extends JSFunctionObject {
        private int boundLength;
        private TruffleString boundName;

        protected BoundOrWrapped(Shape shape, JSDynamicObject proto, JSFunctionData functionData, MaterializedFrame enclosingFrame, JSRealm realm, Object classPrototype) {
            super(shape, proto, functionData, enclosingFrame, realm, classPrototype);
        }

        public final TruffleString getBoundName() {
            if (CompilerDirectives.injectBranchProbability((double)0.25, (this.boundName == null ? 1 : 0) != 0)) {
                this.initializeName();
            }
            return this.boundName;
        }

        public final void setBoundName(TruffleString targetName, TruffleString prefix) {
            this.boundName = Strings.isEmpty(prefix) ? targetName : BoundOrWrapped.concat(prefix, targetName);
        }

        @CompilerDirectives.TruffleBoundary
        private static TruffleString concat(TruffleString first, TruffleString second) {
            return Strings.concat(first, second);
        }

        protected abstract void initializeName();

        @CompilerDirectives.TruffleBoundary
        protected static TruffleString getFunctionName(JSFunctionObject function) {
            if (function instanceof BoundOrWrapped) {
                return ((BoundOrWrapped)function).getBoundName();
            }
            return JSFunction.getName(function);
        }

        public final int getBoundLength() {
            return this.boundLength;
        }

        public final void setBoundLength(int length) {
            assert (this.boundLength == 0);
            this.boundLength = length;
        }
    }
}

