/*
 * Decompiled with CFR 0.152.
 */
package net.loomchild.maligna.formatter;

import java.io.PrintWriter;
import java.io.Writer;
import java.util.List;
import net.loomchild.maligna.coretypes.Alignment;
import net.loomchild.maligna.formatter.Formatter;
import net.loomchild.maligna.util.Util;

public class PlaintextFormatter
implements Formatter {
    private PrintWriter sourceWriter;
    private PrintWriter targetWriter;

    public PlaintextFormatter(Writer sourceWriter, Writer targetWriter) {
        this.sourceWriter = new PrintWriter(sourceWriter, true);
        this.targetWriter = new PrintWriter(targetWriter, true);
    }

    @Override
    public void format(List<Alignment> alignmentList) {
        for (Alignment alignment : alignmentList) {
            this.printSegmentList(this.sourceWriter, alignment.getSourceSegmentList());
            this.printSegmentList(this.targetWriter, alignment.getTargetSegmentList());
        }
    }

    private void printSegmentList(PrintWriter writer, List<String> segmentList) {
        String segment = Util.merge(segmentList);
        segment = segment.replace("\n", " ");
        writer.println(segment);
    }
}

