/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.editor.history;

import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.omegat.core.Core;
import org.omegat.core.CoreEvents;
import org.omegat.core.data.IProject;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.data.TMXEntry;
import org.omegat.core.events.IEntryEventListener;
import org.omegat.core.events.IProjectEventListener;
import org.omegat.gui.editor.autocompleter.AutoCompleterItem;
import org.omegat.gui.editor.autocompleter.AutoCompleterListView;
import org.omegat.gui.editor.history.WordPredictor;
import org.omegat.tokenizer.ITokenizer;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;

public class HistoryPredictor
extends AutoCompleterListView {
    private static final Logger LOGGER = Logger.getLogger(HistoryPredictor.class.getName());
    WordPredictor predictor = new WordPredictor();
    private SourceTextEntry currentEntry;
    private boolean isCurrentEntryTranslated;

    public HistoryPredictor() {
        super(OStrings.getString("AC_HISTORY_PREDICTIONS_VIEW"));
        CoreEvents.registerProjectChangeListener(eventType -> {
            if (this.isEnabled() && eventType == IProjectEventListener.PROJECT_CHANGE_TYPE.LOAD) {
                this.train();
            }
        });
        CoreEvents.registerEntryEventListener(new IEntryEventListener(){

            @Override
            public void onNewFile(String activeFileName) {
            }

            @Override
            public void onEntryActivated(SourceTextEntry newEntry) {
                TMXEntry newTranslation;
                if (!HistoryPredictor.this.isEnabled()) {
                    return;
                }
                IProject project = Core.getProject();
                if (!project.isProjectLoaded()) {
                    return;
                }
                SourceTextEntry lastEntry = HistoryPredictor.this.currentEntry;
                boolean wasTranslated = HistoryPredictor.this.isCurrentEntryTranslated;
                if (lastEntry != null && !wasTranslated && (newTranslation = project.getTranslationInfo(lastEntry)).isTranslated()) {
                    HistoryPredictor.this.trainString(newTranslation.translation);
                }
                HistoryPredictor.this.currentEntry = newEntry;
                HistoryPredictor.this.isCurrentEntryTranslated = project.getTranslationInfo(newEntry).isTranslated();
            }
        });
        Preferences.addPropertyChangeListener("history_completer_prediction_enabled", evt -> {
            if (((Boolean)evt.getNewValue()).booleanValue()) {
                if (Core.getProject().isProjectLoaded()) {
                    this.train();
                }
            } else {
                this.predictor.reset();
            }
        });
    }

    synchronized void train() {
        IProject project = Core.getProject();
        if (!project.isProjectLoaded()) {
            return;
        }
        long start = System.currentTimeMillis();
        this.predictor.reset();
        project.iterateByDefaultTranslations((source, trans) -> this.trainString(trans.translation));
        project.iterateByMultipleTranslations((source, trans) -> this.trainString(trans.translation));
        long time = System.currentTimeMillis() - start;
        LOGGER.finer(() -> String.format("Time to train History Predictor: %d ms", time));
    }

    private void trainString(String text) {
        if (text == null) {
            return;
        }
        String[] tokens = this.getTokenizer().tokenizeWordsToStrings(text, ITokenizer.StemmingMode.NONE);
        this.predictor.train(tokens);
    }

    @Override
    public List<AutoCompleterItem> computeListData(String prevText, boolean contextualOnly) {
        if (prevText == null || prevText.isEmpty()) {
            return Collections.emptyList();
        }
        String[] tokens = this.getTokenizer().tokenizeVerbatimToStrings(prevText);
        String seed = this.lastFullWordToken(tokens);
        if (seed.isEmpty()) {
            return Collections.emptyList();
        }
        List<AutoCompleterItem> predictions = this.predictor.predictWord(seed).stream().map(p -> new AutoCompleterItem(p.getWord(), new String[]{String.valueOf(Math.round(p.getFrequency())) + "%"}, 0)).collect(Collectors.toList());
        if (predictions.isEmpty()) {
            return predictions;
        }
        if (!this.isLanguageSpaceDelimited()) {
            return predictions;
        }
        if (tokens[tokens.length - 1].trim().isEmpty()) {
            return predictions;
        }
        String context = tokens[tokens.length - 1];
        return predictions.stream().filter(item -> item.payload.startsWith(context) && !item.payload.equals(context)).map(item -> new AutoCompleterItem(item.payload, item.extras, context.length())).collect(Collectors.toList());
    }

    private String lastFullWordToken(String[] tokens) {
        int startOffset = this.isLanguageSpaceDelimited() ? 2 : 1;
        for (int i = tokens.length - startOffset; i >= 0; --i) {
            String token = tokens[i];
            if (token.trim().isEmpty()) continue;
            return token;
        }
        return "";
    }

    @Override
    public String itemToString(AutoCompleterItem item) {
        return "<html>" + item.payload + " <font color=\"gray\">(" + item.extras[0] + ")</font></html>";
    }

    @Override
    protected boolean isEnabled() {
        return Preferences.isPreference("history_completer_prediction_enabled");
    }

    private boolean isLanguageSpaceDelimited() {
        return this.getTargetLanguage().isSpaceDelimited();
    }
}

