/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.preferences.view;

import java.awt.Toolkit;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.omegat.core.Core;
import org.omegat.gui.preferences.BasePreferencesController;
import org.omegat.gui.preferences.view.AutoCompleterPreferencesPanel;
import org.omegat.util.OStrings;
import org.omegat.util.Platform;
import org.omegat.util.Preferences;
import org.omegat.util.gui.StaticUIUtils;

public class AutoCompleterController
extends BasePreferencesController {
    private AutoCompleterPreferencesPanel panel;

    @Override
    public JComponent getGui() {
        if (this.panel == null) {
            this.initGui();
            this.initFromPrefs();
        }
        return this.panel;
    }

    @Override
    public String toString() {
        return OStrings.getString("PREFS_TITLE_AUTOCOMPLETER");
    }

    private void initGui() {
        this.panel = new AutoCompleterPreferencesPanel();
        int mask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        KeyStroke left = KeyStroke.getKeyStroke(37, mask);
        KeyStroke right = KeyStroke.getKeyStroke(39, mask);
        this.panel.switchWithLRCheckBox.setText(OStrings.getString("PREFS_AUTOCOMPLETE_SWITCH_VIEWS_LR", StaticUIUtils.getKeyStrokeText(left), StaticUIUtils.getKeyStrokeText(right)));
        this.panel.switchWithLRCheckBox.setVisible(Platform.isMacOSX());
    }

    @Override
    protected void initFromPrefs() {
        this.panel.automaticCheckBox.setSelected(Preferences.isPreference("ac_show_suggestions_automatically"));
        this.panel.switchWithLRCheckBox.setSelected(Preferences.isPreference("ac_switch_views_with_lr"));
    }

    @Override
    public void restoreDefaults() {
        this.panel.automaticCheckBox.setSelected(false);
    }

    @Override
    public void persist() {
        Preferences.setPreference("ac_show_suggestions_automatically", this.panel.automaticCheckBox.isSelected());
        Preferences.setPreference("ac_switch_views_with_lr", this.panel.switchWithLRCheckBox.isSelected());
        Core.getEditor().getAutoCompleter().resetKeys();
    }
}

