/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.preferences.view;

import javax.swing.JComponent;
import org.omegat.gui.preferences.BasePreferencesController;
import org.omegat.gui.preferences.view.DictionaryPreferencesPanel;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;

public class DictionaryPreferencesController
extends BasePreferencesController {
    private DictionaryPreferencesPanel panel;

    @Override
    public JComponent getGui() {
        if (this.panel == null) {
            this.initGui();
            this.initFromPrefs();
        }
        return this.panel;
    }

    @Override
    public String toString() {
        return OStrings.getString("PREFS_TITLE_DICTIONARY");
    }

    private void initGui() {
        this.panel = new DictionaryPreferencesPanel();
    }

    @Override
    protected void initFromPrefs() {
        this.panel.fuzzyMatchingCheckBox.setSelected(Preferences.isPreference("dictionary_fuzzy_matching"));
        this.panel.autoCheckSegmentsCheckBox.setSelected(Preferences.isPreferenceDefault("dictionary_auto_search", true));
    }

    @Override
    public void restoreDefaults() {
        this.panel.fuzzyMatchingCheckBox.setSelected(false);
        this.panel.autoCheckSegmentsCheckBox.setSelected(true);
    }

    @Override
    public void persist() {
        Preferences.setPreference("dictionary_fuzzy_matching", this.panel.fuzzyMatchingCheckBox.isSelected());
        Preferences.setPreference("dictionary_auto_search", this.panel.autoCheckSegmentsCheckBox.isSelected());
    }
}

