/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.preferences.view;

import java.io.File;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.omegat.core.Core;
import org.omegat.core.spellchecker.DictionaryManager;
import org.omegat.core.spellchecker.ISpellChecker;
import org.omegat.core.spellchecker.SpellChecker;
import org.omegat.gui.dialogs.DictionaryInstallerDialog;
import org.omegat.gui.preferences.BasePreferencesController;
import org.omegat.gui.preferences.view.SpellcheckerConfigurationPanel;
import org.omegat.util.Language;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.omegat.util.StringUtil;
import org.omegat.util.gui.StaticUIUtils;

public class SpellcheckerConfigurationController
extends BasePreferencesController {
    private static final String OLD_DICT_URL = "http://ftp.services.openoffice.org/pub/OpenOffice.org/contrib/dictionaries/";
    public static final String DICT_URL = "http://download.services.openoffice.org/files/contrib/dictionaries/";
    private SpellcheckerConfigurationPanel panel;
    private DictionaryManager dicMan;

    @Override
    public JComponent getGui() {
        if (this.panel == null) {
            this.initGui();
            this.initFromPrefs();
        }
        return this.panel;
    }

    @Override
    public String toString() {
        return OStrings.getString("PREFS_TITLE_SPELLCHECKER");
    }

    private void initGui() {
        this.panel = new SpellcheckerConfigurationPanel();
        this.panel.autoSpellcheckCheckBox.addActionListener(e -> this.updateDetailPanel());
        this.panel.directoryTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                SpellcheckerConfigurationController.this.directoryChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                SpellcheckerConfigurationController.this.directoryChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                SpellcheckerConfigurationController.this.directoryChanged();
            }
        });
        this.panel.dictionaryUrlTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                SpellcheckerConfigurationController.this.dictUrlChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                SpellcheckerConfigurationController.this.dictUrlChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                SpellcheckerConfigurationController.this.dictUrlChanged();
            }
        });
        this.panel.directoryTextField.addActionListener(e -> this.updateLanguageList());
        this.panel.directoryChooserButton.addActionListener(e -> this.chooseDirectory());
        this.panel.languageList.addListSelectionListener(e -> this.listSelectionChanged());
        this.panel.languageList.setModel(new DefaultListModel());
        this.panel.installButton.addActionListener(e -> this.doInstall());
        this.panel.uninstallButton.addActionListener(e -> this.doUninstall());
    }

    private void doInstall() {
        File dicDir = this.getDictDir();
        if (dicDir == null) {
            JOptionPane.showMessageDialog(this.panel, OStrings.getString("GUI_SPELLCHECKER_INSTALL_UNABLE"), OStrings.getString("GUI_SPELLCHECKER_INSTALL_UNABLE_TITLE"), 0);
            return;
        }
        if (!dicDir.exists()) {
            int doCreateDir = JOptionPane.showConfirmDialog(this.panel, OStrings.getString("GUI_SPELLCHECKER_DIR_NOT_PRESENT"), OStrings.getString("GUI_SPELLCHECKER_DIR_NOT_PRESENT_TITLE"), 2);
            if (doCreateDir != 0) {
                return;
            }
            if (!dicDir.mkdirs()) {
                JOptionPane.showMessageDialog(this.panel, OStrings.getString("GUI_SPELLCHECKER_COULD_NOT_CREATE_DIR"), OStrings.getString("ERROR_TITLE"), 0);
                return;
            }
        }
        Preferences.setPreference("dictionary_url", this.panel.dictionaryUrlTextField.getText());
        try {
            DictionaryInstallerDialog installerDialog = new DictionaryInstallerDialog(SwingUtilities.getWindowAncestor(this.panel), this.dicMan);
            installerDialog.setVisible(true);
            this.updateLanguageList();
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this.panel, ex.getLocalizedMessage(), OStrings.getString("ERROR_TITLE"), 0);
        }
    }

    private void doUninstall() {
        if (this.dicMan == null) {
            return;
        }
        List<String> selection = this.panel.languageList.getSelectedValuesList();
        for (String selectedItem : selection) {
            String selectedLocaleName = selectedItem.substring(0, selectedItem.indexOf(" "));
            if (selectedLocaleName.equals(this.getCurrentLanguage().getLocaleCode()) && JOptionPane.showConfirmDialog(this.panel, OStrings.getString("GUI_SPELLCHECKER_UNINSTALL_CURRENT"), OStrings.getString("GUI_SPELLCHECKER_UNINSTALL_CURRENT_TITLE"), 0) == 1) {
                return;
            }
            if (!this.dicMan.uninstallDictionary(selectedLocaleName)) {
                JOptionPane.showMessageDialog(this.panel, OStrings.getString("GUI_SPELLCHECKER_UNINSTALL_UNABLE"), OStrings.getString("GUI_SPELLCHECKER_UNINSTALL_UNABLE_TITLE"), 0);
            }
            ((DefaultListModel)this.panel.languageList.getModel()).remove(this.panel.languageList.getSelectedIndex());
        }
    }

    private void chooseDirectory() {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setFileSelectionMode(1);
        fileChooser.setDialogTitle(OStrings.getString("GUI_SPELLCHECKER_FILE_CHOOSER_TITLE"));
        if (fileChooser.showOpenDialog(this.panel) == 0) {
            File file = fileChooser.getSelectedFile();
            this.panel.directoryTextField.setText(file.getAbsolutePath());
        }
    }

    private void listSelectionChanged() {
        List<String> selection = this.panel.languageList.getSelectedValuesList();
        this.panel.uninstallButton.setEnabled(!selection.isEmpty() && this.panel.autoSpellcheckCheckBox.isSelected());
    }

    private File getDictDir() {
        String dirName = this.panel.directoryTextField.getText();
        if (StringUtil.isEmpty(dirName)) {
            return null;
        }
        File dir = new File(dirName);
        if (dir.isFile() || dir.exists() && !dir.canRead()) {
            return null;
        }
        return dir;
    }

    private void directoryChanged() {
        this.dictUrlChanged();
        this.updateLanguageList();
    }

    private void updateDetailPanel() {
        StaticUIUtils.setHierarchyEnabled(this.panel.detailPanel, this.panel.autoSpellcheckCheckBox.isSelected());
        this.directoryChanged();
    }

    private void dictUrlChanged() {
        File dictDir = this.getDictDir();
        this.panel.installButton.setEnabled(this.panel.autoSpellcheckCheckBox.isSelected() && dictDir != null && dictDir.canWrite() && !this.panel.dictionaryUrlTextField.getText().isEmpty());
    }

    private void updateLanguageList() {
        DefaultListModel languageListModel = (DefaultListModel)this.panel.languageList.getModel();
        languageListModel.clear();
        File dir = this.getDictDir();
        if (dir == null) {
            return;
        }
        this.dicMan = new DictionaryManager(dir);
        this.dicMan.getLocalDictionaryNameList().stream().sorted().forEach(languageListModel::addElement);
    }

    protected Language getCurrentLanguage() {
        if (Core.getProject().isProjectLoaded()) {
            return Core.getProject().getProjectProperties().getTargetLanguage();
        }
        return new Language(Preferences.getPreference("target_lang"));
    }

    @Override
    protected void initFromPrefs() {
        this.panel.autoSpellcheckCheckBox.setSelected(Preferences.isPreference("allow_auto_spellchecking"));
        this.updateDetailPanel();
        String dictionaryUrl = Preferences.getPreference("dictionary_url");
        if (dictionaryUrl.isEmpty() || OLD_DICT_URL.equalsIgnoreCase(dictionaryUrl)) {
            dictionaryUrl = DICT_URL;
        }
        this.panel.dictionaryUrlTextField.setText(dictionaryUrl);
        this.directoryChanged();
        this.listSelectionChanged();
        String dictDirPath = Preferences.getPreferenceDefault("spellcheker_dir", SpellChecker.DEFAULT_DICTIONARY_DIR.getPath());
        this.panel.directoryTextField.setText(dictDirPath);
        File dictDir = new File(dictDirPath);
        if (!dictDir.exists()) {
            dictDir.mkdirs();
        }
    }

    @Override
    public void restoreDefaults() {
        this.panel.autoSpellcheckCheckBox.setSelected(false);
        this.panel.dictionaryUrlTextField.setText(DICT_URL);
        this.directoryChanged();
        this.listSelectionChanged();
        File dictDir = SpellChecker.DEFAULT_DICTIONARY_DIR;
        this.panel.directoryTextField.setText(dictDir.getPath());
        if (!dictDir.exists()) {
            dictDir.mkdirs();
        }
    }

    @Override
    public void persist() {
        boolean isNeedToSpell = this.panel.autoSpellcheckCheckBox.isSelected();
        Preferences.setPreference("allow_auto_spellchecking", isNeedToSpell);
        Preferences.setPreference("spellcheker_dir", this.panel.directoryTextField.getText());
        Preferences.setPreference("dictionary_url", this.panel.dictionaryUrlTextField.getText());
        if (isNeedToSpell && Core.getProject().isProjectLoaded()) {
            ISpellChecker sc = Core.getSpellChecker();
            sc.destroy();
            sc.initialize();
        }
        SwingUtilities.invokeLater(() -> Core.getEditor().getSettings().setAutoSpellChecking(isNeedToSpell));
    }
}

