/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.scripting;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.script.ScriptEngineFactory;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.SwingWorker;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.apache.commons.io.FilenameUtils;
import org.omegat.core.Core;
import org.omegat.core.CoreEvents;
import org.omegat.core.events.IApplicationEventListener;
import org.omegat.gui.scripting.AbstractScriptEditor;
import org.omegat.gui.scripting.IScriptLogger;
import org.omegat.gui.scripting.ScriptItem;
import org.omegat.gui.scripting.ScriptRunner;
import org.omegat.gui.scripting.ScriptSet;
import org.omegat.gui.scripting.ScriptsMonitor;
import org.omegat.gui.scripting.StandardScriptEditor;
import org.omegat.gui.shortcuts.PropertiesShortcuts;
import org.omegat.help.Help;
import org.omegat.util.Log;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.omegat.util.StringUtil;
import org.omegat.util.gui.OSXIntegration;
import org.omegat.util.gui.StaticUIUtils;
import org.openide.awt.Mnemonics;

public class ScriptingWindow {
    private static final Logger LOGGER = Logger.getLogger(ScriptingWindow.class.getName());
    static ScriptingWindow window;
    final JFrame frame;
    public static final String DEFAULT_SCRIPTS_DIR = "scripts";
    protected static final int NUMBERS_OF_QUICK_SCRIPTS = 12;
    private JList<ScriptItem> m_scriptList;
    private JEditorPane m_txtResult;
    private AbstractScriptEditor m_txtScriptEditor;
    private JButton m_btnRunScript;
    private JButton m_btnCancelScript;
    private JMenuBar mb;
    private ScriptWorker scriptWorker;
    protected ScriptsMonitor monitor;
    private File m_scriptsDirectory;
    private ScriptItem m_currentScriptItem;
    private JTextField m_txtScriptsDir;
    private JMenu m_setsMenu = new JMenu();
    private final String[] m_quickScripts = new String[12];
    private final JMenuItem[] m_quickMenus = new JMenuItem[12];
    private final JButton[] m_quickScriptButtons = new JButton[12];

    public static void loadPlugins() {
        CoreEvents.registerApplicationEventListener(new IApplicationEventListener(){

            @Override
            public void onApplicationStartup() {
                window = new ScriptingWindow();
            }

            @Override
            public void onApplicationShutdown() {
            }
        });
    }

    public static void unloadPlugins() {
        if (window != null) {
            ScriptingWindow.window.frame.dispose();
        }
    }

    public ScriptingWindow() {
        this.frame = new JFrame(OStrings.getString("SCW_TITLE"));
        StaticUIUtils.setWindowIcon(this.frame);
        StaticUIUtils.setEscapeClosable(this.frame);
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ScriptingWindow.this.monitor.stop();
            }
        });
        this.setScriptsDirectory(Preferences.getPreferenceDefault("scripts_dir", DEFAULT_SCRIPTS_DIR));
        this.initWindowLayout();
        this.addScriptCommandToOmegaT();
        this.addRunShortcutToOmegaT();
        this.updateQuickScripts();
        this.monitor = new ScriptsMonitor(this);
        if (this.m_scriptsDirectory != null) {
            this.monitor.start(this.m_scriptsDirectory);
        }
        this.logResult(this.listScriptEngines());
    }

    private String listScriptEngines() {
        StringBuilder sb = new StringBuilder(OStrings.getString("SCW_LIST_ENGINES") + "\n");
        for (ScriptEngineFactory engine : ScriptRunner.MANAGER.getEngineFactories()) {
            sb.append(" - ");
            sb.append(engine.getEngineName());
            sb.append(" ");
            sb.append(engine.getLanguageName());
            sb.append(" v.");
            sb.append(engine.getLanguageVersion());
            sb.append(" (").append(OStrings.getString("SCW_EXTENSIONS")).append(" ");
            boolean hasMore = false;
            for (String ext : engine.getExtensions()) {
                if (hasMore) {
                    sb.append(", ");
                }
                sb.append(ext);
                hasMore = true;
            }
            sb.append(")");
            sb.append("\n");
        }
        return sb.toString();
    }

    private void addScriptCommandToOmegaT() {
        JMenu toolsMenu = Core.getMainWindow().getMainMenu().getToolsMenu();
        toolsMenu.add(new JSeparator());
        JMenuItem scriptMenu = new JMenuItem();
        Mnemonics.setLocalizedText((AbstractButton)scriptMenu, (String)OStrings.getString("TF_MENU_TOOLS_SCRIPTING"));
        scriptMenu.addActionListener(e -> this.frame.setVisible(true));
        toolsMenu.add(scriptMenu);
        for (int i = 0; i < 12; ++i) {
            JMenuItem menuItem;
            this.m_quickMenus[i] = menuItem = new JMenuItem();
            this.unsetQuickScriptMenu(i);
            this.m_quickMenus[i].setAccelerator(KeyStroke.getKeyStroke("shift ctrl F" + (i + 1)));
            toolsMenu.add(menuItem);
        }
    }

    private int scriptKey(int i) {
        return i + 1;
    }

    private void unsetQuickScriptMenu(int index) {
        this.m_quickScripts[index] = null;
        this.removeAllQuickScriptActionListenersFrom(this.m_quickMenus[index]);
        if (this.m_quickMenus.length < index || this.m_quickMenus[index] == null) {
            return;
        }
        this.m_quickMenus[index].setEnabled(false);
        Mnemonics.setLocalizedText((AbstractButton)this.m_quickMenus[index], (String)("&" + this.scriptKey(index) + " - " + OStrings.getString("SCW_SCRIPTS_NONE")));
    }

    private void setQuickScriptMenu(ScriptItem scriptItem, int index) {
        this.m_quickScripts[index] = scriptItem.getFile().getName();
        this.removeAllQuickScriptActionListenersFrom(this.m_quickMenus[index]);
        this.m_quickMenus[index].addActionListener(new QuickScriptActionListener(index));
        this.m_quickMenus[index].setAccelerator(KeyStroke.getKeyStroke("shift ctrl F" + (index + 1)));
        this.m_quickMenus[index].setEnabled(true);
        if ("".equals(scriptItem.getDescription())) {
            this.m_quickMenus[index].setToolTipText(scriptItem.getDescription());
        }
        Mnemonics.setLocalizedText((AbstractButton)this.m_quickMenus[index], (String)("&" + this.scriptKey(index) + " - " + scriptItem.getScriptName()));
    }

    private void removeAllQuickScriptActionListenersFrom(JMenuItem menu) {
        if (menu == null) {
            return;
        }
        for (ActionListener l : menu.getActionListeners()) {
            if (!(l instanceof QuickScriptActionListener)) continue;
            menu.removeActionListener(l);
        }
    }

    private void runQuickScript(int index) {
        if (this.m_quickScripts[index] == null) {
            this.logResult(OStrings.getString("SCW_NO_SCRIPT_SELECTED"));
            return;
        }
        this.logResult(StringUtil.format(OStrings.getString("SCW_QUICK_RUN"), index + 1));
        ScriptItem scriptFile = new ScriptItem(new File(this.m_scriptsDirectory, this.m_quickScripts[index]));
        this.executeScriptFile(scriptFile);
    }

    private void addRunShortcutToOmegaT() {
        JRootPane appliRootPane = Core.getMainWindow().getApplicationFrame().getRootPane();
        appliRootPane.getInputMap(1).put(KeyStroke.getKeyStroke(82, 640, false), "RUN_CURRENT_SCRIPT");
        appliRootPane.getActionMap().put("RUN_CURRENT_SCRIPT", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ScriptingWindow.this.runScript();
            }
        });
    }

    private void initWindowLayout() {
        this.frame.setBounds(50, 80, 1150, 650);
        StaticUIUtils.persistGeometry(this.frame, "script_window");
        this.frame.getContentPane().setLayout(new BorderLayout(0, 0));
        this.m_scriptList = new JList();
        JScrollPane scrollPaneList = new JScrollPane(this.m_scriptList);
        this.m_scriptList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                if (!evt.getValueIsAdjusting()) {
                    ScriptingWindow.this.onListSelectionChanged();
                }
            }
        });
        this.m_scriptList.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                ListModel lm = ScriptingWindow.this.m_scriptList.getModel();
                int index = ScriptingWindow.this.m_scriptList.locationToIndex(e.getPoint());
                if (index > -1) {
                    ScriptingWindow.this.m_scriptList.setToolTipText(((ScriptItem)lm.getElementAt(index)).getFile().getName());
                }
            }
        });
        this.m_txtResult = new JEditorPane();
        JScrollPane scrollPaneResults = new JScrollPane(this.m_txtResult);
        this.m_txtScriptEditor = this.getScriptEditor();
        this.m_txtScriptEditor.initLayout(this);
        JSplitPane splitPane1 = new JSplitPane(0, this.m_txtScriptEditor.getPanel(), scrollPaneResults);
        splitPane1.setOneTouchExpandable(true);
        splitPane1.setDividerLocation(430);
        Dimension minimumSize1 = new Dimension(100, 50);
        scrollPaneResults.setMinimumSize(minimumSize1);
        JSplitPane splitPane = new JSplitPane(1, scrollPaneList, splitPane1);
        splitPane.setOneTouchExpandable(true);
        splitPane.setDividerLocation(250);
        Dimension minimumSize = new Dimension(100, 50);
        scrollPaneList.setMinimumSize(minimumSize);
        scrollPaneResults.setMinimumSize(minimumSize);
        this.frame.getContentPane().add((Component)splitPane, "Center");
        JPanel panelSouth = new JPanel();
        FlowLayout flPanelSouth = (FlowLayout)panelSouth.getLayout();
        flPanelSouth.setAlignment(0);
        this.frame.getContentPane().add((Component)panelSouth, "South");
        this.setupRunButtons(panelSouth);
        this.frame.setDefaultCloseOperation(2);
        this.frame.setJMenuBar(this.createMenuBar());
    }

    private AbstractScriptEditor getScriptEditor() {
        try {
            Class<?> richScriptEditorClass = Class.forName("org.omegat.gui.scripting.RichScriptEditor");
            return (AbstractScriptEditor)richScriptEditorClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            this.logResult("RichScriptEditor not present, fallback to the standard editor");
        }
        catch (IllegalAccessException | InstantiationException e) {
            this.logResult("Error loading RichScriptEditor: ", e);
        }
        return new StandardScriptEditor();
    }

    private void setupRunButtons(JPanel panel) {
        this.m_btnRunScript = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.m_btnRunScript, (String)OStrings.getString("SCW_RUN_SCRIPT"));
        this.m_btnRunScript.setAlignmentX(0.0f);
        this.m_btnRunScript.setHorizontalAlignment(2);
        this.m_btnRunScript.addActionListener(a -> this.runScript());
        panel.add(this.m_btnRunScript);
        this.m_btnCancelScript = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.m_btnCancelScript, (String)OStrings.getString("SCW_CANCEL_SCRIPT"));
        this.m_btnCancelScript.setToolTipText(OStrings.getString("SCW_CANCEL_BUTTON_TOOLTIP"));
        this.m_btnCancelScript.setAlignmentX(0.0f);
        this.m_btnCancelScript.setHorizontalAlignment(2);
        this.m_btnCancelScript.addActionListener(e -> this.cancelCurrentScript());
        panel.add(this.m_btnCancelScript);
        for (int i = 0; i < 12; ++i) {
            int index = i;
            final int scriptKey = this.scriptKey(index);
            this.m_quickScriptButtons[i] = new JButton(String.valueOf(scriptKey));
            this.m_quickScriptButtons[i].addActionListener(a -> {
                if (Preferences.existsPreference("scripts_quick_" + scriptKey)) {
                    this.runQuickScript(index);
                } else {
                    this.logResult(StringUtil.format(OStrings.getString("SCW_NO_SCRIPT_BOUND"), scriptKey));
                }
            });
            JPopupMenu quickScriptPopup = new JPopupMenu();
            final JMenuItem addQuickScriptMenuItem = new JMenuItem(OStrings.getString("SCW_ADD_SCRIPT"));
            addQuickScriptMenuItem.addActionListener(new QuickScriptUpdater(index));
            quickScriptPopup.add(addQuickScriptMenuItem);
            final JMenuItem removeQuickScriptMenuItem = new JMenuItem(OStrings.getString("SCW_REMOVE_SCRIPT"));
            removeQuickScriptMenuItem.addActionListener(evt -> {
                String scriptName = Preferences.getPreferenceDefault("scripts_quick_" + scriptKey, "(unknown)");
                this.logResult(StringUtil.format(OStrings.getString("SCW_REMOVED_QUICK_SCRIPT"), scriptName, scriptKey));
                Preferences.setPreference("scripts_quick_" + scriptKey, "");
                this.m_quickScriptButtons[index].setToolTipText(OStrings.getString("SCW_NO_SCRIPT_SET"));
                this.m_quickScriptButtons[index].setText(" " + scriptKey + " ");
                this.unsetQuickScriptMenu(index);
            });
            quickScriptPopup.add(removeQuickScriptMenuItem);
            quickScriptPopup.addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                    addQuickScriptMenuItem.setEnabled(!ScriptingWindow.this.m_scriptList.isSelectionEmpty());
                    String scriptName = Preferences.getPreferenceDefault("scripts_quick_" + scriptKey, null);
                    removeQuickScriptMenuItem.setEnabled(!StringUtil.isEmpty(scriptName));
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                }

                @Override
                public void popupMenuCanceled(PopupMenuEvent e) {
                }
            });
            this.m_quickScriptButtons[i].setComponentPopupMenu(quickScriptPopup);
            panel.add(this.m_quickScriptButtons[i]);
        }
    }

    private void runScript() {
        String scriptString;
        this.m_txtResult.setText("");
        if (this.m_currentScriptItem == null) {
            this.logResult(OStrings.getString("SCW_NO_SCRIPT_SELECTED"));
            return;
        }
        String scriptSource = "<EDITOR>";
        if (this.m_currentScriptItem.getFile() != null) {
            if (!this.m_currentScriptItem.getFile().canRead()) {
                this.logResult(OStrings.getString("SCW_CANNOT_READ_SCRIPT"));
                return;
            }
            scriptSource = this.m_currentScriptItem.getFile().getAbsolutePath();
        }
        if ((scriptString = this.m_txtScriptEditor.getTextArea().getText()).trim().isEmpty()) {
            try {
                scriptString = this.m_currentScriptItem.getText();
                this.m_txtScriptEditor.getTextArea().setText(scriptString);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.logResult(StringUtil.format(OStrings.getString("SCW_RUNNING_SCRIPT"), scriptSource));
        this.executeScript(scriptString, this.m_currentScriptItem);
    }

    public void executeScript(String scriptString, ScriptItem scriptItem) {
        this.executeScript(scriptString, scriptItem, Collections.emptyMap());
    }

    public void executeScriptFile(ScriptItem scriptItem) {
        this.executeScriptFile(scriptItem, Collections.emptyMap());
    }

    public void executeScriptFile(ScriptItem scriptItem, Map<String, Object> additionalBindings) {
        try {
            String scriptString = scriptItem.getText();
            this.executeScript(scriptString, scriptItem, additionalBindings);
        }
        catch (IOException e) {
            this.logResult(StringUtil.format(OStrings.getString("SCW_SCRIPT_LOAD_ERROR"), scriptItem.getFile()), e);
        }
    }

    public void executeScript(String scriptString, ScriptItem scriptItem, Map<String, Object> additionalBindings) {
        if (!scriptString.endsWith("\n")) {
            scriptString = scriptString + "\n";
        }
        HashMap<String, Object> bindings = new HashMap<String, Object>(additionalBindings);
        bindings.put("console", new IScriptLogger(){

            @Override
            public void print(Object o) {
                ScriptingWindow.this.logResult(o.toString(), false);
            }

            @Override
            public void println(Object o) {
                ScriptingWindow.this.logResult(o.toString(), true);
            }

            @Override
            public void clear() {
                ScriptingWindow.this.m_txtResult.setText("");
            }
        });
        this.cancelCurrentScript();
        this.scriptWorker = new ScriptWorker(scriptString, scriptItem, bindings);
        this.scriptWorker.execute();
    }

    private void cancelCurrentScript() {
        if (this.scriptWorker != null) {
            this.scriptWorker.cancel(true);
        }
    }

    private void logResult(String s, Throwable t) {
        this.logResultToWindow(s + "\n" + t.getMessage(), true);
        LOGGER.log(Level.SEVERE, s, t);
    }

    private void logResult(String s) {
        this.logResult(s, true);
    }

    private void logResult(String s, boolean newLine) {
        this.logResultToWindow(s, newLine);
        LOGGER.log(Level.INFO, s);
    }

    private void logResultToWindow(String s, boolean newLine) {
        Document doc = this.m_txtResult.getDocument();
        try {
            doc.insertString(doc.getLength(), s + (newLine ? "\n" : ""), null);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private void setScriptsDirectory(String scriptsDir) {
        File dir;
        try {
            dir = new File(scriptsDir).getCanonicalFile();
        }
        catch (IOException ex) {
            dir = new File(scriptsDir).getAbsoluteFile();
        }
        this.setScriptsDirectory(dir);
    }

    private void setScriptsDirectory(File scriptsDir) {
        if (!scriptsDir.isDirectory()) {
            this.updateQuickScripts();
            return;
        }
        this.m_scriptsDirectory = scriptsDir;
        Preferences.setPreference("scripts_dir", scriptsDir.getPath());
        OSXIntegration.setProxyIcon(this.frame.getRootPane(), this.m_scriptsDirectory);
        if (this.m_txtScriptsDir != null) {
            this.m_txtScriptsDir.setText(scriptsDir.getPath());
        }
        if (this.monitor != null) {
            this.monitor.stop();
            this.monitor.start(this.m_scriptsDirectory);
        }
    }

    private void updateQuickScripts() {
        for (int i = 0; i < 12; ++i) {
            int key = this.scriptKey(i);
            String scriptName = Preferences.getPreferenceDefault("scripts_quick_" + key, null);
            if (this.m_scriptsDirectory != null && !StringUtil.isEmpty(scriptName)) {
                this.setQuickScriptMenu(new ScriptItem(new File(this.m_scriptsDirectory, scriptName)), i);
                this.m_quickScriptButtons[i].setToolTipText(scriptName);
                this.m_quickScriptButtons[i].setText("<" + key + ">");
                continue;
            }
            this.unsetQuickScriptMenu(i);
            if (this.m_quickScriptButtons.length < i || this.m_quickScriptButtons[i] == null) {
                return;
            }
            this.m_quickScriptButtons[i].setToolTipText(OStrings.getString("SCW_NO_SCRIPT_SET"));
            this.m_quickScriptButtons[i].setText(String.valueOf(key));
        }
    }

    void setScriptItems(Collection<ScriptItem> items) {
        this.m_scriptList.setListData((ScriptItem[])items.toArray(new ScriptItem[items.size()]));
    }

    private void onListSelectionChanged() {
        if (this.m_scriptList.isSelectionEmpty()) {
            return;
        }
        this.m_currentScriptItem = this.m_scriptList.getSelectedValue();
        this.displayScriptItem();
    }

    private void displayScriptItem() {
        try {
            this.m_txtScriptEditor.setHighlighting(FilenameUtils.getExtension(this.m_currentScriptItem.getFile().getName().toLowerCase(Locale.ENGLISH)));
            this.m_txtScriptEditor.getTextArea().setText(this.m_currentScriptItem.getText());
            this.m_txtScriptEditor.getTextArea().setCaretPosition(0);
        }
        catch (IOException ex) {
            this.logResult(OStrings.getString("SCW_CANNOT_READ_SCRIPT"));
        }
    }

    public String getSelectedText() {
        return this.m_txtScriptEditor.getTextArea().getSelectedText();
    }

    private JMenuBar createMenuBar() {
        this.mb = new JMenuBar();
        JMenu menu = new JMenu();
        Mnemonics.setLocalizedText((AbstractButton)menu, (String)OStrings.getString("SCW_MENU_TITLE"));
        JMenuItem item = new JMenuItem();
        Mnemonics.setLocalizedText((AbstractButton)item, (String)OStrings.getString("SCW_LOAD_FILE"));
        item.addActionListener(new OpenScriptAction());
        item.setAccelerator(KeyStroke.getKeyStroke(79, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        menu.add(item);
        item = new JMenuItem();
        Mnemonics.setLocalizedText((AbstractButton)item, (String)OStrings.getString("SCW_NEW_SCRIPT"));
        item.addActionListener(new NewScriptAction());
        item.setAccelerator(KeyStroke.getKeyStroke(78, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        menu.add(item);
        item = new JMenuItem();
        Mnemonics.setLocalizedText((AbstractButton)item, (String)OStrings.getString("SCW_SAVE_SCRIPT"));
        item.addActionListener(new SaveScriptAction());
        item.setAccelerator(KeyStroke.getKeyStroke(83, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        menu.add(item);
        item = new JMenuItem();
        Mnemonics.setLocalizedText((AbstractButton)item, (String)OStrings.getString("SCW_RUN_SCRIPT"));
        item.addActionListener(new RunScriptAction());
        item.setAccelerator(KeyStroke.getKeyStroke(82, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        menu.add(item);
        menu.addSeparator();
        item = new JMenuItem();
        Mnemonics.setLocalizedText((AbstractButton)item, (String)OStrings.getString("SCW_MENU_SET_SCRIPTS_FOLDER"));
        item.addActionListener(new SelectScriptFolderAction());
        menu.add(item);
        item = new JMenuItem();
        Mnemonics.setLocalizedText((AbstractButton)item, (String)OStrings.getString("SCW_MENU_ACCESS_FOLDER"));
        item.addActionListener(new ExploreScriptFolderAction());
        menu.add(item);
        menu.addSeparator();
        item = new JMenuItem();
        Mnemonics.setLocalizedText((AbstractButton)item, (String)OStrings.getString("SCW_MENU_CLOSE"));
        item.setAccelerator(KeyStroke.getKeyStroke(87, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        item.addActionListener(e -> {
            this.frame.setVisible(false);
            this.frame.dispose();
        });
        menu.add(item);
        PropertiesShortcuts.getMainMenuShortcuts().bindKeyStrokes(menu);
        this.mb.add(menu);
        this.m_txtScriptEditor.enhanceMenu(this.mb);
        this.buildSetsMenu(this.mb);
        menu = new JMenu();
        Mnemonics.setLocalizedText((AbstractButton)menu, (String)OStrings.getString("SCW_MENU_HELP"));
        item = new JMenuItem();
        Mnemonics.setLocalizedText((AbstractButton)item, (String)OStrings.getString("SCW_MENU_JAVADOC"));
        item.addActionListener(e -> {
            try {
                Help.showJavadoc();
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this.frame, ex.getLocalizedMessage(), OStrings.getString("ERROR_TITLE"), 0);
                Log.log(ex);
            }
        });
        menu.add(item);
        this.mb.add(menu);
        return this.mb;
    }

    protected void buildSetsMenu(JMenuBar mb) {
        this.m_setsMenu.removeAll();
        Mnemonics.setLocalizedText((AbstractButton)this.m_setsMenu, (String)OStrings.getString("SCW_MENU_SETS"));
        JMenuItem item = new JMenuItem();
        Mnemonics.setLocalizedText((AbstractButton)item, (String)OStrings.getString("SCW_MENU_SAVE_SET"));
        item.addActionListener(new SaveSetAction());
        this.m_setsMenu.add(item);
        this.m_setsMenu.addSeparator();
        if (this.m_scriptsDirectory == null) {
            return;
        }
        for (File script2 : this.m_scriptsDirectory.listFiles(script -> script.getName().endsWith(".set"))) {
            ScriptSet set = new ScriptSet(script2);
            JMenuItem setMenuItem = new JMenuItem();
            setMenuItem.setText(set.getTitle());
            setMenuItem.putClientProperty("set", set);
            setMenuItem.addActionListener(new LoadSetAction());
            this.m_setsMenu.add(setMenuItem);
        }
        mb.add(this.m_setsMenu);
    }

    private class LoadSetAction
    implements ActionListener {
        private LoadSetAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int i;
            JMenuItem source = (JMenuItem)e.getSource();
            ScriptSet set = (ScriptSet)source.getClientProperty("set");
            for (i = 0; i < 12; ++i) {
                Preferences.setPreference("scripts_quick_" + ScriptingWindow.this.scriptKey(i), "");
                ScriptingWindow.this.unsetQuickScriptMenu(i);
            }
            for (i = 0; i < 12; ++i) {
                ScriptItem si = set.getScriptItem(ScriptingWindow.this.scriptKey(i));
                if (si == null) continue;
                Preferences.setPreference("scripts_quick_" + ScriptingWindow.this.scriptKey(i), si.getFile().getName());
                new QuickScriptUpdater(i).updateQuickScript(si);
                ScriptingWindow.this.updateQuickScripts();
            }
        }
    }

    private class SaveSetAction
    implements ActionListener {
        private SaveSetAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String setName = JOptionPane.showInputDialog(ScriptingWindow.this.frame, OStrings.getString("SCW_SAVE_SET_MSG"), OStrings.getString("SCW_MENU_SAVE_SET"), 3);
            if (setName == null) {
                return;
            }
            try {
                ScriptSet.saveSet(new File(ScriptingWindow.this.m_scriptsDirectory, setName + ".set"), setName, ScriptingWindow.this.m_quickScripts);
                ScriptingWindow.this.buildSetsMenu(ScriptingWindow.this.mb);
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
    }

    private class ExploreScriptFolderAction
    implements ActionListener {
        private ExploreScriptFolderAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                ScriptingWindow.this.m_scriptsDirectory = ScriptingWindow.this.m_scriptsDirectory.getCanonicalFile();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!ScriptingWindow.this.m_scriptsDirectory.exists()) {
                Core.getMainWindow().showStatusMessageRB("LFC_ERROR_FILE_DOESNT_EXIST", ScriptingWindow.this.m_scriptsDirectory);
                return;
            }
            try {
                Desktop.getDesktop().open(ScriptingWindow.this.m_scriptsDirectory);
            }
            catch (Exception ex) {
                Log.logErrorRB(ex, "RPF_ERROR", new Object[0]);
                Core.getMainWindow().displayErrorRB(ex, "RPF_ERROR", new Object[0]);
            }
        }
    }

    private class SelectScriptFolderAction
    implements ActionListener {
        private SelectScriptFolderAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JFileChooser chooser = new JFileChooser(ScriptingWindow.this.m_scriptsDirectory);
            chooser.setDialogTitle(OStrings.getString("SCW_SCRIPTS_FOLDER_CHOOSE_TITLE"));
            chooser.setFileSelectionMode(1);
            int result = chooser.showOpenDialog(ScriptingWindow.this.frame);
            if (result == 0) {
                File file = chooser.getSelectedFile();
                ScriptingWindow.this.setScriptsDirectory(file);
            }
        }
    }

    private class SaveScriptAction
    implements ActionListener {
        private SaveScriptAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (ScriptingWindow.this.m_currentScriptItem == null || ScriptingWindow.this.m_currentScriptItem.getFile() == null) {
                JFileChooser chooser = new JFileChooser(ScriptingWindow.this.m_scriptsDirectory);
                chooser.setDialogTitle(OStrings.getString("SCW_SAVE_SCRIPT"));
                int result = chooser.showSaveDialog(ScriptingWindow.this.frame);
                if (result == 0) {
                    ScriptingWindow.this.m_currentScriptItem = new ScriptItem(chooser.getSelectedFile());
                } else {
                    return;
                }
            }
            if (ScriptingWindow.this.m_currentScriptItem == null) {
                return;
            }
            try {
                ScriptingWindow.this.m_currentScriptItem.setText(ScriptingWindow.this.m_txtScriptEditor.getTextArea().getText());
                ScriptingWindow.this.logResult(StringUtil.format(OStrings.getString("SCW_SAVE_OK"), ScriptingWindow.this.m_currentScriptItem.getFile().getAbsolutePath()));
            }
            catch (IOException ex) {
                ScriptingWindow.this.logResult(OStrings.getString("SCW_SAVE_ERROR"), ex);
            }
        }
    }

    private class RunScriptAction
    implements ActionListener {
        private RunScriptAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (ScriptingWindow.this.m_currentScriptItem == null) {
                ScriptingWindow.this.m_currentScriptItem = new ScriptItem(null);
            }
            ScriptingWindow.this.runScript();
        }
    }

    private class NewScriptAction
    implements ActionListener {
        private NewScriptAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ScriptingWindow.this.m_currentScriptItem = null;
            ScriptingWindow.this.m_txtScriptEditor.getTextArea().setText("");
            ScriptingWindow.this.m_txtScriptEditor.getTextArea().setCaretPosition(0);
            ScriptingWindow.this.m_txtScriptEditor.getTextArea().grabFocus();
        }
    }

    private class OpenScriptAction
    implements ActionListener {
        private OpenScriptAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            File openFileDir = Core.getProject().isProjectLoaded() ? Core.getProject().getProjectProperties().getProjectRootDir() : ScriptingWindow.this.m_scriptsDirectory;
            JFileChooser chooser = new JFileChooser(openFileDir);
            chooser.setDialogTitle(OStrings.getString("SCW_SCRIPTS_OPEN_SCRIPT_TITLE"));
            chooser.setDialogTitle("Select a Script File");
            chooser.setFileSelectionMode(0);
            int result = chooser.showOpenDialog(ScriptingWindow.this.frame);
            if (result == 0) {
                ScriptingWindow.this.m_currentScriptItem = new ScriptItem(chooser.getSelectedFile());
                ScriptingWindow.this.displayScriptItem();
            }
        }
    }

    private class ScriptWorker
    extends SwingWorker<String, Void> {
        private final String scriptString;
        private final ScriptItem scriptItem;
        private final Map<String, Object> bindings;
        private long start;

        ScriptWorker(String scriptString, ScriptItem scriptItem, Map<String, Object> bindings) {
            this.scriptString = scriptString;
            this.scriptItem = scriptItem;
            this.bindings = bindings;
        }

        @Override
        protected String doInBackground() throws Exception {
            this.start = System.currentTimeMillis();
            return ScriptRunner.executeScript(this.scriptString, this.scriptItem, this.bindings);
        }

        @Override
        protected void done() {
            try {
                String result = (String)this.get();
                ScriptingWindow.this.logResult(result);
                ScriptingWindow.this.logResult(StringUtil.format(OStrings.getString("SCW_SCRIPT_DONE"), System.currentTimeMillis() - this.start));
            }
            catch (CancellationException e) {
                ScriptingWindow.this.logResult(StringUtil.format(OStrings.getString("SCW_SCRIPT_CANCELED"), System.currentTimeMillis() - this.start));
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (ExecutionException e) {
                ScriptingWindow.this.logResult(OStrings.getString("SCW_SCRIPT_ERROR"), e);
            }
        }
    }

    private class QuickScriptUpdater
    implements ActionListener {
        int index;
        int scriptKey;

        QuickScriptUpdater(int index) {
            this.scriptKey = ScriptingWindow.this.scriptKey(index);
            this.index = index;
        }

        public void updateQuickScript(ScriptItem scriptItem) {
            Preferences.setPreference("scripts_quick_" + this.scriptKey, scriptItem.getFile().getName());
            ScriptingWindow.this.m_quickScriptButtons[this.index].setToolTipText(scriptItem.getToolTip());
            ScriptingWindow.this.m_quickScriptButtons[this.index].setText("<" + this.scriptKey + ">");
            ScriptingWindow.this.setQuickScriptMenu(scriptItem, this.index);
            ScriptingWindow.this.logResult(StringUtil.format(OStrings.getString("SCW_SAVE_QUICK_SCRIPT"), scriptItem, this.scriptKey));
        }

        public void updateQuickScript() {
            ScriptItem scriptItem = (ScriptItem)ScriptingWindow.this.m_scriptList.getSelectedValue();
            this.updateQuickScript(scriptItem);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            this.updateQuickScript();
        }
    }

    private class QuickScriptActionListener
    implements ActionListener {
        private final int index;

        QuickScriptActionListener(int index) {
            this.index = index;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ScriptingWindow.this.runQuickScript(this.index);
        }
    }
}

