/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.util.gui;

import java.awt.Image;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.io.File;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import org.omegat.core.Core;
import org.omegat.core.CoreEvents;
import org.omegat.core.events.IApplicationEventListener;
import org.omegat.core.events.IProjectEventListener;
import org.omegat.gui.main.ProjectUICommands;
import org.omegat.util.Log;
import org.omegat.util.Preferences;
import org.omegat.util.StaticUtils;
import org.omegat.util.gui.ResourcesUtil;

public final class OSXIntegration {
    public static final Image APP_ICON_MAC = ResourcesUtil.getBundledImage("OmegaT_mac.png");
    private static volatile Class<?> appClass;
    private static volatile Object app;
    private static boolean guiLoaded;
    private static final List<Runnable> DO_AFTER_LOAD;
    private static final IApplicationEventListener APP_LISTENER;
    private static final IOpenFilesHandler OPEN_FILES_HANDLER;
    private static final IProjectEventListener PROJECT_LISTENER;

    private OSXIntegration() {
    }

    public static void init() {
        try {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
            System.setProperty("com.apple.mrj.application.apple.menu.about.name", "OmegaT");
            Method setDockIconImage = OSXIntegration.getAppClass().getDeclaredMethod("setDockIconImage", Image.class);
            setDockIconImage.invoke(OSXIntegration.getApp(), APP_ICON_MAC);
            Class<?> strategyClass = Class.forName("com.apple.eawt.QuitStrategy");
            Method setQuitStrategy = OSXIntegration.getAppClass().getDeclaredMethod("setQuitStrategy", strategyClass);
            setQuitStrategy.invoke(OSXIntegration.getApp(), strategyClass.getField("CLOSE_ALL_WINDOWS").get(null));
            Method disableTerm = OSXIntegration.getAppClass().getDeclaredMethod("disableSuddenTermination", new Class[0]);
            disableTerm.invoke(OSXIntegration.getApp(), new Object[0]);
            CoreEvents.registerApplicationEventListener(APP_LISTENER);
            OSXIntegration.setOpenFilesHandler(OPEN_FILES_HANDLER);
            CoreEvents.registerProjectChangeListener(PROJECT_LISTENER);
        }
        catch (Exception ex) {
            Log.log(ex);
        }
    }

    public static void setAboutHandler(ActionListener al) {
        try {
            Class<?> aboutHandlerClass = Class.forName("com.apple.eawt.AboutHandler");
            InvocationHandler ih = (proxy, method, args) -> {
                if (method.getName().equals("handleAbout")) {
                    al.actionPerformed(null);
                }
                return null;
            };
            Object handler = Proxy.newProxyInstance(OSXIntegration.class.getClassLoader(), new Class[]{aboutHandlerClass}, ih);
            Method setAboutHandler = OSXIntegration.getAppClass().getDeclaredMethod("setAboutHandler", aboutHandlerClass);
            setAboutHandler.invoke(OSXIntegration.getApp(), handler);
        }
        catch (Exception ex) {
            Log.log(ex);
        }
    }

    public static void setQuitHandler(ActionListener al) {
        try {
            Class<?> quitHandlerClass = Class.forName("com.apple.eawt.QuitHandler");
            InvocationHandler ih = (proxy, method, args) -> {
                if (method.getName().equals("handleQuitRequestWith")) {
                    Class<?> quitResponseClass = Class.forName("com.apple.eawt.QuitResponse");
                    if (args != null && args.length > 1 && quitResponseClass.isInstance(args[1]) && Preferences.isPreference("always_confirm_quit")) {
                        Method cancelQuit = quitResponseClass.getDeclaredMethod("cancelQuit", new Class[0]);
                        cancelQuit.invoke(args[1], new Object[0]);
                    }
                    al.actionPerformed(null);
                }
                return null;
            };
            Object handler = Proxy.newProxyInstance(OSXIntegration.class.getClassLoader(), new Class[]{quitHandlerClass}, ih);
            Method setQuitHandler = OSXIntegration.getAppClass().getDeclaredMethod("setQuitHandler", quitHandlerClass);
            setQuitHandler.invoke(OSXIntegration.getApp(), handler);
        }
        catch (Exception ex) {
            Log.log(ex);
        }
    }

    public static void setOpenFilesHandler(IOpenFilesHandler ofh) {
        try {
            Class<?> openFilesHandlerClass = Class.forName("com.apple.eawt.OpenFilesHandler");
            InvocationHandler ih = (proxy, method, args) -> {
                try {
                    if (method.getName().equals("openFiles")) {
                        Class<?> filesEventClass = Class.forName("com.apple.eawt.AppEvent$FilesEvent");
                        if (args != null && args.length > 0 && filesEventClass.isInstance(args[0])) {
                            Object filesEvent = args[0];
                            Method getFilesMethod = filesEventClass.getDeclaredMethod("getFiles", new Class[0]);
                            Object filesList = getFilesMethod.invoke(filesEvent, new Object[0]);
                            ofh.openFiles((List)filesList);
                        }
                    }
                }
                catch (Throwable t) {
                    Log.log(t);
                }
                return null;
            };
            Object handler = Proxy.newProxyInstance(OSXIntegration.class.getClassLoader(), new Class[]{openFilesHandlerClass}, ih);
            Method setOpenFileHandler = OSXIntegration.getAppClass().getDeclaredMethod("setOpenFileHandler", openFilesHandlerClass);
            setOpenFileHandler.invoke(OSXIntegration.getApp(), handler);
        }
        catch (Exception ex) {
            Log.log(ex);
        }
    }

    public static void setPreferencesHandler(ActionListener listener) {
        try {
            Class<?> preferencesHandlerClass = Class.forName("com.apple.eawt.PreferencesHandler");
            InvocationHandler ih = (proxy, method, args) -> {
                if (method.getName().equals("handlePreferences")) {
                    listener.actionPerformed(null);
                }
                return null;
            };
            Object handler = Proxy.newProxyInstance(OSXIntegration.class.getClassLoader(), new Class[]{preferencesHandlerClass}, ih);
            Method setAboutHandler = OSXIntegration.getAppClass().getDeclaredMethod("setPreferencesHandler", preferencesHandlerClass);
            setAboutHandler.invoke(OSXIntegration.getApp(), handler);
        }
        catch (Exception ex) {
            Log.log(ex);
        }
    }

    public static void enableFullScreen(Window window) {
        try {
            Class<?> utilClass = Class.forName("com.apple.eawt.FullScreenUtilities");
            Method setWindowCanFullScreen = utilClass.getMethod("setWindowCanFullScreen", Window.class, Boolean.TYPE);
            setWindowCanFullScreen.invoke(utilClass, window, true);
        }
        catch (Exception ex) {
            Log.log(ex);
        }
    }

    public static void setProxyIcon(JRootPane rootPane, File file) {
        rootPane.putClientProperty("Window.documentFile", file);
    }

    public static void setModifiedIndicator(JRootPane rootPane, boolean isModified) {
        rootPane.putClientProperty("Window.documentModified", isModified);
    }

    private static Class<?> getAppClass() throws Exception {
        if (appClass == null) {
            appClass = Class.forName("com.apple.eawt.Application");
        }
        return appClass;
    }

    private static Object getApp() throws Exception {
        if (app == null) {
            Method getApp = OSXIntegration.getAppClass().getDeclaredMethod("getApplication", new Class[0]);
            app = getApp.invoke(null, new Object[0]);
        }
        return app;
    }

    static {
        guiLoaded = false;
        DO_AFTER_LOAD = new ArrayList<Runnable>();
        APP_LISTENER = new IApplicationEventListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onApplicationStartup() {
                guiLoaded = true;
                List list = DO_AFTER_LOAD;
                synchronized (list) {
                    for (Runnable r : DO_AFTER_LOAD) {
                        r.run();
                    }
                    DO_AFTER_LOAD.clear();
                }
                JFrame window = Core.getMainWindow().getApplicationFrame();
                OSXIntegration.enableFullScreen(window);
            }

            @Override
            public void onApplicationShutdown() {
                guiLoaded = false;
            }
        };
        OPEN_FILES_HANDLER = new IOpenFilesHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void openFiles(List<?> files) {
                if (files.isEmpty()) {
                    return;
                }
                File firstFile = (File)files.get(0);
                if (firstFile.getName().equals("omegat.project")) {
                    firstFile = firstFile.getParentFile();
                }
                if (!StaticUtils.isProjectDir(firstFile)) {
                    return;
                }
                final File projDir = firstFile;
                Runnable openProject = new Runnable(){

                    @Override
                    public void run() {
                        ProjectUICommands.projectOpen(projDir, true);
                    }
                };
                if (guiLoaded) {
                    SwingUtilities.invokeLater(openProject);
                } else {
                    List list = DO_AFTER_LOAD;
                    synchronized (list) {
                        DO_AFTER_LOAD.add(openProject);
                    }
                }
            }
        };
        PROJECT_LISTENER = eventType -> {
            JRootPane rootPane = Core.getMainWindow().getApplicationFrame().getRootPane();
            switch (eventType) {
                case CREATE: 
                case LOAD: {
                    String projDir = Core.getProject().getProjectProperties().getProjectRoot();
                    OSXIntegration.setProxyIcon(rootPane, new File(projDir));
                    break;
                }
                case CLOSE: {
                    OSXIntegration.setProxyIcon(rootPane, null);
                    break;
                }
                case MODIFIED: {
                    OSXIntegration.setModifiedIndicator(rootPane, true);
                    break;
                }
                case SAVE: {
                    OSXIntegration.setModifiedIndicator(rootPane, false);
                    break;
                }
            }
        };
    }

    public static interface IOpenFilesHandler {
        public void openFiles(List<?> var1);
    }
}

