/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.filters3.xml.xhtml;

import java.awt.Window;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.omegat.core.data.ProtectedPart;
import org.omegat.filters2.FilterContext;
import org.omegat.filters2.Instance;
import org.omegat.filters3.xml.XMLFilter;
import org.omegat.filters3.xml.xhtml.EditXOptionsDialog;
import org.omegat.filters3.xml.xhtml.XHTMLDialect;
import org.omegat.filters3.xml.xhtml.XHTMLOptions;
import org.omegat.util.Log;
import org.omegat.util.OStrings;

public class XHTMLFilter
extends XMLFilter {
    private boolean doNotSendToCore = false;

    public XHTMLFilter() {
        super(new XHTMLDialect());
    }

    @Override
    protected boolean requirePrevNextFields() {
        return true;
    }

    @Override
    public String getFileFormatName() {
        return OStrings.getString("XHTML_FILTER_NAME");
    }

    @Override
    public Instance[] getDefaultInstances() {
        return new Instance[]{new Instance("*.html", null, null), new Instance("*.xhtml", null, null), new Instance("*.xht", null, null)};
    }

    @Override
    public boolean isSourceEncodingVariable() {
        return false;
    }

    @Override
    public boolean isTargetEncodingVariable() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isFileSupported(File inFile, Map<String, String> config, FilterContext context) {
        boolean result = super.isFileSupported(inFile, config, context);
        if (result) {
            try {
                this.doNotSendToCore = true;
                XHTMLDialect dialect = (XHTMLDialect)this.getDialect();
                dialect.defineDialect(new XHTMLOptions(config));
                super.processFile(inFile, null, context);
            }
            catch (Exception e) {
                Log.log("XHTML file " + inFile.getName() + " is not valid.");
                result = false;
            }
            finally {
                this.doNotSendToCore = false;
            }
        }
        return result;
    }

    @Override
    public String translate(String entry, List<ProtectedPart> protectedParts) {
        if (this.doNotSendToCore) {
            return entry;
        }
        Pattern skipRegExpPattern = ((XHTMLDialect)this.getDialect()).getSkipRegExpPattern();
        if (skipRegExpPattern != null && skipRegExpPattern.matcher(entry).matches()) {
            return entry;
        }
        return super.translate(entry, protectedParts);
    }

    @Override
    public boolean hasOptions() {
        return true;
    }

    @Override
    public Map<String, String> changeOptions(Window parent, Map<String, String> currentOptions) {
        try {
            EditXOptionsDialog dialog = new EditXOptionsDialog(parent, currentOptions);
            dialog.setVisible(true);
            if (1 == dialog.getReturnStatus()) {
                return dialog.getOptions().getOptionsMap();
            }
            return null;
        }
        catch (Exception e) {
            Log.logErrorRB("HTML_EXC_EDIT_OPTIONS", new Object[0]);
            Log.log(e);
            return null;
        }
    }
}

