/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.preferences.view;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import javax.swing.JComponent;
import org.omegat.gui.preferences.BasePreferencesController;
import org.omegat.gui.preferences.view.UserPassPanel;
import org.omegat.util.Log;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.omegat.util.StringUtil;

public class UserPassController
extends BasePreferencesController {
    private UserPassPanel panel;

    @Override
    public JComponent getGui() {
        if (this.panel == null) {
            this.initGui();
            this.initFromPrefs();
        }
        return this.panel;
    }

    @Override
    public String toString() {
        return OStrings.getString("PREFS_TITLE_PROXY_LOGIN");
    }

    private void initGui() {
        this.panel = new UserPassPanel();
    }

    @Override
    protected void initFromPrefs() {
        String encodedUser = Preferences.getPreference("proxy_user_name");
        String encodedPassword = Preferences.getPreference("proxy_password");
        try {
            this.panel.userText.setText(StringUtil.decodeBase64(encodedUser, StandardCharsets.ISO_8859_1));
            this.panel.passwordField.setText(StringUtil.decodeBase64(encodedPassword, StandardCharsets.ISO_8859_1));
        }
        catch (IllegalArgumentException ex) {
            Log.logErrorRB("LOG_DECODING_ERROR", new Object[0]);
            Log.log(ex);
        }
    }

    @Override
    public void restoreDefaults() {
        this.panel.userText.setText("");
        this.panel.passwordField.setText("");
    }

    @Override
    public void persist() {
        char[] password;
        String user = this.panel.userText.getText().trim();
        if (!user.isEmpty()) {
            String encodedUser = StringUtil.encodeBase64(this.panel.userText.getText(), StandardCharsets.ISO_8859_1);
            Preferences.setPreference("proxy_user_name", encodedUser);
        }
        if ((password = this.panel.passwordField.getPassword()).length > 0) {
            String encodedPassword = StringUtil.encodeBase64(password, StandardCharsets.ISO_8859_1);
            Preferences.setPreference("proxy_password", encodedPassword);
        }
        Arrays.fill(password, '\u0000');
    }
}

