/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline.namefind;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import opennlp.tools.cmdline.AbstractTrainerTool;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.cmdline.namefind.TrainingParams;
import opennlp.tools.cmdline.params.TrainingToolParams;
import opennlp.tools.namefind.BilouCodec;
import opennlp.tools.namefind.BioCodec;
import opennlp.tools.namefind.NameFinderME;
import opennlp.tools.namefind.NameSample;
import opennlp.tools.namefind.NameSampleTypeFilter;
import opennlp.tools.namefind.TokenNameFinderFactory;
import opennlp.tools.namefind.TokenNameFinderModel;
import opennlp.tools.util.InvalidFormatException;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.SequenceCodec;
import opennlp.tools.util.featuregen.GeneratorFactory;
import opennlp.tools.util.model.ArtifactSerializer;
import opennlp.tools.util.model.ModelUtil;
import org.w3c.dom.Element;

public final class TokenNameFinderTrainerTool
extends AbstractTrainerTool<NameSample, TrainerToolParams> {
    public TokenNameFinderTrainerTool() {
        super(NameSample.class, TrainerToolParams.class);
    }

    @Override
    public String getShortDescription() {
        return "trainer for the learnable name finder";
    }

    static byte[] openFeatureGeneratorBytes(String featureGenDescriptorFile) {
        if (featureGenDescriptorFile != null) {
            return TokenNameFinderTrainerTool.openFeatureGeneratorBytes(new File(featureGenDescriptorFile));
        }
        return null;
    }

    static byte[] openFeatureGeneratorBytes(File featureGenDescriptorFile) {
        byte[] featureGeneratorBytes = null;
        if (featureGenDescriptorFile != null) {
            FileInputStream bytesIn = CmdLineUtil.openInFile(featureGenDescriptorFile);
            try {
                featureGeneratorBytes = ModelUtil.read(bytesIn);
            }
            catch (IOException e) {
                throw new TerminateToolException(-1, "IO error while reading training data or indexing data: " + e.getMessage(), e);
            }
            finally {
                try {
                    ((InputStream)bytesIn).close();
                }
                catch (IOException e) {}
            }
        }
        return featureGeneratorBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Object> loadResources(File resourcePath, File featureGenDescriptor) {
        HashMap<String, Object> resources = new HashMap<String, Object>();
        if (resourcePath != null) {
            File[] resourceFiles;
            Map<String, ArtifactSerializer> artifactSerializers = TokenNameFinderModel.createArtifactSerializers();
            List<Object> elements = new ArrayList();
            ArtifactSerializer serializer = null;
            if (featureGenDescriptor != null) {
                FileInputStream xmlDescriptorIn = CmdLineUtil.openInFile(featureGenDescriptor);
                try {
                    artifactSerializers.putAll(GeneratorFactory.extractCustomArtifactSerializerMappings(xmlDescriptorIn));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                FileInputStream inputStreamXML = CmdLineUtil.openInFile(featureGenDescriptor);
                try {
                    elements = GeneratorFactory.getDescriptorElements(inputStreamXML);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            for (File resourceFile : resourceFiles = resourcePath.listFiles()) {
                String resourceName = resourceFile.getName();
                for (Element element : elements) {
                    String dictName = element.getAttribute("dict");
                    if (dictName == null || !dictName.equals(resourceName)) continue;
                    serializer = artifactSerializers.get(element.getTagName());
                }
                if (serializer == null) continue;
                FileInputStream resourceIn = CmdLineUtil.openInFile(resourceFile);
                try {
                    resources.put(resourceName, serializer.create(resourceIn));
                }
                catch (InvalidFormatException invalidFormatException) {
                    invalidFormatException.printStackTrace();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                finally {
                    try {
                        ((InputStream)resourceIn).close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return resources;
    }

    static Map<String, Object> loadResources(String resourceDirectory, File featureGeneratorDescriptor) {
        if (resourceDirectory != null) {
            File resourcePath = new File(resourceDirectory);
            return TokenNameFinderTrainerTool.loadResources(resourcePath, featureGeneratorDescriptor);
        }
        return new HashMap<String, Object>();
    }

    @Override
    public void run(String format, String[] args) {
        TokenNameFinderModel model;
        String sequenceCodecImplName;
        super.run(format, args);
        this.mlParams = CmdLineUtil.loadTrainingParameters(((TrainerToolParams)this.params).getParams(), true);
        if (this.mlParams == null) {
            this.mlParams = ModelUtil.createDefaultTrainingParameters();
        }
        File modelOutFile = ((TrainerToolParams)this.params).getModel();
        byte[] featureGeneratorBytes = TokenNameFinderTrainerTool.openFeatureGeneratorBytes(((TrainerToolParams)this.params).getFeaturegen());
        Map<String, Object> resources = TokenNameFinderTrainerTool.loadResources(((TrainerToolParams)this.params).getResources(), ((TrainerToolParams)this.params).getFeaturegen());
        CmdLineUtil.checkOutputFile("name finder model", modelOutFile);
        if (((TrainerToolParams)this.params).getNameTypes() != null) {
            String[] nameTypes = ((TrainerToolParams)this.params).getNameTypes().split(",");
            this.sampleStream = new NameSampleTypeFilter(nameTypes, (ObjectStream<NameSample>)this.sampleStream);
        }
        if ("BIO".equals(sequenceCodecImplName = ((TrainerToolParams)this.params).getSequenceCodec())) {
            sequenceCodecImplName = BioCodec.class.getName();
        } else if ("BILOU".equals(sequenceCodecImplName)) {
            sequenceCodecImplName = BilouCodec.class.getName();
        }
        SequenceCodec<String> sequenceCodec = TokenNameFinderFactory.instantiateSequenceCodec(sequenceCodecImplName);
        TokenNameFinderFactory nameFinderFactory = null;
        try {
            nameFinderFactory = TokenNameFinderFactory.create(((TrainerToolParams)this.params).getFactory(), featureGeneratorBytes, resources, sequenceCodec);
        }
        catch (InvalidFormatException e) {
            throw new TerminateToolException(-1, e.getMessage(), e);
        }
        try {
            model = NameFinderME.train(((TrainerToolParams)this.params).getLang(), ((TrainerToolParams)this.params).getType(), this.sampleStream, this.mlParams, nameFinderFactory);
        }
        catch (IOException e) {
            throw new TerminateToolException(-1, "IO error while reading training data or indexing data: " + e.getMessage(), e);
        }
        finally {
            try {
                this.sampleStream.close();
            }
            catch (IOException e) {}
        }
        CmdLineUtil.writeModel("name finder", modelOutFile, model);
    }

    static interface TrainerToolParams
    extends TrainingParams,
    TrainingToolParams {
    }
}

