/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.machinetranslators;

import java.awt.Window;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import org.omegat.core.machinetranslators.BaseTranslate;
import org.omegat.gui.exttrans.MTConfigDialog;
import org.omegat.util.JsonParser;
import org.omegat.util.Language;
import org.omegat.util.Log;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.omegat.util.WikiGet;

public class YandexCloudTranslate
extends BaseTranslate {
    private static final String PROPERTY_OAUTH_TOKEN = "yandex.cloud.oauth-token";
    private static final String PROPERTY_FOLDER_ID = "yandex.cloud.folder-id";
    private static final String PROPERTY_USE_GLOSSARY = "yandex.cloud.use-glossary";
    private static final String PROPERTY_KEEP_TAGS = "yandex.cloud.keep-tags";
    private static final int MAX_GLOSSARY_TERMS = 50;
    private static final int MAX_TEXT_LENGTH = 10000;
    private static final int IAM_TOKEN_TTL_SECONDS = 3600;
    private static final String IAM_TOKEN_URL = "https://iam.api.cloud.yandex.net/iam/v1/tokens";
    private static final String TRANSLATE_URL = "https://translate.api.cloud.yandex.net/translate/v2/translate";
    private String IAMErrorMessage = null;
    private String cachedIAMToken = null;
    private long lastIAMTokenTime = 0L;

    @Override
    public String getName() {
        return OStrings.getString("MT_ENGINE_YANDEX_CLOUD");
    }

    @Override
    public boolean isConfigurable() {
        return true;
    }

    @Override
    public String translate(Language sLang, Language tLang, String text) {
        String response;
        Map<String, String> glossaryTerms;
        if (!this.enabled) {
            return null;
        }
        String trText = text.length() > 10000 ? text.substring(0, 9997) + "..." : text;
        String prev = this.getFromCache(sLang, tLang, trText);
        if (prev != null) {
            return prev;
        }
        String oAuthToken = this.getCredential(PROPERTY_OAUTH_TOKEN);
        if (oAuthToken == null || oAuthToken.isEmpty()) {
            return OStrings.getString("MT_ENGINE_YANDEX_CLOUD_OAUTH_TOKEN_NOT_FOUND");
        }
        String folderId = this.getCredential(PROPERTY_FOLDER_ID);
        if (folderId == null || folderId.isEmpty()) {
            return OStrings.getString("MT_ENGINE_YANDEX_CLOUD_FOLDER_ID_NOT_FOUND");
        }
        String IAMToken = this.getIAMToken(oAuthToken);
        if (IAMToken == null) {
            return this.IAMErrorMessage;
        }
        StringBuilder requestBuilder = new StringBuilder("{").append("\"sourceLanguageCode\":\"").append(sLang.getLanguageCode().toLowerCase()).append("\",").append("\"targetLanguageCode\":\"").append(tLang.getLanguageCode().toLowerCase()).append("\",").append("\"folderId\": \"").append(folderId).append("\",");
        if (Preferences.isPreference(PROPERTY_KEEP_TAGS)) {
            requestBuilder.append("\"format\": \"HTML\",");
        }
        if (Preferences.isPreference(PROPERTY_USE_GLOSSARY) && !(glossaryTerms = this.glossarySupplier.get()).isEmpty()) {
            requestBuilder.append(this.getGlossaryConfigPart(glossaryTerms));
        }
        requestBuilder.append("\"texts\": [").append(JsonParser.quote(trText)).append("]}");
        TreeMap<String, String> headers = new TreeMap<String, String>();
        headers.put("Authorization", "Bearer " + IAMToken);
        try {
            response = WikiGet.postJSON(TRANSLATE_URL, requestBuilder.toString(), headers);
        }
        catch (WikiGet.ResponseError e) {
            String errorMessage = this.extractErrorMessage(e.body);
            if (errorMessage == null) {
                errorMessage = OStrings.getString("MT_ENGINE_YANDEX_CLOUD_BAD_TRANSLATE_RESPONSE");
            }
            return errorMessage;
        }
        catch (IOException e) {
            return e.getLocalizedMessage();
        }
        String tr = this.extractTranslation(response);
        if (tr == null) {
            return "";
        }
        tr = this.cleanSpacesAroundTags(tr, trText);
        this.putToCache(sLang, tLang, trText, tr);
        return tr;
    }

    @Override
    public void showConfigurationUI(Window parent) {
        JPanel extraPanel = new JPanel();
        extraPanel.setAlignmentX(0.0f);
        extraPanel.setLayout(new BoxLayout(extraPanel, 1));
        extraPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 15, 0));
        final JCheckBox glossaryCheckBox = new JCheckBox(OStrings.getString("MT_ENGINE_YANDEX_CLOUD_GLOSSARY_CHECKBOX"));
        extraPanel.add(glossaryCheckBox);
        final JCheckBox keepTagsCheckBox = new JCheckBox(OStrings.getString("MT_ENGINE_YANDEX_CLOUD_KEEP_TAGS_CHECKBOX"));
        extraPanel.add(keepTagsCheckBox);
        MTConfigDialog dialog = new MTConfigDialog(parent, this.getName()){

            @Override
            protected void onConfirm() {
                boolean temporary = this.panel.temporaryCheckBox.isSelected();
                String folderId = this.panel.valueField1.getText().trim();
                YandexCloudTranslate.this.setCredential(YandexCloudTranslate.PROPERTY_FOLDER_ID, folderId, temporary);
                String oAuthToken = this.panel.valueField2.getText().trim();
                YandexCloudTranslate.this.setCredential(YandexCloudTranslate.PROPERTY_OAUTH_TOKEN, oAuthToken, temporary);
                Preferences.setPreference(YandexCloudTranslate.PROPERTY_USE_GLOSSARY, glossaryCheckBox.isSelected());
                Preferences.setPreference(YandexCloudTranslate.PROPERTY_KEEP_TAGS, keepTagsCheckBox.isSelected());
            }
        };
        dialog.panel.itemsPanel.add(extraPanel);
        dialog.panel.valueLabel1.setText(OStrings.getString("MT_ENGINE_YANDEX_CLOUD_FOLDER_ID_LABEL"));
        dialog.panel.valueField1.setText(this.getCredential(PROPERTY_FOLDER_ID));
        dialog.panel.valueLabel2.setText(OStrings.getString("MT_ENGINE_YANDEX_CLOUD_OAUTH_TOKEN_LABEL"));
        dialog.panel.valueField2.setText(this.getCredential(PROPERTY_OAUTH_TOKEN));
        dialog.panel.temporaryCheckBox.setSelected(this.isCredentialStoredTemporarily(PROPERTY_OAUTH_TOKEN));
        glossaryCheckBox.setSelected(Preferences.isPreferenceDefault(PROPERTY_USE_GLOSSARY, false));
        keepTagsCheckBox.setSelected(Preferences.isPreferenceDefault(PROPERTY_KEEP_TAGS, true));
        dialog.show();
    }

    @Override
    protected String getPreferenceName() {
        return "allow_yandex_cloud_translate";
    }

    private String extractErrorMessage(String json) {
        try {
            Map rootNode = (Map)JsonParser.parse(json);
            return (String)rootNode.get("message");
        }
        catch (Exception e) {
            Log.logErrorRB(e, "MT_ENGINE_YANDEX_CLOUD_BAD_ERROR_REPORT", new Object[0]);
            return null;
        }
    }

    private String extractTranslation(String json) {
        try {
            Map rootNode = (Map)JsonParser.parse(json);
            List translationsList = (List)rootNode.get("translations");
            Map translationNode = (Map)translationsList.get(0);
            return (String)translationNode.get("text");
        }
        catch (Exception e) {
            Log.logErrorRB(e, "MT_JSON_ERROR", new Object[0]);
            return OStrings.getString("MT_ENGINE_YANDEX_CLOUD_BAD_TRANSLATE_RESPONSE");
        }
    }

    private String getIAMToken(String oAuthToken) {
        if (System.currentTimeMillis() - this.lastIAMTokenTime > 3600000L) {
            String response;
            String request = "{\"yandexPassportOauthToken\":\"" + oAuthToken + "\"}";
            try {
                response = WikiGet.postJSON(IAM_TOKEN_URL, request, null);
            }
            catch (WikiGet.ResponseError e) {
                this.IAMErrorMessage = this.extractErrorMessage(e.body);
                if (this.IAMErrorMessage == null) {
                    this.IAMErrorMessage = OStrings.getString("MT_ENGINE_YANDEX_CLOUD_BAD_IAM_RESPONSE");
                }
                return null;
            }
            catch (IOException e) {
                this.IAMErrorMessage = e.getLocalizedMessage();
                return null;
            }
            try {
                Map rootNode = (Map)JsonParser.parse(response);
                this.cachedIAMToken = (String)rootNode.get("iamToken");
                this.lastIAMTokenTime = System.currentTimeMillis();
            }
            catch (Exception e) {
                Log.logErrorRB(e, "MT_ENGINE_YANDEX_CLOUD_BAD_IAM_RESPONSE", new Object[0]);
                this.IAMErrorMessage = OStrings.getString("MT_ENGINE_YANDEX_CLOUD_BAD_IAM_RESPONSE");
                return null;
            }
        }
        return this.cachedIAMToken;
    }

    private String getGlossaryConfigPart(Map<String, String> glossaryTerms) {
        StringBuilder sb = new StringBuilder("\"glossaryConfig\":{\"glossaryData\":{\"glossaryPairs\":[");
        String termsJson = glossaryTerms.entrySet().stream().limit(50L).map(e -> this.buildOneGlossaryJson((String)e.getKey(), (String)e.getValue())).collect(Collectors.joining(","));
        return sb.append(termsJson).append("]}},").toString();
    }

    private String buildOneGlossaryJson(String sourceText, String targetText) {
        return "{\"sourceText\":" + JsonParser.quote(sourceText) + ",\"translatedText\":" + JsonParser.quote(targetText) + "}";
    }
}

