/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.editor.mark;

import org.omegat.core.Core;
import org.omegat.gui.editor.mark.AbstractMarker;
import org.omegat.gui.editor.mark.SymbolPainter;
import org.omegat.util.OStrings;
import org.omegat.util.gui.Styles;

public class WhitespaceMarkerFactory {

    public static class LFMarker
    extends AbstractMarker {
        public LFMarker() throws Exception {
            this.painter = new SymbolPainter(Styles.EditorColor.COLOR_WHITESPACE.getColor(), "\u00b6");
            this.toolTip = "LF";
            this.patternChar = 10;
        }

        @Override
        protected boolean isEnabled() {
            return Core.getEditor().getSettings().isMarkWhitespace();
        }
    }

    public static class TabMarker
    extends AbstractMarker {
        public TabMarker() throws Exception {
            this.painter = new SymbolPainter(Styles.EditorColor.COLOR_WHITESPACE.getColor(), "\u00bb");
            this.toolTip = OStrings.getString("MARKER_TAB");
            this.patternChar = 9;
        }

        @Override
        protected boolean isEnabled() {
            return Core.getEditor().getSettings().isMarkWhitespace();
        }
    }

    public static class SpaceMarker
    extends AbstractMarker {
        public SpaceMarker() throws Exception {
            this.painter = new SymbolPainter(Styles.EditorColor.COLOR_WHITESPACE.getColor(), "\u00b7");
            this.toolTip = null;
            this.patternChar = 32;
        }

        @Override
        protected boolean isEnabled() {
            return Core.getEditor().getSettings().isMarkWhitespace();
        }
    }
}

