/*
 * Decompiled with CFR 0.152.
 */
package net.loomchild.maligna.filter.modifier;

import java.util.ArrayList;
import java.util.List;
import net.loomchild.maligna.coretypes.Alignment;
import net.loomchild.maligna.filter.Filter;
import net.loomchild.maligna.filter.modifier.modify.ModifyAlgorithm;

public class Modifier
implements Filter {
    private ModifyAlgorithm sourceAlgorithm;
    private ModifyAlgorithm targetAlgorithm;

    public Modifier(ModifyAlgorithm sourceAlgorithm, ModifyAlgorithm targetAlgorithm) {
        this.sourceAlgorithm = sourceAlgorithm;
        this.targetAlgorithm = targetAlgorithm;
    }

    @Override
    public List<Alignment> apply(List<Alignment> alignmentList) {
        ArrayList<Alignment> newAlignmentList = new ArrayList<Alignment>();
        for (Alignment alignment : alignmentList) {
            List<String> sourceSegmentList = this.sourceAlgorithm.modify(alignment.getSourceSegmentList());
            List<String> targetSegmentList = this.targetAlgorithm.modify(alignment.getTargetSegmentList());
            Alignment newAlignment = new Alignment(sourceSegmentList, targetSegmentList, alignment.getScore());
            newAlignmentList.add(newAlignment);
        }
        return newAlignmentList;
    }
}

