/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanWeight;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.ToStringUtils;

public class BooleanQuery
extends Query
implements Iterable<BooleanClause> {
    private static int maxClauseCount = 1024;
    private ArrayList<BooleanClause> clauses = new ArrayList();
    private final boolean disableCoord;
    protected int minNrShouldMatch = 0;

    public static int getMaxClauseCount() {
        return maxClauseCount;
    }

    public static void setMaxClauseCount(int maxClauseCount) {
        if (maxClauseCount < 1) {
            throw new IllegalArgumentException("maxClauseCount must be >= 1");
        }
        BooleanQuery.maxClauseCount = maxClauseCount;
    }

    public BooleanQuery() {
        this.disableCoord = false;
    }

    public BooleanQuery(boolean disableCoord) {
        this.disableCoord = disableCoord;
    }

    public boolean isCoordDisabled() {
        return this.disableCoord;
    }

    public void setMinimumNumberShouldMatch(int min) {
        this.minNrShouldMatch = min;
    }

    public int getMinimumNumberShouldMatch() {
        return this.minNrShouldMatch;
    }

    public void add(Query query, BooleanClause.Occur occur) {
        this.add(new BooleanClause(query, occur));
    }

    public void add(BooleanClause clause) {
        Objects.requireNonNull(clause, "BooleanClause must not be null");
        if (this.clauses.size() >= maxClauseCount) {
            throw new TooManyClauses();
        }
        this.clauses.add(clause);
    }

    public BooleanClause[] getClauses() {
        return this.clauses.toArray(new BooleanClause[this.clauses.size()]);
    }

    public List<BooleanClause> clauses() {
        return this.clauses;
    }

    @Override
    public final Iterator<BooleanClause> iterator() {
        return this.clauses().iterator();
    }

    private static BooleanQuery downgradeMustClauseToFilter(BooleanQuery bq) {
        BooleanQuery clone = bq.clone();
        clone.clauses.clear();
        for (BooleanClause clause : bq.clauses()) {
            if (clause.getOccur() == BooleanClause.Occur.MUST) {
                clone.add(clause.getQuery(), BooleanClause.Occur.FILTER);
                continue;
            }
            clone.add(clause);
        }
        return clone;
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
        BooleanQuery query = this;
        if (!needsScores) {
            query = BooleanQuery.downgradeMustClauseToFilter(query);
        }
        return new BooleanWeight(query, searcher, needsScores, this.disableCoord);
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        BooleanClause c;
        if (this.minNrShouldMatch == 0 && this.clauses.size() == 1 && !(c = this.clauses.get(0)).isProhibited()) {
            Query query = c.getQuery().rewrite(reader);
            if (c.isScoring()) {
                if (this.getBoost() != 1.0f) {
                    if (query == c.getQuery()) {
                        query = query.clone();
                    }
                    query.setBoost(this.getBoost() * query.getBoost());
                }
            } else if (query.getBoost() != 0.0f) {
                query = query.clone();
                query.setBoost(0.0f);
            }
            return query;
        }
        BooleanQuery clone = null;
        for (int i = 0; i < this.clauses.size(); ++i) {
            BooleanClause c2 = this.clauses.get(i);
            Query query = c2.getQuery().rewrite(reader);
            if (query == c2.getQuery()) continue;
            if (clone == null) {
                clone = this.clone();
            }
            clone.clauses.set(i, new BooleanClause(query, c2.getOccur()));
        }
        if (clone != null) {
            return clone;
        }
        return this;
    }

    @Override
    public BooleanQuery clone() {
        BooleanQuery clone = (BooleanQuery)super.clone();
        clone.clauses = new ArrayList<BooleanClause>(this.clauses);
        return clone;
    }

    @Override
    public String toString(String field) {
        boolean needParens;
        StringBuilder buffer = new StringBuilder();
        boolean bl = needParens = (double)this.getBoost() != 1.0 || this.getMinimumNumberShouldMatch() > 0;
        if (needParens) {
            buffer.append("(");
        }
        for (int i = 0; i < this.clauses.size(); ++i) {
            BooleanClause c = this.clauses.get(i);
            buffer.append(c.getOccur().toString());
            Query subQuery = c.getQuery();
            if (subQuery != null) {
                if (subQuery instanceof BooleanQuery) {
                    buffer.append("(");
                    buffer.append(subQuery.toString(field));
                    buffer.append(")");
                } else {
                    buffer.append(subQuery.toString(field));
                }
            } else {
                buffer.append("null");
            }
            if (i == this.clauses.size() - 1) continue;
            buffer.append(" ");
        }
        if (needParens) {
            buffer.append(")");
        }
        if (this.getMinimumNumberShouldMatch() > 0) {
            buffer.append('~');
            buffer.append(this.getMinimumNumberShouldMatch());
        }
        if (this.getBoost() != 1.0f) {
            buffer.append(ToStringUtils.boost(this.getBoost()));
        }
        return buffer.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof BooleanQuery)) {
            return false;
        }
        BooleanQuery other = (BooleanQuery)o;
        return super.equals(o) && this.clauses.equals(other.clauses) && this.getMinimumNumberShouldMatch() == other.getMinimumNumberShouldMatch() && this.disableCoord == other.disableCoord;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.clauses.hashCode() + this.getMinimumNumberShouldMatch() + (this.disableCoord ? 17 : 0);
    }

    public static class TooManyClauses
    extends RuntimeException {
        public TooManyClauses() {
            super("maxClauseCount is set to " + maxClauseCount);
        }
    }
}

