/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.team2.impl;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Map;
import org.eclipse.jgit.api.errors.CanceledException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.lib.CommitBuilder;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.GpgConfig;
import org.eclipse.jgit.lib.GpgSignature;
import org.eclipse.jgit.lib.GpgSignatureVerifier;
import org.eclipse.jgit.lib.GpgSignatureVerifierFactory;
import org.eclipse.jgit.lib.GpgSigner;
import org.eclipse.jgit.lib.ObjectBuilder;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.StringUtils;
import org.eclipse.jgit.util.SystemReader;
import org.eclipse.jgit.util.TemporaryBuffer;
import org.omegat.util.Log;
import org.omegat.util.OStrings;
import org.omegat.util.Platform;

public class GITExternalGpgSigner
extends GpgSigner {
    private static final String PINENTRY_USER_DATA = "PINENTRY_USER_DATA";
    private static final byte[] SIGNATURE_START = "-----BEGIN PGP SIGNATURE-----".getBytes(StandardCharsets.US_ASCII);
    private static final PathScanner FROM_PATH = new PathScanner();
    private static final String ExternalGpgSigner_processInterrupted = "GPG_EXTERNAL_SIGNER_PROCESS_INTERRUPTED";
    private static final String ExternalGpgSigner_processFailed = "GPG_EXTERNAL_SIGNER_PROCESS_FAILED";
    private static final String ExternalGpgSigner_bufferError = "GPG_EXTERNAL_SIGNER_BUFFER_ERROR";
    private static final String ExternalGpgSigner_environmentError = "GPG_EXTERNAL_SIGNER_ENVIRONMENT_ERROR";
    private static final String ExternalGpgSigner_noKeyFound = "GPG_EXTERNAL_SIGNER_NO_KEY_FOUND";
    private static final String ExternalGpgSigner_skipNotAccessiblePath = "GPG_EXTERNAL_SIGNER_SKIP_NOT_ACCESSIBLE_PATH";
    private static final String ExternalGpgSigner_cannotSearch = "GPG_EXTERNAL_SIGNER_CANNOT_SEARCH";
    private static final String ExternalGpgSigner_signingCanceled = "GPG_EXTERNAL_SIGNER_SIGNING_CANCELED";
    private static final String ExternalGpgSigner_noSignature = "GPG_EXTERNAL_SIGNER_NO_SIGNATURE";
    private static final String ExternalGpgSigner_gpgNotFound = "GPG_EXTERNAL_SIGNER_GPG_NOT_FOUND";

    private static void runProcess(ProcessBuilder process, InputStream in, ResultHandler stdout, ResultHandler stderr) throws IOException, CanceledException {
        String command = String.join((CharSequence)" ", process.command());
        FS.ExecutionResult result = null;
        int code = 0;
        try {
            result = FS.DETECTED.execute(process, in);
            code = result.getRc();
            if (code != 0) {
                if (stderr != null) {
                    stderr.accept(result.getStderr());
                }
                throw new IOException(MessageFormat.format(OStrings.getString(ExternalGpgSigner_processFailed), command, code + ": " + GITExternalGpgSigner.toString(result.getStderr())));
            }
            stdout.accept(result.getStdout());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException(MessageFormat.format(OStrings.getString(ExternalGpgSigner_processInterrupted), command), e);
        }
        catch (IOException e) {
            if (code != 0) {
                throw e;
            }
            if (result != null) {
                throw new IOException(MessageFormat.format(OStrings.getString(ExternalGpgSigner_processFailed), command, GITExternalGpgSigner.toString(result.getStderr())), e);
            }
            throw new IOException(MessageFormat.format(OStrings.getString(ExternalGpgSigner_processFailed), command, e.getLocalizedMessage()), e);
        }
        finally {
            if (result != null) {
                if (result.getStderr() != null) {
                    result.getStderr().destroy();
                }
                if (result.getStdout() != null) {
                    result.getStdout().destroy();
                }
            }
        }
    }

    private static String toString(TemporaryBuffer b) {
        if (b != null) {
            try {
                return new String(b.toByteArray(4000), Charset.defaultCharset());
            }
            catch (IOException e) {
                Log.logWarningRB(ExternalGpgSigner_bufferError, e);
            }
        }
        return "";
    }

    public void sign(CommitBuilder commit, String gpgSigningKey, PersonIdent committer, CredentialsProvider credentialsProvider) throws CanceledException {
        this.signObject((ObjectBuilder)commit, gpgSigningKey, committer, credentialsProvider);
    }

    private void signObject(ObjectBuilder object, String gpgSigningKey, PersonIdent committer, CredentialsProvider credentialsProvider) throws CanceledException {
        try {
            Object keySpec = gpgSigningKey;
            if (StringUtils.isEmptyOrNull((String)keySpec)) {
                if (committer == null) {
                    throw new CanceledException("Cannot determine signature key");
                }
                keySpec = "<" + committer.getEmailAddress() + ">";
            }
            GpgConfig config = new GpgConfig(new Config());
            String program = config.getProgram();
            object.setGpgSignature(new GpgSignature(this.signWithGpg(object.build(), (String)keySpec, program)));
        }
        catch (IOException e) {
            throw new JGitInternalException(e.getMessage(), (Throwable)e);
        }
    }

    public boolean canLocateSigningKey(String gpgSigningKey, PersonIdent committer, CredentialsProvider credentialsProvider) throws CanceledException {
        String program = FROM_PATH.getGpg();
        if (StringUtils.isEmptyOrNull((String)program)) {
            return false;
        }
        Object keySpec = gpgSigningKey;
        if (StringUtils.isEmptyOrNull((String)keySpec)) {
            keySpec = "<" + committer.getEmailAddress() + ">";
        }
        ProcessBuilder process = new ProcessBuilder(new String[0]);
        process.command(new String[]{program, "--locate-keys", "--with-colons", "--batch", "--no-tty", keySpec});
        this.gpgEnvironment(process);
        try {
            boolean[] result = new boolean[]{false};
            GITExternalGpgSigner.runProcess(process, null, b -> {
                try (BufferedReader r = new BufferedReader(new InputStreamReader(b.openInputStream(), StandardCharsets.UTF_8));){
                    String line;
                    boolean keyFound = false;
                    while ((line = r.readLine()) != null) {
                        String[] fields;
                        if (!line.startsWith("pub:") && !line.startsWith("sub:") || (fields = line.split(":")).length <= 11 || fields[11].indexOf(115) < 0) continue;
                        keyFound = true;
                        break;
                    }
                    result[0] = keyFound;
                }
            }, null);
            if (!result[0] && !StringUtils.isEmptyOrNull((String)gpgSigningKey)) {
                Log.logWarningRB(ExternalGpgSigner_noKeyFound, gpgSigningKey);
            }
            return result[0];
        }
        catch (IOException e) {
            Log.logErrorRB(e.getLocalizedMessage(), e);
            return false;
        }
    }

    private byte[] signWithGpg(byte[] data, String keySpec, String gpgProgram) throws IOException, CanceledException {
        String program = gpgProgram;
        if (StringUtils.isEmptyOrNull((String)program) && StringUtils.isEmptyOrNull((String)(program = FROM_PATH.getGpg()))) {
            throw new IOException(OStrings.getString(ExternalGpgSigner_gpgNotFound));
        }
        ProcessBuilder process = new ProcessBuilder(new String[0]);
        process.command(program, "-bsau", keySpec, "--batch", "--no-tty", "--status-fd", "2", "--output", "-");
        this.gpgEnvironment(process);
        try (ByteArrayInputStream dataIn = new ByteArrayInputStream(data);){
            class Holder {
                byte[] rawData;

                Holder() {
                }
            }
            Holder result = new Holder();
            GITExternalGpgSigner.runProcess(process, dataIn, b -> {
                boolean isValid;
                GpgSignatureVerifierFactory factory = GpgSignatureVerifierFactory.getDefault();
                if (factory == null) {
                    byte[] fromGpg = b.toByteArray(SIGNATURE_START.length);
                    isValid = Arrays.equals(fromGpg, SIGNATURE_START);
                    if (isValid) {
                        result.rawData = b.toByteArray();
                    }
                } else {
                    byte[] fromGpg = b.toByteArray();
                    GpgSignatureVerifier verifier = factory.getVerifier();
                    try {
                        GpgSignatureVerifier.SignatureVerification verification = verifier.verify(data, fromGpg);
                        boolean bl = isValid = verification != null && verification.getVerified();
                        if (isValid) {
                            result.rawData = fromGpg;
                        }
                    }
                    catch (JGitInternalException e) {
                        throw new IOException(e.getLocalizedMessage(), e);
                    }
                    finally {
                        verifier.clear();
                    }
                }
                if (!isValid) {
                    throw new IOException(MessageFormat.format(OStrings.getString(ExternalGpgSigner_noSignature), GITExternalGpgSigner.toString(b)));
                }
            }, e -> {
                try (BufferedReader r = new BufferedReader(new InputStreamReader(e.openInputStream(), StandardCharsets.UTF_8));){
                    String line;
                    boolean pinentry = false;
                    while ((line = r.readLine()) != null) {
                        if (!pinentry && line.startsWith("[GNUPG:] PINENTRY_LAUNCHED")) {
                            pinentry = true;
                            continue;
                        }
                        if (!pinentry) continue;
                        if (line.startsWith("[GNUPG:] FAILURE sign")) {
                            throw new CanceledException(OStrings.getString(ExternalGpgSigner_signingCanceled));
                        }
                        if (!line.startsWith("[GNUPG:]")) continue;
                        pinentry = false;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            });
            byte[] byArray = result.rawData;
            return byArray;
        }
    }

    private void gpgEnvironment(ProcessBuilder process) {
        try {
            Map<String, String> childEnv = process.environment();
            String value = childEnv.get(PINENTRY_USER_DATA);
            if (!StringUtils.isEmptyOrNull((String)value)) {
                childEnv.remove(PINENTRY_USER_DATA);
            }
        }
        catch (IllegalArgumentException | SecurityException | UnsupportedOperationException e) {
            Log.logWarningRB(ExternalGpgSigner_environmentError, e);
        }
    }

    private static class PathScanner {
        private String gpg;

        private PathScanner() {
        }

        synchronized String getGpg() {
            if (this.gpg == null) {
                this.gpg = PathScanner.findGpg();
            }
            return this.gpg.isEmpty() ? null : this.gpg;
        }

        private static String findGpg() {
            String bash;
            SystemReader system = SystemReader.getInstance();
            String path = system.getenv("PATH");
            String exe = null;
            if (Platform.isMacOSX() && (bash = PathScanner.searchPath(path, "bash")) != null) {
                ProcessBuilder process = new ProcessBuilder(new String[0]);
                process.command(bash, "--login", "-c", "which gpg");
                process.directory(FS.DETECTED.userHome());
                String[] result = new String[]{null};
                try {
                    GITExternalGpgSigner.runProcess(process, null, b -> {
                        try (BufferedReader r = new BufferedReader(new InputStreamReader(b.openInputStream(), Charset.defaultCharset()));){
                            result[0] = r.readLine();
                        }
                    }, null);
                }
                catch (IOException | CanceledException e) {
                    Log.logWarningRB(GITExternalGpgSigner.ExternalGpgSigner_cannotSearch, e);
                }
                exe = result[0];
            }
            if (exe == null) {
                exe = PathScanner.searchPath(path, system.isWindows() ? "gpg.exe" : "gpg");
            }
            return exe == null ? "" : exe;
        }

        private static String searchPath(String path, String name) {
            if (StringUtils.isEmptyOrNull((String)path)) {
                return null;
            }
            for (String p : path.split(File.pathSeparator)) {
                File exe = new File(p, name);
                try {
                    if (!exe.isFile() || !exe.canExecute()) continue;
                    return exe.getAbsolutePath();
                }
                catch (SecurityException e) {
                    Log.logWarningRB(GITExternalGpgSigner.ExternalGpgSigner_skipNotAccessiblePath, exe.getPath(), e);
                }
            }
            return null;
        }
    }

    private static interface ResultHandler {
        public void accept(TemporaryBuffer var1) throws IOException, CanceledException;
    }
}

