/*
 * Decompiled with CFR 0.152.
 */
package com.android.uiautomator;

import com.android.uiautomator.tree.BasicTreeNode;
import com.android.uiautomator.tree.UiHierarchyXmlLoader;
import com.android.uiautomator.tree.UiNode;
import java.io.File;
import java.util.List;
import org.eclipse.swt.graphics.Rectangle;

public class UiAutomatorModel {
    private BasicTreeNode mRootNode;
    private BasicTreeNode mSelectedNode;
    private Rectangle mCurrentDrawingRect;
    private List<Rectangle> mNafNodes;
    private boolean mExploreMode = true;
    private boolean mShowNafNodes = false;

    public UiAutomatorModel(File xmlDumpFile) {
        UiHierarchyXmlLoader loader = new UiHierarchyXmlLoader();
        BasicTreeNode rootNode = loader.parseXml(xmlDumpFile.getAbsolutePath());
        if (rootNode == null) {
            System.err.println("null rootnode after parsing.");
            throw new IllegalArgumentException("Invalid ui automator hierarchy file.");
        }
        this.mNafNodes = loader.getNafNodes();
        if (this.mRootNode != null) {
            this.mRootNode.clearAllChildren();
        }
        this.mRootNode = rootNode;
        this.mExploreMode = true;
    }

    public BasicTreeNode getXmlRootNode() {
        return this.mRootNode;
    }

    public BasicTreeNode getSelectedNode() {
        return this.mSelectedNode;
    }

    public void setSelectedNode(BasicTreeNode node) {
        this.mSelectedNode = node;
        if (this.mSelectedNode instanceof UiNode) {
            UiNode uiNode = (UiNode)this.mSelectedNode;
            this.mCurrentDrawingRect = new Rectangle(uiNode.x, uiNode.y, uiNode.width, uiNode.height);
        } else {
            this.mCurrentDrawingRect = null;
        }
    }

    public Rectangle getCurrentDrawingRect() {
        return this.mCurrentDrawingRect;
    }

    public BasicTreeNode updateSelectionForCoordinates(int x, int y) {
        MinAreaFindNodeListener listener;
        boolean found;
        BasicTreeNode node = null;
        if (this.mRootNode != null && (found = this.mRootNode.findLeafMostNodesAtPoint(x, y, listener = new MinAreaFindNodeListener())) && listener.mNode != null && !listener.mNode.equals(this.mSelectedNode)) {
            node = listener.mNode;
        }
        return node;
    }

    public boolean isExploreMode() {
        return this.mExploreMode;
    }

    public void toggleExploreMode() {
        this.mExploreMode = !this.mExploreMode;
    }

    public void setExploreMode(boolean exploreMode) {
        this.mExploreMode = exploreMode;
    }

    public List<Rectangle> getNafNodes() {
        return this.mNafNodes;
    }

    public void toggleShowNaf() {
        this.mShowNafNodes = !this.mShowNafNodes;
    }

    public boolean shouldShowNafNodes() {
        return this.mShowNafNodes;
    }

    private static class MinAreaFindNodeListener
    implements BasicTreeNode.IFindNodeListener {
        BasicTreeNode mNode = null;

        private MinAreaFindNodeListener() {
        }

        @Override
        public void onFoundNode(BasicTreeNode node) {
            if (this.mNode == null) {
                this.mNode = node;
            } else if (node.height * node.width < this.mNode.height * this.mNode.width) {
                this.mNode = node;
            }
        }
    }
}

