/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.accessibility;

import java.util.Vector;
import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.accessibility.AccessibleTextEvent;
import org.eclipse.swt.accessibility.AccessibleTextListener;
import org.eclipse.swt.internal.carbon.CFRange;
import org.eclipse.swt.internal.carbon.CGPoint;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.widgets.Control;

public class Accessible {
    static final String[] requiredAttributes = new String[]{"AXRole", "AXSubrole", "AXRoleDescription", "AXHelp", "AXTitle", "AXValue", "AXEnabled", "AXFocused", "AXParent", "AXChildren", "AXSelectedChildren", "AXVisibleChildren", "AXWindow", "AXTopLevelUIElement", "AXPosition", "AXSize", "AXDescription"};
    static final String[] textAttributes = new String[]{"AXNumberOfCharacters", "AXSelectedText", "AXSelectedTextRange", "AXStringForRange", "AXInsertionPointLineNumber", "AXRangeForLine"};
    Vector accessibleListeners = new Vector();
    Vector accessibleControlListeners = new Vector();
    Vector accessibleTextListeners = new Vector();
    Control control;
    int axuielementref = 0;
    int[] osChildIDCache = new int[0];

    protected Accessible() {
    }

    Accessible(Control control) {
        this.control = control;
        this.axuielementref = OS.AXUIElementCreateWithHIObjectAndIdentifier(control.handle, 0L);
        OS.HIObjectSetAccessibilityIgnored(control.handle, false);
    }

    public static Accessible internal_new_Accessible(Control control) {
        return new Accessible(control);
    }

    public void addAccessibleListener(AccessibleListener accessibleListener) {
        this.checkWidget();
        if (accessibleListener == null) {
            SWT.error(4);
        }
        this.accessibleListeners.addElement(accessibleListener);
    }

    public void addAccessibleControlListener(AccessibleControlListener accessibleControlListener) {
        this.checkWidget();
        if (accessibleControlListener == null) {
            SWT.error(4);
        }
        this.accessibleControlListeners.addElement(accessibleControlListener);
    }

    public void addAccessibleTextListener(AccessibleTextListener accessibleTextListener) {
        this.checkWidget();
        if (accessibleTextListener == null) {
            SWT.error(4);
        }
        this.accessibleTextListeners.addElement(accessibleTextListener);
    }

    public Control getControl() {
        return this.control;
    }

    public void internal_dispose_Accessible() {
        if (this.axuielementref != 0) {
            OS.CFRelease(this.axuielementref);
            this.axuielementref = 0;
            int n = 1;
            while (n < this.osChildIDCache.length) {
                OS.CFRelease(this.osChildIDCache[n]);
                n += 2;
            }
            this.osChildIDCache = new int[0];
        }
    }

    public int internal_kEventAccessibleGetChildAtPoint(int n, int n2, int n3) {
        if (this.axuielementref != 0) {
            OS.CallNextEventHandler(n, n2);
            int n4 = this.getChildIDFromEvent(n2);
            CGPoint cGPoint = new CGPoint();
            OS.GetEventParameter(n2, 1835822947, 1751740532, null, 8, null, cGPoint);
            AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(this);
            accessibleControlEvent.x = (int)cGPoint.x;
            accessibleControlEvent.y = (int)cGPoint.y;
            accessibleControlEvent.childID = -1;
            int n5 = 0;
            while (n5 < this.accessibleControlListeners.size()) {
                AccessibleControlListener accessibleControlListener = (AccessibleControlListener)this.accessibleControlListeners.elementAt(n5);
                accessibleControlListener.getChildAtPoint(accessibleControlEvent);
                ++n5;
            }
            if (accessibleControlEvent.accessible != null) {
                OS.SetEventParameter(n2, 1633904748, 1667658873, 4, new int[]{accessibleControlEvent.accessible.axuielementref});
                return 0;
            }
            if (accessibleControlEvent.childID == -1 || accessibleControlEvent.childID == -2 || accessibleControlEvent.childID == n4) {
                return 0;
            }
            OS.SetEventParameter(n2, 1633904748, 1667658873, 4, new int[]{this.childIDToOs(accessibleControlEvent.childID)});
            return 0;
        }
        return -9874;
    }

    public int internal_kEventAccessibleGetFocusedChild(int n, int n2, int n3) {
        if (this.axuielementref != 0) {
            int n4 = OS.CallNextEventHandler(n, n2);
            int n5 = this.getChildIDFromEvent(n2);
            if (n5 != -1) {
                return 0;
            }
            AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(this);
            accessibleControlEvent.childID = -3;
            accessibleControlEvent.accessible = null;
            int n6 = 0;
            while (n6 < this.accessibleControlListeners.size()) {
                AccessibleControlListener accessibleControlListener = (AccessibleControlListener)this.accessibleControlListeners.elementAt(n6);
                accessibleControlListener.getFocus(accessibleControlEvent);
                ++n6;
            }
            if (accessibleControlEvent.accessible != null) {
                OS.SetEventParameter(n2, 1633904748, 1667658873, 4, new int[]{accessibleControlEvent.accessible.axuielementref});
                return 0;
            }
            if (accessibleControlEvent.childID == -1) {
                OS.SetEventParameter(n2, 1633904748, 1667658873, 4, new int[1]);
                return 0;
            }
            if (accessibleControlEvent.childID == -2) {
                return 0;
            }
            if (accessibleControlEvent.childID != -3) {
                OS.SetEventParameter(n2, 1633904748, 1667658873, 4, new int[]{this.childIDToOs(accessibleControlEvent.childID)});
                return 0;
            }
            return n4;
        }
        return -9874;
    }

    public int internal_kEventAccessibleGetAllAttributeNames(int n, int n2, int n3) {
        int n4 = n3;
        if (this.axuielementref != 0) {
            int n5;
            if (n4 == -9874) {
                OS.CallNextEventHandler(n, n2);
            }
            int[] nArray = new int[1];
            OS.GetEventParameter(n2, 1635020403, 1667657057, null, 4, null, nArray);
            int n6 = nArray[0];
            int n7 = OS.CFArrayGetCount(n6);
            String[] stringArray = new String[n7];
            int n8 = 0;
            while (n8 < n7) {
                n5 = OS.CFArrayGetValueAtIndex(n6, n8);
                stringArray[n8] = this.stringRefToString(n5);
                ++n8;
            }
            n8 = 0;
            while (n8 < requiredAttributes.length) {
                if (!this.contains(stringArray, requiredAttributes[n8])) {
                    n5 = this.stringToStringRef(requiredAttributes[n8]);
                    OS.CFArrayAppendValue(n6, n5);
                    OS.CFRelease(n5);
                }
                ++n8;
            }
            if (this.accessibleTextListeners.size() > 0) {
                n8 = 0;
                while (n8 < textAttributes.length) {
                    if (!this.contains(stringArray, textAttributes[n8])) {
                        n5 = this.stringToStringRef(textAttributes[n8]);
                        OS.CFArrayAppendValue(n6, n5);
                        OS.CFRelease(n5);
                    }
                    ++n8;
                }
            }
            n4 = 0;
        }
        return n4;
    }

    boolean contains(String[] stringArray, String string) {
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public int internal_kEventAccessibleGetNamedAttribute(int n, int n2, int n3) {
        if (this.axuielementref != 0) {
            int[] nArray = new int[1];
            OS.GetEventParameter(n2, 1635020397, 1667658612, null, 4, null, nArray);
            int n4 = 0;
            if (nArray[0] != 0) {
                n4 = OS.CFStringGetLength(nArray[0]);
            }
            char[] cArray = new char[n4];
            CFRange cFRange = new CFRange();
            cFRange.length = n4;
            OS.CFStringGetCharacters(nArray[0], cFRange, cArray);
            String string = new String(cArray);
            if (string.equals("AXRole")) {
                return this.getRoleAttribute(n, n2, n3);
            }
            if (string.equals("AXSubrole")) {
                return this.getSubroleAttribute(n, n2, n3);
            }
            if (string.equals("AXRoleDescription")) {
                return this.getRoleDescriptionAttribute(n, n2, n3);
            }
            if (string.equals("AXHelp")) {
                return this.getHelpAttribute(n, n2, n3);
            }
            if (string.equals("AXTitle")) {
                return this.getTitleAttribute(n, n2, n3);
            }
            if (string.equals("AXValue")) {
                return this.getValueAttribute(n, n2, n3);
            }
            if (string.equals("AXEnabled")) {
                return this.getEnabledAttribute(n, n2, n3);
            }
            if (string.equals("AXFocused")) {
                return this.getFocusedAttribute(n, n2, n3);
            }
            if (string.equals("AXParent")) {
                return this.getParentAttribute(n, n2, n3);
            }
            if (string.equals("AXChildren")) {
                return this.getChildrenAttribute(n, n2, n3);
            }
            if (string.equals("AXSelectedChildren")) {
                return this.getSelectedChildrenAttribute(n, n2, n3);
            }
            if (string.equals("AXVisibleChildren")) {
                return this.getVisibleChildrenAttribute(n, n2, n3);
            }
            if (string.equals("AXPosition")) {
                return this.getPositionAttribute(n, n2, n3);
            }
            if (string.equals("AXSize")) {
                return this.getSizeAttribute(n, n2, n3);
            }
            if (string.equals("AXDescription")) {
                return this.getDescriptionAttribute(n, n2, n3);
            }
            if (string.equals("AXNumberOfCharacters")) {
                return this.getNumberOfCharactersAttribute(n, n2, n3);
            }
            if (string.equals("AXSelectedText")) {
                return this.getSelectedTextAttribute(n, n2, n3);
            }
            if (string.equals("AXSelectedTextRange")) {
                return this.getSelectedTextRangeAttribute(n, n2, n3);
            }
            if (string.equals("AXStringForRange")) {
                return this.getStringForRangeAttribute(n, n2, n3);
            }
            if (string.equals("AXInsertionPointLineNumber")) {
                return this.getInsertionPointLineNumberAttribute(n, n2, n3);
            }
            if (string.equals("AXRangeForLine")) {
                return this.getRangeForLineParameterizedAttribute(n, n2, n3);
            }
            return this.getAttribute(n, n2, n3);
        }
        return n3;
    }

    int getAttribute(int n, int n2, int n3) {
        int n4;
        int n5 = n4 = n3 != -9874 ? n3 : OS.CallNextEventHandler(n, n2);
        if (n4 != 0 && this.getChildIDFromEvent(n2) != -1) {
            OS.SetEventParameter(n2, 1634689642, 1667658873, 4, new int[]{this.axuielementref});
            n4 = OS.CallNextEventHandler(n, n2);
        }
        return n4;
    }

    int getHelpAttribute(int n, int n2, int n3) {
        int n4 = n3 != -9874 ? n3 : OS.CallNextEventHandler(n, n2);
        String string = null;
        int[] nArray = new int[1];
        if (n4 == 0) {
            OS.GetEventParameter(n2, 1635022444, 1667658612, null, 4, null, nArray);
            string = this.stringRefToString(nArray[0]);
        }
        AccessibleEvent accessibleEvent = new AccessibleEvent(this);
        accessibleEvent.childID = this.getChildIDFromEvent(n2);
        accessibleEvent.result = string;
        int n5 = 0;
        while (n5 < this.accessibleListeners.size()) {
            AccessibleListener accessibleListener = (AccessibleListener)this.accessibleListeners.elementAt(n5);
            accessibleListener.getHelp(accessibleEvent);
            ++n5;
        }
        if (accessibleEvent.result != null) {
            nArray[0] = this.stringToStringRef(accessibleEvent.result);
            if (nArray[0] != 0) {
                OS.SetEventParameter(n2, 1635022444, 1667658612, 4, nArray);
                OS.CFRelease(nArray[0]);
                n4 = 0;
            }
        }
        return n4;
    }

    int getRoleAttribute(int n, int n2, int n3) {
        int n4 = n3;
        AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(this);
        accessibleControlEvent.childID = this.getChildIDFromEvent(n2);
        accessibleControlEvent.detail = -1;
        int n5 = 0;
        while (n5 < this.accessibleControlListeners.size()) {
            AccessibleControlListener accessibleControlListener = (AccessibleControlListener)this.accessibleControlListeners.elementAt(n5);
            accessibleControlListener.getRole(accessibleControlEvent);
            ++n5;
        }
        if (accessibleControlEvent.detail != -1) {
            int n6;
            String string = this.roleToOs(accessibleControlEvent.detail);
            int n7 = string.indexOf(58);
            if (n7 != -1) {
                string = string.substring(0, n7);
            }
            if ((n6 = this.stringToStringRef(string)) != 0) {
                OS.SetEventParameter(n2, 1635022444, 1667658612, 4, new int[]{n6});
                OS.CFRelease(n6);
                n4 = 0;
            }
        }
        return n4;
    }

    int getSubroleAttribute(int n, int n2, int n3) {
        int n4 = n3;
        AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(this);
        accessibleControlEvent.childID = this.getChildIDFromEvent(n2);
        accessibleControlEvent.detail = -1;
        int n5 = 0;
        while (n5 < this.accessibleControlListeners.size()) {
            AccessibleControlListener accessibleControlListener = (AccessibleControlListener)this.accessibleControlListeners.elementAt(n5);
            accessibleControlListener.getRole(accessibleControlEvent);
            ++n5;
        }
        if (accessibleControlEvent.detail != -1) {
            int n6;
            String string = this.roleToOs(accessibleControlEvent.detail);
            int n7 = string.indexOf(58);
            if (n7 != -1 && (n6 = this.stringToStringRef(string = string.substring(n7 + 1))) != 0) {
                OS.SetEventParameter(n2, 1635022444, 1667658612, 4, new int[]{n6});
                OS.CFRelease(n6);
            }
            n4 = 0;
        }
        return n4;
    }

    int getRoleDescriptionAttribute(int n, int n2, int n3) {
        Object object;
        int n4 = n3;
        AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(this);
        accessibleControlEvent.childID = this.getChildIDFromEvent(n2);
        accessibleControlEvent.detail = -1;
        int n5 = 0;
        while (n5 < this.accessibleControlListeners.size()) {
            object = (AccessibleControlListener)this.accessibleControlListeners.elementAt(n5);
            object.getRole(accessibleControlEvent);
            ++n5;
        }
        if (accessibleControlEvent.detail != -1) {
            int n6;
            String string = this.roleToOs(accessibleControlEvent.detail);
            object = null;
            int n7 = string.indexOf(58);
            if (n7 != -1) {
                object = string.substring(n7 + 1);
                string = string.substring(0, n7);
            }
            if ((n6 = this.stringToStringRef(string)) != 0) {
                int n8 = 0;
                if (object != null) {
                    n8 = this.stringToStringRef((String)object);
                }
                int n9 = OS.HICopyAccessibilityRoleDescription(n6, n8);
                OS.CFRelease(n6);
                if (n8 != 0) {
                    OS.CFRelease(n8);
                }
                if (n9 != 0) {
                    OS.SetEventParameter(n2, 1635022444, 1667658612, 4, new int[]{n9});
                    OS.CFRelease(n9);
                    n4 = 0;
                }
            }
        }
        return n4;
    }

    int getTitleAttribute(int n, int n2, int n3) {
        Object object;
        int n4 = n3 != -9874 ? n3 : OS.CallNextEventHandler(n, n2);
        int n5 = this.getChildIDFromEvent(n2);
        AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(this);
        accessibleControlEvent.childID = n5;
        accessibleControlEvent.detail = -1;
        int n6 = 0;
        while (n6 < this.accessibleControlListeners.size()) {
            object = (AccessibleControlListener)this.accessibleControlListeners.elementAt(n6);
            object.getRole(accessibleControlEvent);
            ++n6;
        }
        if (accessibleControlEvent.detail != 41) {
            int n7;
            String string = null;
            object = new int[1];
            if (n4 == 0 && (n7 = OS.GetEventParameter(n2, 1635022444, 1667658612, null, 4, null, (int[])object)) == 0) {
                string = this.stringRefToString((int)object[0]);
            }
            AccessibleEvent accessibleEvent = new AccessibleEvent(this);
            accessibleEvent.childID = n5;
            accessibleEvent.result = string;
            int n8 = 0;
            while (n8 < this.accessibleListeners.size()) {
                AccessibleListener accessibleListener = (AccessibleListener)this.accessibleListeners.elementAt(n8);
                accessibleListener.getName(accessibleEvent);
                ++n8;
            }
            if (accessibleEvent.result != null) {
                object[0] = this.stringToStringRef(accessibleEvent.result);
                if (object[0] != false) {
                    OS.SetEventParameter(n2, 1635022444, 1667658612, 4, (int[])object);
                    OS.CFRelease((int)object[0]);
                    n4 = 0;
                }
            }
        }
        return n4;
    }

    int getValueAttribute(int n, int n2, int n3) {
        Object object;
        int n4 = n3 != -9874 ? n3 : OS.CallNextEventHandler(n, n2);
        int n5 = this.getChildIDFromEvent(n2);
        AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(this);
        accessibleControlEvent.childID = n5;
        accessibleControlEvent.detail = -1;
        accessibleControlEvent.result = null;
        int n6 = 0;
        while (n6 < this.accessibleControlListeners.size()) {
            object = (AccessibleControlListener)this.accessibleControlListeners.elementAt(n6);
            object.getRole(accessibleControlEvent);
            object.getValue(accessibleControlEvent);
            ++n6;
        }
        n6 = accessibleControlEvent.detail;
        object = accessibleControlEvent.result;
        if (object != null || n6 == 41) {
            int n7 = 0;
            switch (n6) {
                case 3: 
                case 37: 
                case 44: 
                case 45: 
                case 48: 
                case 51: {
                    try {
                        int n8 = Integer.parseInt((String)object);
                        OS.SetEventParameter(n2, 1635022444, 1819242087, 4, new int[]{n8});
                        n4 = 0;
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (((String)object).equalsIgnoreCase("true")) {
                            OS.SetEventParameter(n2, 1635022444, 1651470188, 4, new boolean[]{true});
                            n4 = 0;
                            break;
                        }
                        if (!((String)object).equalsIgnoreCase("false")) break;
                        OS.SetEventParameter(n2, 1635022444, 1651470188, 4, new boolean[1]);
                        n4 = 0;
                    }
                    break;
                }
                case 42: 
                case 46: 
                case 60: {
                    n7 = this.stringToStringRef((String)object);
                    break;
                }
                case 41: {
                    AccessibleEvent accessibleEvent = new AccessibleEvent(this);
                    accessibleEvent.childID = n5;
                    accessibleEvent.result = null;
                    int n9 = 0;
                    while (n9 < this.accessibleListeners.size()) {
                        AccessibleListener accessibleListener = (AccessibleListener)this.accessibleListeners.elementAt(n9);
                        accessibleListener.getName(accessibleEvent);
                        ++n9;
                    }
                    if (accessibleEvent.result != null) {
                        n7 = this.stringToStringRef(accessibleEvent.result);
                        break;
                    }
                    if (object == null) break;
                    n7 = this.stringToStringRef((String)object);
                }
            }
            if (n7 != 0) {
                OS.SetEventParameter(n2, 1635022444, 1667658612, 4, new int[]{n7});
                OS.CFRelease(n7);
                n4 = 0;
            }
        }
        return n4;
    }

    int getEnabledAttribute(int n, int n2, int n3) {
        int n4;
        int n5 = n4 = n3 != -9874 ? n3 : OS.CallNextEventHandler(n, n2);
        if (n4 == -9874) {
            OS.SetEventParameter(n2, 1635022444, 1651470188, 4, new boolean[]{this.control.isEnabled()});
            n4 = 0;
        }
        return n4;
    }

    int getFocusedAttribute(int n, int n2, int n3) {
        int[] nArray = new int[1];
        OS.GetEventParameter(n2, 1634689642, 1667658873, null, 4, null, nArray);
        AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(this);
        accessibleControlEvent.childID = -3;
        accessibleControlEvent.accessible = null;
        int n4 = 0;
        while (n4 < this.accessibleControlListeners.size()) {
            AccessibleControlListener accessibleControlListener = (AccessibleControlListener)this.accessibleControlListeners.elementAt(n4);
            accessibleControlListener.getFocus(accessibleControlEvent);
            ++n4;
        }
        if (accessibleControlEvent.accessible != null) {
            n4 = OS.CFEqual(accessibleControlEvent.accessible.axuielementref, nArray[0]) ? 1 : 0;
            OS.SetEventParameter(n2, 1635022444, 1651470188, 4, new boolean[]{n4});
            return 0;
        }
        if (accessibleControlEvent.childID == -1) {
            n4 = OS.CFEqual(this.axuielementref, nArray[0]) ? 1 : 0;
            OS.SetEventParameter(n2, 1635022444, 1651470188, 4, new boolean[]{n4});
            return 0;
        }
        if (accessibleControlEvent.childID == -2) {
            OS.SetEventParameter(n2, 1635022444, 1651470188, 4, new boolean[1]);
            return 0;
        }
        if (accessibleControlEvent.childID != -3) {
            n4 = this.osToChildID(nArray[0]);
            OS.SetEventParameter(n2, 1635022444, 1651470188, 4, new boolean[]{accessibleControlEvent.childID == n4});
            return 0;
        }
        n4 = 0;
        int n5 = OS.GetUserFocusWindow();
        if (n5 != 0) {
            int[] nArray2 = new int[1];
            OS.GetKeyboardFocus(n5, nArray2);
            if (nArray2[0] == this.control.handle) {
                n4 = 1;
            }
        }
        OS.SetEventParameter(n2, 1635022444, 1651470188, 4, new boolean[]{n4});
        return 0;
    }

    int getParentAttribute(int n, int n2, int n3) {
        int n4;
        int n5 = n4 = n3 != -9874 ? n3 : OS.CallNextEventHandler(n, n2);
        if (n4 == -9874) {
            OS.SetEventParameter(n2, 1635022444, 1667658873, 4, new int[]{this.axuielementref});
            n4 = 0;
        }
        return n4;
    }

    int getChildrenAttribute(int n, int n2, int n3) {
        int n4 = n3;
        int n5 = this.getChildIDFromEvent(n2);
        if (n5 == -1) {
            AccessibleControlListener accessibleControlListener;
            AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(this);
            accessibleControlEvent.childID = n5;
            accessibleControlEvent.detail = -1;
            int n6 = 0;
            while (n6 < this.accessibleControlListeners.size()) {
                accessibleControlListener = (AccessibleControlListener)this.accessibleControlListeners.elementAt(n6);
                accessibleControlListener.getChildCount(accessibleControlEvent);
                ++n6;
            }
            if (accessibleControlEvent.detail == 0) {
                n4 = 0;
            } else if (accessibleControlEvent.detail > 0) {
                int n7;
                n6 = 0;
                while (n6 < this.accessibleControlListeners.size()) {
                    accessibleControlListener = (AccessibleControlListener)this.accessibleControlListeners.elementAt(n6);
                    accessibleControlListener.getChildren(accessibleControlEvent);
                    ++n6;
                }
                Object[] objectArray = accessibleControlEvent.children;
                if (objectArray != null && objectArray.length > 0 && (n7 = OS.CFArrayCreateMutable(0, 0, 0)) != 0) {
                    int n8 = 0;
                    while (n8 < objectArray.length) {
                        Object object = objectArray[n8];
                        if (object instanceof Integer) {
                            OS.CFArrayAppendValue(n7, this.childIDToOs((Integer)object));
                        } else {
                            OS.CFArrayAppendValue(n7, ((Accessible)object).axuielementref);
                        }
                        ++n8;
                    }
                    OS.SetEventParameter(n2, 1635022444, 1667657057, 4, new int[]{n7});
                    OS.CFRelease(n7);
                    n4 = 0;
                }
            }
        }
        return n4;
    }

    int getSelectedChildrenAttribute(int n, int n2, int n3) {
        return this.getAttribute(n, n2, n3);
    }

    int getVisibleChildrenAttribute(int n, int n2, int n3) {
        return this.getAttribute(n, n2, n3);
    }

    int getPositionAttribute(int n, int n2, int n3) {
        int n4 = n3 != -9874 ? n3 : OS.CallNextEventHandler(n, n2);
        CGPoint cGPoint = new CGPoint();
        if (n4 == 0) {
            OS.GetEventParameter(n2, 1635022444, 1751740532, null, 8, null, cGPoint);
        }
        AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(this);
        accessibleControlEvent.childID = this.getChildIDFromEvent(n2);
        accessibleControlEvent.x = (int)cGPoint.x;
        accessibleControlEvent.y = (int)cGPoint.y;
        if (n4 != 0) {
            accessibleControlEvent.width = -1;
        }
        int n5 = 0;
        while (n5 < this.accessibleControlListeners.size()) {
            AccessibleControlListener accessibleControlListener = (AccessibleControlListener)this.accessibleControlListeners.elementAt(n5);
            accessibleControlListener.getLocation(accessibleControlEvent);
            ++n5;
        }
        if (accessibleControlEvent.width != -1) {
            cGPoint.x = accessibleControlEvent.x;
            cGPoint.y = accessibleControlEvent.y;
            OS.SetEventParameter(n2, 1635022444, 1751740532, 8, cGPoint);
            n4 = 0;
        }
        return n4;
    }

    int getSizeAttribute(int n, int n2, int n3) {
        int n4 = n3 != -9874 ? n3 : OS.CallNextEventHandler(n, n2);
        CGPoint cGPoint = new CGPoint();
        if (n4 == 0) {
            OS.GetEventParameter(n2, 1635022444, 1751741306, null, 8, null, cGPoint);
        }
        AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(this);
        accessibleControlEvent.childID = this.getChildIDFromEvent(n2);
        accessibleControlEvent.width = n4 != 0 ? -1 : (int)cGPoint.x;
        accessibleControlEvent.height = (int)cGPoint.y;
        int n5 = 0;
        while (n5 < this.accessibleControlListeners.size()) {
            AccessibleControlListener accessibleControlListener = (AccessibleControlListener)this.accessibleControlListeners.elementAt(n5);
            accessibleControlListener.getLocation(accessibleControlEvent);
            ++n5;
        }
        if (accessibleControlEvent.width != -1) {
            cGPoint.x = accessibleControlEvent.width;
            cGPoint.y = accessibleControlEvent.height;
            OS.SetEventParameter(n2, 1635022444, 1751741306, 8, cGPoint);
            n4 = 0;
        }
        return n4;
    }

    int getDescriptionAttribute(int n, int n2, int n3) {
        int n4;
        int n5 = n3 != -9874 ? n3 : OS.CallNextEventHandler(n, n2);
        String string = null;
        int[] nArray = new int[1];
        if (n5 == 0 && (n4 = OS.GetEventParameter(n2, 1635022444, 1667658612, null, 4, null, nArray)) == 0) {
            string = this.stringRefToString(nArray[0]);
        }
        AccessibleEvent accessibleEvent = new AccessibleEvent(this);
        accessibleEvent.childID = this.getChildIDFromEvent(n2);
        accessibleEvent.result = string;
        int n6 = 0;
        while (n6 < this.accessibleListeners.size()) {
            AccessibleListener accessibleListener = (AccessibleListener)this.accessibleListeners.elementAt(n6);
            accessibleListener.getDescription(accessibleEvent);
            ++n6;
        }
        if (accessibleEvent.result != null) {
            nArray[0] = this.stringToStringRef(accessibleEvent.result);
            if (nArray[0] != 0) {
                OS.SetEventParameter(n2, 1635022444, 1667658612, 4, nArray);
                OS.CFRelease(nArray[0]);
                n5 = 0;
            }
        }
        return n5;
    }

    int getInsertionPointLineNumberAttribute(int n, int n2, int n3) {
        int n4 = n3;
        AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(this);
        accessibleControlEvent.childID = this.getChildIDFromEvent(n2);
        accessibleControlEvent.result = null;
        int n5 = 0;
        while (n5 < this.accessibleControlListeners.size()) {
            AccessibleControlListener accessibleControlListener = (AccessibleControlListener)this.accessibleControlListeners.elementAt(n5);
            accessibleControlListener.getValue(accessibleControlEvent);
            ++n5;
        }
        AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(this);
        accessibleTextEvent.childID = this.getChildIDFromEvent(n2);
        accessibleTextEvent.offset = -1;
        int n6 = 0;
        while (n6 < this.accessibleTextListeners.size()) {
            AccessibleTextListener accessibleTextListener = (AccessibleTextListener)this.accessibleTextListeners.elementAt(n6);
            accessibleTextListener.getCaretOffset(accessibleTextEvent);
            ++n6;
        }
        if (accessibleControlEvent.result != null && accessibleTextEvent.offset != -1) {
            n6 = this.lineNumberForOffset(accessibleControlEvent.result, accessibleTextEvent.offset);
            OS.SetEventParameter(n2, 1635022444, 1819242087, 4, new int[]{n6});
            n4 = 0;
        }
        return n4;
    }

    int getNumberOfCharactersAttribute(int n, int n2, int n3) {
        int n4 = n3;
        AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(this);
        accessibleControlEvent.childID = this.getChildIDFromEvent(n2);
        accessibleControlEvent.result = null;
        int n5 = 0;
        while (n5 < this.accessibleControlListeners.size()) {
            AccessibleControlListener accessibleControlListener = (AccessibleControlListener)this.accessibleControlListeners.elementAt(n5);
            accessibleControlListener.getValue(accessibleControlEvent);
            ++n5;
        }
        String string = accessibleControlEvent.result;
        if (string != null) {
            OS.SetEventParameter(n2, 1635022444, 1819242087, 4, new int[]{string.length()});
            n4 = 0;
        }
        return n4;
    }

    int getRangeForLineParameterizedAttribute(int n, int n2, int n3) {
        int n4 = n3;
        int[] nArray = new int[1];
        int n5 = OS.GetEventParameter(n2, 1635020897, 1819242087, null, 4, null, nArray);
        if (n5 == 0) {
            AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(this);
            accessibleControlEvent.childID = this.getChildIDFromEvent(n2);
            accessibleControlEvent.result = null;
            int n6 = 0;
            while (n6 < this.accessibleControlListeners.size()) {
                AccessibleControlListener accessibleControlListener = (AccessibleControlListener)this.accessibleControlListeners.elementAt(n6);
                accessibleControlListener.getValue(accessibleControlEvent);
                ++n6;
            }
            if (accessibleControlEvent.result != null) {
                CFRange cFRange = this.rangeForLineNumber(nArray[0], accessibleControlEvent.result);
                if (cFRange.location != -1) {
                    int n7 = OS.AXValueCreate(4, cFRange);
                    OS.SetEventParameter(n2, 1635022444, 1667658873, 4, new int[]{n7});
                    OS.CFRelease(n7);
                    n4 = 0;
                }
            }
        }
        return n4;
    }

    int getSelectedTextAttribute(int n, int n2, int n3) {
        int n4 = n3;
        AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(this);
        accessibleTextEvent.childID = this.getChildIDFromEvent(n2);
        accessibleTextEvent.offset = -1;
        accessibleTextEvent.length = -1;
        int n5 = 0;
        while (n5 < this.accessibleTextListeners.size()) {
            AccessibleTextListener accessibleTextListener = (AccessibleTextListener)this.accessibleTextListeners.elementAt(n5);
            accessibleTextListener.getSelectionRange(accessibleTextEvent);
            ++n5;
        }
        n5 = accessibleTextEvent.offset;
        int n6 = accessibleTextEvent.length;
        if (n5 != -1 && n6 != -1 && n6 != 0) {
            int n7;
            AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(this);
            accessibleControlEvent.childID = accessibleTextEvent.childID;
            accessibleControlEvent.result = null;
            int n8 = 0;
            while (n8 < this.accessibleControlListeners.size()) {
                AccessibleControlListener accessibleControlListener = (AccessibleControlListener)this.accessibleControlListeners.elementAt(n8);
                accessibleControlListener.getValue(accessibleControlEvent);
                ++n8;
            }
            String string = accessibleControlEvent.result;
            if (string != null && (n7 = this.stringToStringRef(string.substring(n5, n5 + n6))) != 0) {
                OS.SetEventParameter(n2, 1635022444, 1667658612, 4, new int[]{n7});
                OS.CFRelease(n7);
                n4 = 0;
            }
        }
        return n4;
    }

    int getSelectedTextRangeAttribute(int n, int n2, int n3) {
        int n4 = n3;
        AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(this);
        accessibleTextEvent.childID = this.getChildIDFromEvent(n2);
        accessibleTextEvent.offset = -1;
        accessibleTextEvent.length = -1;
        int n5 = 0;
        while (n5 < this.accessibleTextListeners.size()) {
            AccessibleTextListener accessibleTextListener = (AccessibleTextListener)this.accessibleTextListeners.elementAt(n5);
            accessibleTextListener.getSelectionRange(accessibleTextEvent);
            ++n5;
        }
        if (accessibleTextEvent.offset != -1) {
            CFRange cFRange = new CFRange();
            cFRange.location = accessibleTextEvent.offset;
            cFRange.length = accessibleTextEvent.length;
            int n6 = OS.AXValueCreate(4, cFRange);
            OS.SetEventParameter(n2, 1635022444, 1667658873, 4, new int[]{n6});
            OS.CFRelease(n6);
            n4 = 0;
        }
        return n4;
    }

    int getStringForRangeAttribute(int n, int n2, int n3) {
        CFRange cFRange;
        boolean bl;
        int n4 = n3;
        int[] nArray = new int[1];
        int n5 = OS.GetEventParameter(n2, 1635020897, 1667658873, null, 4, null, nArray);
        if (n5 == 0 && (bl = OS.AXValueGetValue(nArray[0], 4, cFRange = new CFRange()))) {
            int n6;
            AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(this);
            accessibleControlEvent.childID = this.getChildIDFromEvent(n2);
            accessibleControlEvent.result = null;
            int n7 = 0;
            while (n7 < this.accessibleControlListeners.size()) {
                AccessibleControlListener accessibleControlListener = (AccessibleControlListener)this.accessibleControlListeners.elementAt(n7);
                accessibleControlListener.getValue(accessibleControlEvent);
                ++n7;
            }
            String string = accessibleControlEvent.result;
            if (string != null && (n6 = this.stringToStringRef(string.substring(cFRange.location, cFRange.location + cFRange.length))) != 0) {
                OS.SetEventParameter(n2, 1635022444, 1667658612, 4, new int[]{n6});
                OS.CFRelease(n6);
                n4 = 0;
            }
        }
        return n4;
    }

    int lineNumberForOffset(String string, int n) {
        int n2 = 1;
        int n3 = string.length();
        int n4 = 0;
        while (n4 < n) {
            switch (string.charAt(n4)) {
                case '\r': {
                    if (n4 + 1 < n3 && string.charAt(n4 + 1) == '\n') {
                        ++n4;
                    }
                }
                case '\n': {
                    ++n2;
                }
            }
            ++n4;
        }
        return n2;
    }

    CFRange rangeForLineNumber(int n, String string) {
        CFRange cFRange = new CFRange();
        cFRange.location = -1;
        int n2 = 1;
        int n3 = 0;
        int n4 = string.length();
        int n5 = 0;
        while (n5 < n4) {
            if (n2 == n) {
                if (n3 == 0) {
                    cFRange.location = n5;
                }
                ++n3;
            }
            if (n2 > n) break;
            switch (string.charAt(n5)) {
                case '\r': {
                    if (n5 + 1 < n4 && string.charAt(n5 + 1) == '\n') {
                        ++n5;
                    }
                }
                case '\n': {
                    ++n2;
                }
            }
            ++n5;
        }
        cFRange.length = n3;
        return cFRange;
    }

    public void removeAccessibleListener(AccessibleListener accessibleListener) {
        this.checkWidget();
        if (accessibleListener == null) {
            SWT.error(4);
        }
        this.accessibleListeners.removeElement(accessibleListener);
    }

    public void removeAccessibleControlListener(AccessibleControlListener accessibleControlListener) {
        this.checkWidget();
        if (accessibleControlListener == null) {
            SWT.error(4);
        }
        this.accessibleControlListeners.removeElement(accessibleControlListener);
    }

    public void removeAccessibleTextListener(AccessibleTextListener accessibleTextListener) {
        this.checkWidget();
        if (accessibleTextListener == null) {
            SWT.error(4);
        }
        this.accessibleTextListeners.removeElement(accessibleTextListener);
    }

    public void selectionChanged() {
        this.checkWidget();
        int n = this.stringToStringRef("AXSelectedChildrenChanged");
        OS.AXNotificationHIObjectNotify(n, this.control.handle, 0L);
        OS.CFRelease(n);
    }

    public void setFocus(int n) {
        this.checkWidget();
        this.childIDToOs(n);
        int n2 = this.stringToStringRef("AXFocusedUIElementChanged");
        OS.AXNotificationHIObjectNotify(n2, this.control.handle, 0L);
        OS.CFRelease(n2);
    }

    public void textCaretMoved(int n) {
        this.checkWidget();
        int n2 = this.stringToStringRef("AXSelectedTextChanged");
        OS.AXNotificationHIObjectNotify(n2, this.control.handle, 0L);
        OS.CFRelease(n2);
    }

    public void textChanged(int n, int n2, int n3) {
        this.checkWidget();
        int n4 = this.stringToStringRef("AXValueChanged");
        OS.AXNotificationHIObjectNotify(n4, this.control.handle, 0L);
        OS.CFRelease(n4);
    }

    public void textSelectionChanged() {
        this.checkWidget();
        int n = this.stringToStringRef("AXSelectedTextChanged");
        OS.AXNotificationHIObjectNotify(n, this.control.handle, 0L);
        OS.CFRelease(n);
    }

    int getChildIDFromEvent(int n) {
        int[] nArray = new int[1];
        OS.GetEventParameter(n, 1634689642, 1667658873, null, 4, null, nArray);
        return this.osToChildID(nArray[0]);
    }

    int childIDToOs(int n) {
        if (n == -1) {
            return this.axuielementref;
        }
        int n2 = 0;
        while (n2 < this.osChildIDCache.length) {
            if (n == this.osChildIDCache[n2]) {
                return this.osChildIDCache[n2 + 1];
            }
            n2 += 2;
        }
        int n3 = OS.AXUIElementCreateWithHIObjectAndIdentifier(this.control.handle, n + 1);
        int[] nArray = new int[this.osChildIDCache.length + 2];
        System.arraycopy(this.osChildIDCache, 0, nArray, 0, this.osChildIDCache.length);
        this.osChildIDCache = nArray;
        this.osChildIDCache[n2] = n;
        this.osChildIDCache[n2 + 1] = n3;
        return n3;
    }

    int osToChildID(int n) {
        if (OS.CFEqual(n, this.axuielementref)) {
            return -1;
        }
        long[] lArray = new long[1];
        OS.AXUIElementGetIdentifier(n, lArray);
        if (lArray[0] == 0L) {
            return -1;
        }
        return (int)lArray[0] - 1;
    }

    int stateToOs(int n) {
        return n;
    }

    int osToState(int n) {
        return n;
    }

    String roleToOs(int n) {
        switch (n) {
            case 10: {
                return "AXGroup";
            }
            case 9: {
                return "AXWindow";
            }
            case 2: {
                return "AXMenuBar";
            }
            case 11: {
                return "AXMenu";
            }
            case 12: {
                return "AXMenuItem";
            }
            case 21: {
                return "AXSplitter";
            }
            case 13: {
                return "AXHelpTag";
            }
            case 3: {
                return "AXScrollBar";
            }
            case 18: {
                return "AXWindow:AXDialog";
            }
            case 41: {
                return "AXStaticText";
            }
            case 43: {
                return "AXButton";
            }
            case 44: {
                return "AXCheckBox";
            }
            case 45: {
                return "AXRadioButton";
            }
            case 62: {
                return "AXMenuButton";
            }
            case 46: {
                return "AXComboBox";
            }
            case 42: {
                return (this.control.getStyle() & 2) != 0 ? "AXTextArea" : "AXTextField";
            }
            case 22: {
                return "AXToolbar";
            }
            case 33: {
                return "AXOutline";
            }
            case 34: {
                return "AXStaticText";
            }
            case 24: {
                return "AXTable";
            }
            case 29: {
                return "AXRow:AXTableRow";
            }
            case 25: {
                return "AXButton:AXSortButton";
            }
            case 26: {
                return "AXRow:AXTableRow";
            }
            case 35: {
                return "AXOutline";
            }
            case 36: {
                return "AXOutline:AXOutlineRow";
            }
            case 60: {
                return "AXTabGroup";
            }
            case 37: {
                return "AXRadioButton";
            }
            case 48: {
                return "AXProgressIndicator";
            }
            case 51: {
                return "AXSlider";
            }
            case 30: {
                return "AXLink";
            }
        }
        return "AXUnknown";
    }

    int osToRole(String string) {
        if (string == null) {
            return 0;
        }
        if (string.equals("AXWindow")) {
            return 9;
        }
        if (string.equals("AXMenuBar")) {
            return 2;
        }
        if (string.equals("AXMenu")) {
            return 11;
        }
        if (string.equals("AXMenuItem")) {
            return 12;
        }
        if (string.equals("AXSplitter")) {
            return 21;
        }
        if (string.equals("AXHelpTag")) {
            return 13;
        }
        if (string.equals("AXScrollBar")) {
            return 3;
        }
        if (string.equals("AXScrollArea")) {
            return 33;
        }
        if (string.equals("AXWindow:AXDialog")) {
            return 18;
        }
        if (string.equals("AXWindow:AXSystemDialog")) {
            return 18;
        }
        if (string.equals("AXStaticText")) {
            return 41;
        }
        if (string.equals("AXButton")) {
            return 43;
        }
        if (string.equals("AXCheckBox")) {
            return 44;
        }
        if (string.equals("AXRadioButton")) {
            return 45;
        }
        if (string.equals("AXMenuButton")) {
            return 62;
        }
        if (string.equals("AXComboBox")) {
            return 46;
        }
        if (string.equals("AXTextField")) {
            return 42;
        }
        if (string.equals("AXTextArea")) {
            return 42;
        }
        if (string.equals("AXToolbar")) {
            return 22;
        }
        if (string.equals("AXList")) {
            return 33;
        }
        if (string.equals("AXTable")) {
            return 24;
        }
        if (string.equals("AXColumn")) {
            return 25;
        }
        if (string.equals("AXButton:AXSortButton")) {
            return 25;
        }
        if (string.equals("AXRow:AXTableRow")) {
            return 26;
        }
        if (string.equals("AXOutline")) {
            return 35;
        }
        if (string.equals("AXOutline:AXOutlineRow")) {
            return 36;
        }
        if (string.equals("AXTabGroup")) {
            return 60;
        }
        if (string.equals("AXProgressIndicator")) {
            return 48;
        }
        if (string.equals("AXSlider")) {
            return 51;
        }
        if (string.equals("AXLink")) {
            return 30;
        }
        return 10;
    }

    int stringToStringRef(String string) {
        char[] cArray = new char[string.length()];
        string.getChars(0, cArray.length, cArray, 0);
        return OS.CFStringCreateWithCharacters(0, cArray, cArray.length);
    }

    String stringRefToString(int n) {
        if (n == 0) {
            return "";
        }
        int n2 = OS.CFStringGetLength(n);
        char[] cArray = new char[n2];
        CFRange cFRange = new CFRange();
        cFRange.length = n2;
        OS.CFStringGetCharacters(n, cFRange, cArray);
        return new String(cArray);
    }

    void checkWidget() {
        if (!this.isValidThread()) {
            SWT.error(22);
        }
        if (this.control.isDisposed()) {
            SWT.error(24);
        }
    }

    boolean isValidThread() {
        return this.control.getDisplay().getThread() == Thread.currentThread();
    }
}

