/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ClassContext;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import java.util.Collections;
import java.util.List;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.analysis.Analyzer;
import org.objectweb.asm.tree.analysis.AnalyzerException;
import org.objectweb.asm.tree.analysis.BasicInterpreter;
import org.objectweb.asm.tree.analysis.BasicValue;
import org.objectweb.asm.tree.analysis.Frame;

public class SecureRandomDetector
extends Detector
implements Detector.ClassScanner {
    public static final Issue ISSUE = Issue.create("SecureRandom", "Using a fixed seed with `SecureRandom`", "Looks for suspicious usage of the SecureRandom class", "Specifying a fixed seed will cause the instance to return a predictable sequence of numbers. This may be useful for testing but it is not appropriate for secure use.", Category.PERFORMANCE, 9, Severity.WARNING, new Implementation(SecureRandomDetector.class, Scope.CLASS_FILE_SCOPE)).addMoreInfo("http://developer.android.com/reference/java/security/SecureRandom.html");
    private static final String SET_SEED = "setSeed";
    private static final String OWNER_SECURE_RANDOM = "java/security/SecureRandom";
    private static final String OWNER_RANDOM = "java/util/Random";
    private static final String VM_SECURE_RANDOM = "Ljava/security/SecureRandom;";
    private static final String LONG_ARG = "(J)";

    @Override
    @Nullable
    public List<String> getApplicableCallNames() {
        return Collections.singletonList(SET_SEED);
    }

    @Override
    public void checkCall(@NonNull ClassContext context, @NonNull ClassNode classNode, @NonNull MethodNode method, @NonNull MethodInsnNode call) {
        String owner = call.owner;
        String desc = call.desc;
        if (owner.equals(OWNER_SECURE_RANDOM)) {
            if (desc.startsWith(LONG_ARG)) {
                SecureRandomDetector.checkValidSetSeed(context, call);
            } else if (desc.startsWith("([B)")) {
                // empty if block
            }
        } else if (owner.equals(OWNER_RANDOM) && desc.startsWith(LONG_ARG)) {
            Analyzer analyzer = new Analyzer(new BasicInterpreter(){

                @Override
                public BasicValue newValue(Type type) {
                    if (type != null && type.getDescriptor().equals(SecureRandomDetector.VM_SECURE_RANDOM)) {
                        return new BasicValue(type);
                    }
                    return super.newValue(type);
                }
            });
            try {
                Frame[] frames = analyzer.analyze(classNode.name, method);
                InsnList instructions = method.instructions;
                Frame frame = frames[instructions.indexOf((AbstractInsnNode)call)];
                int stackSlot = frame.getStackSize();
                for (Type type : Type.getArgumentTypes((String)desc)) {
                    stackSlot -= type.getSize();
                }
                BasicValue stackValue = (BasicValue)frame.getStack(stackSlot);
                Type type = stackValue.getType();
                if (type != null && type.getDescriptor().equals(VM_SECURE_RANDOM)) {
                    SecureRandomDetector.checkValidSetSeed(context, call);
                }
            }
            catch (AnalyzerException e) {
                context.log(e, null, new Object[0]);
            }
        } else if (!owner.equals(OWNER_RANDOM) || desc.startsWith(LONG_ARG)) {
            // empty if block
        }
    }

    private static void checkValidSetSeed(ClassContext context, MethodInsnNode call) {
        String methodName;
        assert (call.name.equals(SET_SEED));
        AbstractInsnNode prev = LintUtils.getPrevInstruction((AbstractInsnNode)call);
        if (prev == null) {
            return;
        }
        int opcode = prev.getOpcode();
        if (opcode == 9 || opcode == 10 || opcode == 18) {
            context.report(ISSUE, context.getLocation((AbstractInsnNode)call), "Do not call setSeed() on a SecureRandom with a fixed seed: it is not secure. Use getSeed().", null);
        } else if (opcode == 184 && ((methodName = ((MethodInsnNode)prev).name).equals("currentTimeMillis") || methodName.equals("nanoTime"))) {
            context.report(ISSUE, context.getLocation((AbstractInsnNode)call), "It is dangerous to seed SecureRandom with the current time because that value is more predictable to an attacker than the default seed.", null);
        }
    }
}

