/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.annotations.NonNull;
import com.android.resources.ResourceFolderType;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import com.android.tools.lint.detector.api.XmlContext;
import java.util.Collection;
import java.util.Collections;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class StyleCycleDetector
extends ResourceXmlDetector {
    public static final Issue ISSUE = Issue.create("StyleCycle", "Cycle in style definitions", "Looks for cycles in style definitions", "There should be no cycles in style definitions as this can lead to runtime exceptions.", Category.CORRECTNESS, 8, Severity.FATAL, new Implementation(StyleCycleDetector.class, Scope.RESOURCE_FILE_SCOPE)).addMoreInfo("http://developer.android.com/guide/topics/ui/themes.html#Inheritance");

    @Override
    public boolean appliesTo(@NonNull ResourceFolderType folderType) {
        return folderType == ResourceFolderType.VALUES;
    }

    @Override
    @NonNull
    public Speed getSpeed() {
        return Speed.FAST;
    }

    @Override
    public Collection<String> getApplicableElements() {
        return Collections.singleton("style");
    }

    @Override
    public void visitElement(@NonNull XmlContext context, @NonNull Element element) {
        Attr parentNode = element.getAttributeNode("parent");
        if (parentNode != null) {
            String name;
            String parent = parentNode.getValue();
            if (parent.endsWith(name = element.getAttribute("name")) && parent.equals("@style/" + name)) {
                context.report(ISSUE, parentNode, context.getLocation(parentNode), String.format("Style %1$s should not extend itself", name), null);
            } else if (parent.startsWith("@style/") && parent.startsWith(name, "@style/".length()) && parent.startsWith(".", "@style/".length() + name.length())) {
                context.report(ISSUE, parentNode, context.getLocation(parentNode), String.format("Potential cycle: %1$s is the implied parent of %2$s and this defines the opposite", name, parent.substring("@style/".length())), null);
            }
        }
    }
}

