/*
 * Decompiled with CFR 0.152.
 */
package com.android.jobb;

import Twofish.Twofish_Algorithm;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.security.InvalidKeyException;
import java.util.Arrays;

public class EncryptedBlockFile
extends RandomAccessFile {
    public static final int BYTES_PER_SECTOR = 512;
    private final Object mKey;
    private final EncryptedBlockFileChannel mEBFC = new EncryptedBlockFileChannel(this.getChannel());

    public EncryptedBlockFileChannel getEncryptedFileChannel() {
        return this.mEBFC;
    }

    @Override
    public void setLength(long newLength) throws IOException {
        int numsectors = (int)newLength / 512;
        if (newLength % 512L != 0L) {
            throw new IOException("Invalid file size!");
        }
        super.setLength(newLength);
        byte[] byteBuf = new byte[512];
        ByteBuffer buf = ByteBuffer.wrap(byteBuf);
        for (int i = 0; i < numsectors; ++i) {
            buf.rewind();
            this.mEBFC.write(buf);
        }
    }

    public EncryptedBlockFile(byte[] key, File file, String mode) throws FileNotFoundException, InvalidKeyException {
        super(file, mode);
        if (!file.exists()) {
            throw new FileNotFoundException();
        }
        this.mKey = Twofish_Algorithm.makeKey(key);
    }

    private final class EncryptedBlockFileChannel
    extends FileChannel {
        final FileChannel mFC;

        protected EncryptedBlockFileChannel(FileChannel wrappedFC) {
            this.mFC = wrappedFC;
        }

        @Override
        public void force(boolean metaData) throws IOException {
            this.mFC.force(metaData);
        }

        @Override
        public FileLock lock(long position, long size, boolean shared) throws IOException {
            throw new RuntimeException("Lock not implemented");
        }

        @Override
        public MappedByteBuffer map(FileChannel.MapMode mode, long position, long size) throws IOException {
            throw new RuntimeException("MappedByteBuffer not implemented");
        }

        @Override
        public long position() throws IOException {
            return this.mFC.position();
        }

        @Override
        public FileChannel position(long newPosition) throws IOException {
            this.mFC.position(newPosition);
            return this;
        }

        @Override
        public int read(ByteBuffer dst) throws IOException {
            long position = this.position();
            int read = this.read(dst, position);
            if (read >= 0) {
                this.position(position += (long)read);
            }
            return read;
        }

        @Override
        public int read(ByteBuffer dest, long position) throws IOException {
            boolean isPartial;
            boolean doubleBuffer;
            boolean isMisaligned;
            int toRead;
            int targetRead = toRead = dest.remaining();
            int numSectors = toRead / 512;
            if (position + (long)toRead > EncryptedBlockFile.this.length()) {
                throw new IOException("reading past end of device");
            }
            int firstSector = (int)position / 512;
            int alignmentOff = (int)(position % 512L);
            if (0 != alignmentOff) {
                numSectors = (toRead += alignmentOff) / 512;
                isMisaligned = true;
                doubleBuffer = true;
                System.out.println("Alignment off reading from sector: " + firstSector);
            } else {
                isMisaligned = false;
                doubleBuffer = false;
                alignmentOff = 0;
            }
            int partialReadSize = toRead % 512;
            if (0 != partialReadSize) {
                isPartial = true;
                doubleBuffer = true;
                numSectors = toRead / 512 + 1;
                System.out.println("Partial read from sector: " + firstSector);
            } else {
                isPartial = false;
            }
            ByteBuffer tempDest = doubleBuffer ? ByteBuffer.allocate(512) : null;
            int lastSector = firstSector + numSectors;
            if (isMisaligned) {
                this.readDecryptedSector(firstSector++, tempDest);
                tempDest.position(alignmentOff);
                if (firstSector == lastSector && isPartial) {
                    tempDest.limit(partialReadSize);
                }
                dest.put(tempDest);
            }
            for (int i = firstSector; i < lastSector; ++i) {
                if (firstSector + 1 == lastSector && isPartial) {
                    this.readDecryptedSector(i, tempDest);
                    tempDest.rewind();
                    tempDest.limit(partialReadSize);
                    dest.put(tempDest);
                    continue;
                }
                this.readDecryptedSector(i, dest);
            }
            return targetRead;
        }

        @Override
        public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
            throw new RuntimeException("Scattering Channel Read not implemented");
        }

        @Override
        public long size() throws IOException {
            return this.mFC.size();
        }

        @Override
        public long transferFrom(ReadableByteChannel src, long position, long count) throws IOException {
            throw new RuntimeException("File Channel transfer not implemented");
        }

        @Override
        public long transferTo(long position, long count, WritableByteChannel target) throws IOException {
            throw new RuntimeException("File Channel transfer to not implemented");
        }

        @Override
        public FileChannel truncate(long size) throws IOException {
            this.mFC.truncate(size);
            return this;
        }

        @Override
        public FileLock tryLock(long position, long size, boolean shared) throws IOException {
            return this.mFC.tryLock(position, size, shared);
        }

        @Override
        public int write(ByteBuffer src) throws IOException {
            long position = this.position();
            int write = this.write(src, position);
            if (write >= 0) {
                this.position(position += (long)write);
            }
            return write;
        }

        @Override
        public int write(ByteBuffer src, long position) throws IOException {
            long readOffset;
            int toWrite;
            int targetWrite = toWrite = src.remaining();
            int firstSector = (int)position / 512;
            int numSectors = toWrite / 512;
            boolean fixAccess = false;
            if (0L != position % 512L) {
                long alignmentOff = position % 512L;
                readOffset = position - alignmentOff;
                toWrite = (int)((long)toWrite + alignmentOff);
                numSectors = toWrite / 512;
                fixAccess = true;
                System.out.println("Alignment off writing to sector: " + firstSector);
            } else {
                readOffset = position;
            }
            if (0 != toWrite % 512) {
                numSectors = toWrite / 512 + 1;
                fixAccess = true;
                System.out.println("Partial Sector [" + toWrite % 512 + "] writing to sector: " + firstSector);
            }
            if (fixAccess) {
                ByteBuffer dest = ByteBuffer.allocate(numSectors * 512);
                this.read(dest, readOffset);
                int bufOffset = (int)(position - readOffset);
                dest.position(bufOffset);
                dest.put(src);
                src = dest;
                src.rewind();
            }
            int lastSector = firstSector + numSectors;
            for (int i = firstSector; i < lastSector; ++i) {
                this.writeEncryptedSector(i, src);
            }
            return targetWrite;
        }

        @Override
        public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
            throw new RuntimeException("Scattering Channel Write not implemented");
        }

        @Override
        protected void implCloseChannel() throws IOException {
        }

        private void cryptIVPlainGen(int sector, byte[] out) {
            Arrays.fill(out, (byte)0);
            out[0] = (byte)(sector & 0xFF);
            out[1] = (byte)(sector >> 8 & 0xFF);
            out[2] = (byte)(sector >> 16 & 0xFF);
            out[3] = (byte)(sector >>> 24);
        }

        private void readDecryptedSector(int sector, ByteBuffer dest) throws IOException {
            ByteBuffer temp = ByteBuffer.allocate(512);
            int toRead = 512;
            int devOffset = 512 * sector;
            int blockSize = Twofish_Algorithm.blockSize();
            byte[] bufLast = new byte[blockSize];
            int numBlocks = toRead / blockSize;
            while (toRead > 0) {
                int read = this.mFC.read(temp, devOffset);
                if (read < 0) {
                    throw new IOException();
                }
                toRead -= read;
                devOffset += read;
            }
            temp.rewind();
            this.cryptIVPlainGen(sector, bufLast);
            byte[] buf = new byte[blockSize];
            for (int i = 0; i < numBlocks; ++i) {
                temp.get(buf);
                byte[] decryptBuf = Twofish_Algorithm.blockDecrypt(buf, 0, EncryptedBlockFile.this.mKey);
                for (int j = 0; j < blockSize; ++j) {
                    int n = j;
                    decryptBuf[n] = (byte)(decryptBuf[n] ^ bufLast[j]);
                }
                System.arraycopy(buf, 0, bufLast, 0, blockSize);
                dest.put(decryptBuf);
            }
        }

        private void writeEncryptedSector(int sector, ByteBuffer src) throws IOException {
            byte[] sectorBuf = new byte[512];
            int toRead = 512;
            int devOffset = 512 * sector;
            int blockSize = Twofish_Algorithm.blockSize();
            byte[] bufLast = new byte[blockSize];
            int numBlocks = toRead / blockSize;
            src.get(sectorBuf);
            this.cryptIVPlainGen(sector, bufLast);
            int pos = 0;
            byte[] buf = new byte[blockSize];
            for (int i = 0; i < numBlocks; ++i) {
                System.arraycopy(sectorBuf, pos, buf, 0, blockSize);
                for (int j = 0; j < blockSize; ++j) {
                    int n = j;
                    buf[n] = (byte)(buf[n] ^ bufLast[j]);
                }
                byte[] encryptBuf = Twofish_Algorithm.blockEncrypt(buf, 0, EncryptedBlockFile.this.mKey);
                bufLast = encryptBuf;
                int toWrite = blockSize;
                ByteBuffer encryptBuffer = ByteBuffer.wrap(encryptBuf);
                while (toWrite > 0) {
                    int written = this.mFC.write(encryptBuffer, devOffset);
                    if (written < 0) {
                        throw new IOException();
                    }
                    toWrite -= written;
                    devOffset += written;
                }
                pos += blockSize;
            }
        }
    }
}

