/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.core.status;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ecf.internal.core.ECFPlugin;

public class SerializableStatus
implements IStatus,
Serializable {
    private static final long serialVersionUID = -1874392357776889683L;
    public static final IStatus OK_STATUS = new SerializableStatus(0, "org.eclipse.ecf", 0, "ok", null);
    public static final IStatus CANCEL_STATUS = new SerializableStatus(8, "org.eclipse.ecf", 1, "", null);
    private int severity = 0;
    private String pluginId;
    private int code;
    private String message;
    private Throwable exception = null;
    private static final IStatus[] theEmptyStatusArray = new IStatus[0];

    public SerializableStatus(IStatus status) {
        this.setSeverity(status.getSeverity());
        this.setPlugin(status.getPlugin());
        this.setCode(status.getCode());
        this.setMessage(status.getMessage());
        this.setException(status.getException());
    }

    public SerializableStatus(int severity, String pluginId, int code, String message, Throwable exception) {
        this.setSeverity(severity);
        this.setPlugin(pluginId);
        this.setCode(code);
        this.setMessage(message);
        this.setException(exception);
    }

    public SerializableStatus(int severity, String pluginId, String message, Throwable exception) {
        this.setSeverity(severity);
        this.setPlugin(pluginId);
        this.setMessage(message);
        this.setException(exception);
        this.setCode(0);
    }

    public SerializableStatus(int severity, String pluginId, String message) {
        this.setSeverity(severity);
        this.setPlugin(pluginId);
        this.setMessage(message);
        this.setCode(0);
        this.setException(null);
    }

    public IStatus[] getChildren() {
        return theEmptyStatusArray;
    }

    public int getCode() {
        return this.code;
    }

    public Throwable getException() {
        return this.exception;
    }

    public String getMessage() {
        return this.message;
    }

    public String getPlugin() {
        return this.pluginId;
    }

    public int getSeverity() {
        return this.severity;
    }

    public boolean isMultiStatus() {
        return false;
    }

    public boolean isOK() {
        return this.severity == 0;
    }

    public boolean matches(int severityMask) {
        return (this.severity & severityMask) != 0;
    }

    protected void setCode(int code) {
        this.code = code;
    }

    protected void setException(Throwable exception) {
        if (exception != null) {
            this.exception = this.checkForSerializable(exception);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Throwable checkForSerializable(Throwable exception2) {
        oos = null;
        try {
            try {
                oos = new ObjectOutputStream(new ByteArrayOutputStream());
                oos.writeObject(exception2);
            }
            catch (IOException e) {
                ECFPlugin.getDefault().log((IStatus)new Status(2, "org.eclipse.ecf", 2, "Exception " + exception2 + " could not be serialized for SerializableStatus", (Throwable)e));
                var6_4 = this.createNewExceptionFor(exception2);
                var4_5 = null;
                try {
                    if (oos == null) return var6_4;
                    oos.close();
                    return var6_4;
                }
                catch (IOException var7_8) {
                    // empty catch block
                }
                return var6_4;
            }
        }
        catch (Throwable var5_11) {
            var4_6 = null;
            ** try [egrp 2[TRYBLOCK] [3 : 88->99)] { 
lbl23:
            // 1 sources

            if (oos == null) throw var5_11;
            oos.close();
            throw var5_11;
lbl26:
            // 1 sources

            catch (IOException var7_9) {
                // empty catch block
            }
            throw var5_11;
        }
        {
            var4_7 = null;
        }
        try {}
        catch (IOException var7_10) {
            return exception2;
        }
        if (oos == null) return exception2;
        oos.close();
        return exception2;
    }

    private Throwable createNewExceptionFor(Throwable exception2) {
        Exception re = new Exception(exception2.getMessage());
        return re;
    }

    protected void setMessage(String message) {
        this.message = message == null ? "" : message;
    }

    protected void setPlugin(String pluginId) {
        Assert.isLegal((pluginId != null && pluginId.length() > 0 ? 1 : 0) != 0);
        this.pluginId = pluginId;
    }

    protected void setSeverity(int severity) {
        Assert.isLegal((severity == 0 || severity == 4 || severity == 2 || severity == 1 || severity == 8 ? 1 : 0) != 0);
        this.severity = severity;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("SerializableStatus ");
        if (this.severity == 0) {
            buf.append("OK");
        } else if (this.severity == 4) {
            buf.append("ERROR");
        } else if (this.severity == 2) {
            buf.append("WARNING");
        } else if (this.severity == 1) {
            buf.append("INFO");
        } else if (this.severity == 8) {
            buf.append("CANCEL");
        } else {
            buf.append("severity=");
            buf.append(this.severity);
        }
        buf.append(": ");
        buf.append(this.pluginId);
        buf.append(" code=");
        buf.append(this.code);
        buf.append(' ');
        buf.append(this.message);
        buf.append(' ');
        buf.append(this.exception);
        return buf.toString();
    }
}

