/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.cocoa.NSData;

public abstract class ByteArrayTransfer
extends Transfer {
    public TransferData[] getSupportedTypes() {
        int[] nArray = this.getTypeIds();
        TransferData[] transferDataArray = new TransferData[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            transferDataArray[n] = new TransferData();
            transferDataArray[n].type = nArray[n];
            ++n;
        }
        return transferDataArray;
    }

    public boolean isSupportedType(TransferData transferData) {
        if (transferData == null) {
            return false;
        }
        int[] nArray = this.getTypeIds();
        int n = 0;
        while (n < nArray.length) {
            if (transferData.type == nArray[n]) {
                return true;
            }
            ++n;
        }
        return false;
    }

    protected void javaToNative(Object object, TransferData transferData) {
        if (!this.checkByteArray(object) && !this.isSupportedType(transferData)) {
            DND.error(2003);
        }
        byte[] byArray = (byte[])object;
        NSData nSData = NSData.dataWithBytes(byArray, byArray.length);
        transferData.data = nSData;
    }

    protected Object nativeToJava(TransferData transferData) {
        if (!this.isSupportedType(transferData) || transferData.data == null) {
            return null;
        }
        if (transferData.data == null) {
            return null;
        }
        NSData nSData = (NSData)transferData.data;
        if (nSData.length() == 0L) {
            return null;
        }
        byte[] byArray = new byte[(int)nSData.length()];
        nSData.getBytes(byArray);
        return byArray;
    }

    boolean checkByteArray(Object object) {
        return object != null && object instanceof byte[] && ((byte[])object).length > 0;
    }
}

