/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdkuilib.internal.repository.ui;

import com.android.sdkuilib.internal.tasks.ILogUiProvider;
import com.android.sdkuilib.ui.GridDataBuilder;
import com.android.sdkuilib.ui.GridLayoutBuilder;
import com.android.utils.ILogger;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

class LogWindow
implements ILogUiProvider {
    private Shell mParentShell;
    private Shell mShell;
    private Composite mRootComposite;
    private StyledText mStyledText;
    private Label mLogDescription;
    private Button mCloseButton;
    private final ILogger mSecondaryLog;
    private boolean mCloseRequested;
    private boolean mInitPosition = true;
    private String mLastLogMsg = null;

    public LogWindow(Shell parentShell, ILogger secondaryLog) {
        this.mParentShell = parentShell;
        this.mSecondaryLog = secondaryLog;
    }

    void openBlocking() {
        this.open();
        Display display = Display.getDefault();
        while (!this.mShell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        this.close();
    }

    public void open() {
        this.createShell();
        this.createContents();
        this.mShell.open();
        this.mShell.layout();
        this.mShell.setVisible(false);
    }

    public void close() {
        if (this.mShell != null && !this.mShell.isDisposed()) {
            this.mCloseRequested = true;
            this.mShell.close();
            this.mShell = null;
        }
    }

    public boolean isVisible() {
        return this.mShell != null && !this.mShell.isDisposed() && this.mShell.isVisible();
    }

    public void setVisible(boolean visible) {
        if (this.mShell != null && !this.mShell.isDisposed()) {
            this.mShell.setVisible(visible);
            if (visible && this.mInitPosition) {
                this.mInitPosition = false;
                this.positionWindow();
            }
        }
    }

    private void createShell() {
        this.mShell = new Shell(this.mParentShell, 1268);
        this.mShell.setMinimumSize(new Point(600, 300));
        this.mShell.setSize(450, 300);
        this.mShell.setText("Android SDK Manager Log");
        GridLayoutBuilder.create((Composite)this.mShell);
        this.mShell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                if (!LogWindow.this.mCloseRequested) {
                    e.doit = false;
                    LogWindow.this.setVisible(false);
                }
            }
        });
    }

    private void createContents() {
        this.mRootComposite = new Composite((Composite)this.mShell, 0);
        GridLayoutBuilder.create(this.mRootComposite).columns(2);
        GridDataBuilder.create((Control)this.mRootComposite).fill().grab();
        this.mStyledText = new StyledText(this.mRootComposite, 2634);
        GridDataBuilder.create((Control)this.mStyledText).hSpan(2).fill().grab();
        this.mLogDescription = new Label(this.mRootComposite, 0);
        GridDataBuilder.create((Control)this.mLogDescription).hFill().hGrab();
        this.mCloseButton = new Button(this.mRootComposite, 0);
        this.mCloseButton.setText("Close");
        this.mCloseButton.setToolTipText("Closes the log window");
        this.mCloseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LogWindow.this.setVisible(false);
            }
        });
    }

    @Override
    public void setDescription(final String description) {
        this.syncExec((Widget)this.mLogDescription, new Runnable(){

            @Override
            public void run() {
                LogWindow.this.mLogDescription.setText(description);
                if (LogWindow.this.acceptLog(description, true)) {
                    LogWindow.this.appendLine(TextStyle.TITLE, description);
                    if (LogWindow.this.mSecondaryLog != null) {
                        LogWindow.this.mSecondaryLog.info("%1$s", new Object[]{description});
                    }
                }
            }
        });
    }

    @Override
    public void log(final String log) {
        if (this.acceptLog(log, false)) {
            this.syncExec((Widget)this.mLogDescription, new Runnable(){

                @Override
                public void run() {
                    LogWindow.this.appendLine(TextStyle.DEFAULT, log);
                }
            });
            if (this.mSecondaryLog != null) {
                this.mSecondaryLog.info("  %1$s", new Object[]{log});
            }
        }
    }

    @Override
    public void logError(final String log) {
        if (this.acceptLog(log, false)) {
            this.syncExec((Widget)this.mLogDescription, new Runnable(){

                @Override
                public void run() {
                    LogWindow.this.appendLine(TextStyle.ERROR, log);
                }
            });
            if (this.mSecondaryLog != null) {
                this.mSecondaryLog.error(null, "%1$s", new Object[]{log});
            }
        }
    }

    @Override
    public void logVerbose(final String log) {
        if (this.acceptLog(log, false)) {
            this.syncExec((Widget)this.mLogDescription, new Runnable(){

                @Override
                public void run() {
                    LogWindow.this.appendLine(TextStyle.DEFAULT, "  " + log);
                }
            });
            if (this.mSecondaryLog != null) {
                this.mSecondaryLog.info("    %1$s", new Object[]{log});
            }
        }
    }

    private void positionWindow() {
        Shell child = this.mShell;
        if (child != null && this.mParentShell != null) {
            int y;
            Rectangle parentArea = this.mParentShell.getClientArea();
            Point parentLoc = this.mParentShell.getLocation();
            int px = parentLoc.x;
            int py = parentLoc.y;
            int pw = parentArea.width;
            int ph = parentArea.height;
            Point childSize = child.getSize();
            int cw = Math.max(childSize.x, pw);
            int ch = childSize.y;
            int x = 30 + px + (pw - cw) / 2;
            if (x < 0) {
                x = 0;
            }
            if ((y = py + (ph - ch) / 2) < py) {
                y = py;
            }
            child.setLocation(x, y);
            child.setSize(cw, ch);
        }
    }

    private void appendLine(TextStyle style, String text) {
        if (!text.endsWith("\n")) {
            text = text + '\n';
        }
        int start = this.mStyledText.getCharCount();
        if (style == TextStyle.DEFAULT) {
            this.mStyledText.append(text);
        } else {
            this.mStyledText.append(text);
            StyleRange sr = new StyleRange();
            sr.start = start;
            sr.length = text.length();
            sr.fontStyle = 1;
            if (style == TextStyle.ERROR) {
                sr.foreground = this.mStyledText.getDisplay().getSystemColor(4);
            }
            sr.underline = false;
            this.mStyledText.setStyleRange(sr);
        }
        if (this.mStyledText.getCaretOffset() >= start) {
            this.mStyledText.setSelection(this.mStyledText.getCharCount());
        }
    }

    private void syncExec(Widget widget, Runnable runnable) {
        if (widget != null && !widget.isDisposed()) {
            widget.getDisplay().syncExec(runnable);
        }
    }

    private boolean acceptLog(String msg, boolean isDescription) {
        if (msg == null) {
            return false;
        }
        msg = msg.trim();
        if (isDescription && msg.indexOf(37) != -1) {
            return false;
        }
        if (msg.equals(this.mLastLogMsg)) {
            return false;
        }
        this.mLastLogMsg = msg;
        return true;
    }

    private static enum TextStyle {
        DEFAULT,
        TITLE,
        ERROR;

    }
}

