/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.gltrace.format;

import com.android.ide.eclipse.gltrace.GLEnum;
import com.android.ide.eclipse.gltrace.GLProtoBuf;
import com.android.ide.eclipse.gltrace.format.GLAPISpec;
import com.android.ide.eclipse.gltrace.format.GLDataTypeSpec;
import java.util.List;
import java.util.Map;

public class GLMessageFormatter {
    private static final String GL_NO_ERROR = "GL_NO_ERROR";
    private Map<String, GLAPISpec> mAPISpecs;

    public GLMessageFormatter(Map<String, GLAPISpec> map) {
        this.mAPISpecs = map;
    }

    public String formatGLMessage(GLProtoBuf.GLMessage gLMessage) {
        GLAPISpec gLAPISpec = this.mAPISpecs.get(gLMessage.getFunction().toString());
        if (gLAPISpec == null) {
            return gLMessage.getFunction().toString();
        }
        return String.valueOf(this.formatCall(gLAPISpec, gLMessage)) + this.formatReturnValue(gLAPISpec, gLMessage);
    }

    private String formatReturnValue(GLAPISpec gLAPISpec, GLProtoBuf.GLMessage gLMessage) {
        if (gLAPISpec.getReturnValue().getDataType() == GLProtoBuf.GLMessage.DataType.Type.VOID) {
            return "";
        }
        GLDataTypeSpec gLDataTypeSpec = gLAPISpec.getReturnValue();
        return String.format(" = (%s) %s", gLDataTypeSpec.getCType(), this.formatDataValue(gLMessage.getReturnValue(), gLDataTypeSpec, DataTypeContext.CONTEXT_RETURNVALUE));
    }

    private String formatCall(GLAPISpec gLAPISpec, GLProtoBuf.GLMessage gLMessage) {
        return String.format("%s(%s)", gLAPISpec.getFunction(), this.formatArgs(gLMessage, gLAPISpec.getArgs()));
    }

    private String formatArgs(GLProtoBuf.GLMessage gLMessage, List<GLDataTypeSpec> list) {
        int n = 10 + list.size() * 5;
        StringBuilder stringBuilder = new StringBuilder(n);
        int n2 = 0;
        while (n2 < list.size()) {
            GLDataTypeSpec gLDataTypeSpec = list.get(n2);
            if (gLDataTypeSpec.getDataType() == GLProtoBuf.GLMessage.DataType.Type.VOID && !gLDataTypeSpec.isPointer()) {
                stringBuilder.append("void");
            } else {
                stringBuilder.append(gLDataTypeSpec.getArgName());
                stringBuilder.append(" = ");
                stringBuilder.append(this.formatDataValue(gLMessage.getArgs(n2), gLDataTypeSpec, DataTypeContext.CONTEXT_ARGUMENT));
            }
            if (n2 < list.size() - 1) {
                stringBuilder.append(", ");
            }
            ++n2;
        }
        return stringBuilder.toString();
    }

    private String formatDataValue(GLProtoBuf.GLMessage.DataType dataType, GLDataTypeSpec gLDataTypeSpec, DataTypeContext dataTypeContext) {
        if (gLDataTypeSpec.isPointer()) {
            return this.formatPointer(dataType, gLDataTypeSpec.getDataType());
        }
        switch (gLDataTypeSpec.getDataType()) {
            case VOID: {
                return "";
            }
            case BOOL: {
                return Boolean.toString(dataType.getBoolValue(0));
            }
            case FLOAT: {
                return String.format("%f", Float.valueOf(dataType.getFloatValue(0)));
            }
            case INT: {
                return Integer.toString(dataType.getIntValue(0));
            }
            case ENUM: {
                if (dataType.getIntValue(0) == 0 && dataTypeContext == DataTypeContext.CONTEXT_RETURNVALUE) {
                    return GL_NO_ERROR;
                }
                return GLEnum.valueOf(dataType.getIntValue(0)).toString();
            }
        }
        return "(unknown type)";
    }

    private String formatPointer(GLProtoBuf.GLMessage.DataType dataType, GLProtoBuf.GLMessage.DataType.Type type) {
        if (dataType.getType() != type && !this.isEnumTypeWithIntData(dataType, type)) {
            if (dataType.getIntValueCount() > 0) {
                return String.format("0x%x", dataType.getIntValue(0));
            }
            return "0x??";
        }
        switch (type) {
            case BOOL: {
                return dataType.getBoolValueList().toString();
            }
            case FLOAT: {
                return dataType.getFloatValueList().toString();
            }
            case INT: {
                return dataType.getIntValueList().toString();
            }
            case CHAR: {
                return dataType.getCharValueList().get(0).toStringUtf8();
            }
            case ENUM: {
                List<Integer> list = dataType.getIntValueList();
                StringBuilder stringBuilder = new StringBuilder(list.size() * 5);
                stringBuilder.append('[');
                for (Integer n : list) {
                    stringBuilder.append((Object)GLEnum.valueOf(n.intValue()));
                }
                stringBuilder.append(']');
                return stringBuilder.toString();
            }
            case VOID: {
                if (dataType.getRawBytesList().size() > 0) {
                    return String.format("[ %d bytes ]", dataType.getRawBytesList().get(0).size());
                }
                return "[]";
            }
        }
        if (dataType.getIntValue(0) == 0) {
            return "NULL";
        }
        return String.format("0x%x", dataType.getIntValue(0));
    }

    private boolean isEnumTypeWithIntData(GLProtoBuf.GLMessage.DataType dataType, GLProtoBuf.GLMessage.DataType.Type type) {
        return dataType.getType() == GLProtoBuf.GLMessage.DataType.Type.INT && type == GLProtoBuf.GLMessage.DataType.Type.ENUM;
    }

    private static enum DataTypeContext {
        CONTEXT_ARGUMENT,
        CONTEXT_RETURNVALUE;

    }
}

