/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.gltrace.views.detail;

import com.android.ide.eclipse.gltrace.editors.GLCallGroups;
import com.android.ide.eclipse.gltrace.editors.GLFunctionTraceViewer;
import com.android.ide.eclipse.gltrace.model.GLCall;
import com.android.ide.eclipse.gltrace.model.GLTrace;
import com.android.ide.eclipse.gltrace.state.IGLProperty;
import com.android.ide.eclipse.gltrace.views.StateView;
import com.android.ide.eclipse.gltrace.views.detail.GlDrawCallDetailProvider;
import com.android.ide.eclipse.gltrace.views.detail.ICallDetailProvider;
import com.android.ide.eclipse.gltrace.views.detail.IDetailProvider;
import com.android.ide.eclipse.gltrace.views.detail.IStateDetailProvider;
import com.android.ide.eclipse.gltrace.views.detail.ShaderSourceDetailsProvider;
import com.android.ide.eclipse.gltrace.views.detail.ShaderUniformDetailsProvider;
import com.android.ide.eclipse.gltrace.views.detail.TextureImageDetailsProvider;
import com.android.ide.eclipse.gltrace.views.detail.VboDetailProvider;
import com.android.ide.eclipse.gltrace.views.detail.VertexAttribPointerDataDetailProvider;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.Page;

public class DetailsPage
extends Page
implements ISelectionListener {
    private GLTrace mTrace;
    private IToolBarManager mToolBarManager;
    private Composite mTopComposite;
    private StackLayout mStackLayout;
    private Composite mBlankComposite;
    private List<IDetailProvider> mDetailProviders = Arrays.asList(new ShaderSourceDetailsProvider(), new ShaderUniformDetailsProvider(), new TextureImageDetailsProvider(), new VboDetailProvider(), new GlDrawCallDetailProvider(), new VertexAttribPointerDataDetailProvider());

    public DetailsPage(GLTrace gLTrace) {
        this.mTrace = gLTrace;
    }

    public void setInput(GLTrace gLTrace) {
        this.mTrace = gLTrace;
    }

    public void createControl(Composite composite) {
        this.mTopComposite = new Composite(composite, 0);
        this.mStackLayout = new StackLayout();
        this.mTopComposite.setLayout((Layout)this.mStackLayout);
        this.mTopComposite.setLayoutData((Object)new GridData(1808));
        this.mBlankComposite = new Composite(this.mTopComposite, 0);
        this.mToolBarManager = this.getSite().getActionBars().getToolBarManager();
        for (IDetailProvider iDetailProvider : this.mDetailProviders) {
            iDetailProvider.createControl(this.mTopComposite);
            for (IContributionItem iContributionItem : iDetailProvider.getToolBarItems()) {
                this.mToolBarManager.add(iContributionItem);
            }
        }
        this.setDetailsProvider(null);
    }

    private void setDetailsProvider(IDetailProvider iDetailProvider) {
        IContributionItem[] iContributionItemArray = this.mToolBarManager.getItems();
        int n = iContributionItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            IContributionItem iContributionItem = iContributionItemArray[n2];
            iContributionItem.setVisible(false);
            ++n2;
        }
        if (iDetailProvider == null) {
            this.setTopControl((Control)this.mBlankComposite);
        } else {
            this.setTopControl(iDetailProvider.getControl());
            for (IContributionItem iContributionItem : iDetailProvider.getToolBarItems()) {
                iContributionItem.setVisible(true);
            }
        }
        this.mToolBarManager.update(true);
    }

    private void setTopControl(Control control) {
        this.mStackLayout.topControl = control;
        this.mTopComposite.layout();
    }

    public Control getControl() {
        return this.mTopComposite;
    }

    public void init(IPageSite iPageSite) {
        super.init(iPageSite);
        iPageSite.getPage().addSelectionListener((ISelectionListener)this);
    }

    public void dispose() {
        this.getSite().getPage().removeSelectionListener((ISelectionListener)this);
        for (IDetailProvider iDetailProvider : this.mDetailProviders) {
            iDetailProvider.disposeControl();
        }
        super.dispose();
    }

    public void setFocus() {
    }

    public void selectionChanged(IWorkbenchPart iWorkbenchPart, ISelection iSelection) {
        if (iWorkbenchPart instanceof GLFunctionTraceViewer) {
            GLCall gLCall = this.getSelectedCall((GLFunctionTraceViewer)iWorkbenchPart, iSelection);
            if (gLCall == null) {
                return;
            }
            this.callSelected(gLCall);
            return;
        }
        if (iWorkbenchPart instanceof StateView) {
            IGLProperty iGLProperty = this.getSelectedProperty((StateView)iWorkbenchPart, iSelection);
            if (iGLProperty == null) {
                return;
            }
            this.stateVariableSelected(iGLProperty);
            return;
        }
    }

    private void stateVariableSelected(IGLProperty iGLProperty) {
        for (IDetailProvider iDetailProvider : this.mDetailProviders) {
            IStateDetailProvider iStateDetailProvider;
            if (!(iDetailProvider instanceof IStateDetailProvider) || !(iStateDetailProvider = (IStateDetailProvider)iDetailProvider).isApplicable(iGLProperty)) continue;
            iStateDetailProvider.updateControl(iGLProperty);
            this.setDetailsProvider(iStateDetailProvider);
            return;
        }
        this.setDetailsProvider(null);
    }

    private void callSelected(GLCall gLCall) {
        for (IDetailProvider iDetailProvider : this.mDetailProviders) {
            ICallDetailProvider iCallDetailProvider;
            if (!(iDetailProvider instanceof ICallDetailProvider) || !(iCallDetailProvider = (ICallDetailProvider)iDetailProvider).isApplicable(gLCall)) continue;
            iCallDetailProvider.updateControl(this.mTrace, gLCall);
            this.setDetailsProvider(iCallDetailProvider);
            return;
        }
        this.setDetailsProvider(null);
    }

    private GLCall getSelectedCall(GLFunctionTraceViewer gLFunctionTraceViewer, ISelection iSelection) {
        if (gLFunctionTraceViewer.getTrace() != this.mTrace) {
            return null;
        }
        if (!(iSelection instanceof TreeSelection)) {
            return null;
        }
        Object object = ((TreeSelection)iSelection).getFirstElement();
        if (object instanceof GLCallGroups.GLCallNode) {
            return ((GLCallGroups.GLCallNode)object).getCall();
        }
        return null;
    }

    private IGLProperty getSelectedProperty(StateView stateView, ISelection iSelection) {
        Object e;
        if (!(iSelection instanceof IStructuredSelection)) {
            return null;
        }
        IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
        List list = iStructuredSelection.toList();
        if (list.size() > 0 && (e = list.get(0)) instanceof IGLProperty) {
            return (IGLProperty)e;
        }
        return null;
    }
}

