/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.emma.data;

import com.vladium.emma.data.ClassDescriptor;
import com.vladium.emma.data.DataFactory;
import com.vladium.emma.data.ICoverageData;
import com.vladium.emma.data.IMergeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

final class CoverageData
implements ICoverageData,
Cloneable {
    private HashMap m_coverageMap;

    public Object lock() {
        return this.m_coverageMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ICoverageData shallowCopy() {
        HashMap hashMap;
        CoverageData coverageData;
        try {
            coverageData = (CoverageData)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new Error(cloneNotSupportedException.toString());
        }
        Object object = this.lock();
        synchronized (object) {
            hashMap = (HashMap)this.m_coverageMap.clone();
        }
        coverageData.m_coverageMap = hashMap;
        return coverageData;
    }

    public int size() {
        return this.m_coverageMap.size();
    }

    public ICoverageData.DataHolder getCoverage(ClassDescriptor classDescriptor) {
        if (classDescriptor == null) {
            throw new IllegalArgumentException("null input: cls");
        }
        return (ICoverageData.DataHolder)this.m_coverageMap.get(classDescriptor.getClassVMName());
    }

    public void addClass(boolean[][] blArray, String string, long l) {
        this.m_coverageMap.put(string, new ICoverageData.DataHolder(blArray, l));
    }

    public boolean isEmpty() {
        return this.m_coverageMap.isEmpty();
    }

    public IMergeable merge(IMergeable iMergeable) {
        if (iMergeable == null || iMergeable.isEmpty() || iMergeable == this) {
            return this;
        }
        CoverageData coverageData = (CoverageData)iMergeable;
        HashMap hashMap = coverageData.m_coverageMap;
        for (Map.Entry entry : hashMap.entrySet()) {
            String string = (String)entry.getKey();
            ICoverageData.DataHolder dataHolder = (ICoverageData.DataHolder)entry.getValue();
            ICoverageData.DataHolder dataHolder2 = (ICoverageData.DataHolder)this.m_coverageMap.get(string);
            if (dataHolder2 == null) {
                this.m_coverageMap.put(string, dataHolder);
                continue;
            }
            if (dataHolder.m_stamp != dataHolder2.m_stamp) {
                this.m_coverageMap.put(string, dataHolder);
                continue;
            }
            boolean[][] blArray = dataHolder.m_coverage;
            boolean[][] blArray2 = dataHolder2.m_coverage;
            int n = blArray2.length;
            for (int i = 0; i < n; ++i) {
                boolean[] blArray3 = blArray[i];
                boolean[] blArray4 = blArray2[i];
                if (blArray4 == null) continue;
                int n2 = blArray4.length;
                for (int j = 0; j < n2; ++j) {
                    if (!blArray3[j]) continue;
                    blArray4[j] = true;
                }
            }
        }
        return this;
    }

    CoverageData() {
        this.m_coverageMap = new HashMap();
    }

    static CoverageData readExternal(DataInput dataInput) throws IOException {
        int n = dataInput.readInt();
        HashMap<String, ICoverageData.DataHolder> hashMap = new HashMap<String, ICoverageData.DataHolder>(n);
        for (int i = 0; i < n; ++i) {
            String string = dataInput.readUTF();
            long l = dataInput.readLong();
            int n2 = dataInput.readInt();
            boolean[][] blArrayArray = new boolean[n2][];
            for (int j = 0; j < n2; ++j) {
                blArrayArray[j] = DataFactory.readBooleanArray(dataInput);
            }
            hashMap.put(string, new ICoverageData.DataHolder(blArrayArray, l));
        }
        return new CoverageData(hashMap);
    }

    static void writeExternal(CoverageData coverageData, DataOutput dataOutput) throws IOException {
        HashMap hashMap = coverageData.m_coverageMap;
        int n = hashMap.size();
        dataOutput.writeInt(n);
        Iterator iterator = hashMap.entrySet().iterator();
        for (int i = 0; i < n; ++i) {
            Map.Entry entry = iterator.next();
            String string = (String)entry.getKey();
            ICoverageData.DataHolder dataHolder = (ICoverageData.DataHolder)entry.getValue();
            boolean[][] blArray = dataHolder.m_coverage;
            dataOutput.writeUTF(string);
            dataOutput.writeLong(dataHolder.m_stamp);
            int n2 = blArray.length;
            dataOutput.writeInt(n2);
            for (int j = 0; j < n2; ++j) {
                DataFactory.writeBooleanArray(blArray[j], dataOutput);
            }
        }
    }

    private CoverageData(HashMap hashMap) {
        this.m_coverageMap = hashMap;
    }
}

