/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast.libs.org.parboiled.transform;

import lombok.ast.libs.org.parboiled.asm.Opcodes;
import lombok.ast.libs.org.parboiled.asm.tree.AbstractInsnNode;
import lombok.ast.libs.org.parboiled.asm.tree.AnnotationNode;
import lombok.ast.libs.org.parboiled.asm.tree.InsnList;
import lombok.ast.libs.org.parboiled.asm.tree.InsnNode;
import lombok.ast.libs.org.parboiled.asm.tree.JumpInsnNode;
import lombok.ast.libs.org.parboiled.asm.tree.LabelNode;
import lombok.ast.libs.org.parboiled.asm.tree.LdcInsnNode;
import lombok.ast.libs.org.parboiled.asm.tree.MethodInsnNode;
import lombok.ast.libs.org.parboiled.common.StringUtils;
import lombok.ast.libs.org.parboiled.google.base.Preconditions;
import lombok.ast.libs.org.parboiled.transform.ParserClassNode;
import lombok.ast.libs.org.parboiled.transform.RuleMethod;
import lombok.ast.libs.org.parboiled.transform.RuleMethodProcessor;
import lombok.ast.libs.org.parboiled.transform.Types;
import org.jetbrains.annotations.NotNull;

class LabellingGenerator
implements Opcodes,
RuleMethodProcessor,
Types {
    LabellingGenerator() {
    }

    public boolean appliesTo(@NotNull ParserClassNode classNode, @NotNull RuleMethod method) {
        if (classNode == null) {
            throw new IllegalArgumentException("1st argument of method org.parboiled.transform.LabellingGenerator.appliesTo(...) corresponds to @NotNull parameter and must not be null");
        }
        if (method == null) {
            throw new IllegalArgumentException("2nd argument of method org.parboiled.transform.LabellingGenerator.appliesTo(...) corresponds to @NotNull parameter and must not be null");
        }
        return !method.hasDontLabelAnnotation();
    }

    public void process(@NotNull ParserClassNode classNode, @NotNull RuleMethod method) throws Exception {
        if (classNode == null) {
            throw new IllegalArgumentException("1st argument of method org.parboiled.transform.LabellingGenerator.process(...) corresponds to @NotNull parameter and must not be null");
        }
        if (method == null) {
            throw new IllegalArgumentException("2nd argument of method org.parboiled.transform.LabellingGenerator.process(...) corresponds to @NotNull parameter and must not be null");
        }
        Preconditions.checkState(!method.isSuperMethod());
        InsnList instructions = method.instructions;
        AbstractInsnNode ret = instructions.getLast();
        while (ret.getOpcode() != 176) {
            ret = ret.getPrevious();
        }
        LabelNode isNullLabel = new LabelNode();
        instructions.insertBefore(ret, new InsnNode(89));
        instructions.insertBefore(ret, new JumpInsnNode(198, isNullLabel));
        instructions.insertBefore(ret, new LdcInsnNode(this.getLabelText(method)));
        instructions.insertBefore(ret, new MethodInsnNode(185, RULE.getInternalName(), "label", "(Ljava/lang/String;)" + RULE_DESC));
        instructions.insertBefore(ret, isNullLabel);
    }

    public String getLabelText(RuleMethod method) {
        if (method.visibleAnnotations != null) {
            for (Object annotationObj : method.visibleAnnotations) {
                AnnotationNode annotation = (AnnotationNode)annotationObj;
                if (!annotation.desc.equals(LABEL_DESC) || annotation.values == null) continue;
                Preconditions.checkState("value".equals(annotation.values.get(0)));
                String labelValue = (String)annotation.values.get(1);
                return StringUtils.isEmpty(labelValue) ? method.name : labelValue;
            }
        }
        return method.name;
    }
}

