/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.gltrace;

import com.android.ide.eclipse.gltrace.GLProtoBuf;
import com.android.ide.eclipse.gltrace.GlTracePlugin;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.widgets.Display;
import org.liblzf.CLZF;

public class ProtoBufUtils {
    private static ImageData getImageData(GLProtoBuf.GLMessage glMsg) {
        int height;
        int width = glMsg.getFb().getWidth();
        if (width * (height = glMsg.getFb().getHeight()) == 0) {
            return null;
        }
        byte[] compressed = glMsg.getFb().getContents(0).toByteArray();
        byte[] uncompressed = new byte[width * height * 4];
        int size = CLZF.lzf_decompress((byte[])compressed, (int)compressed.length, (byte[])uncompressed, (int)uncompressed.length);
        assert (size == width * height * 4) : "Unexpected image size after decompression.";
        int redMask = -16777216;
        int greenMask = 0xFF0000;
        int blueMask = 65280;
        PaletteData palette = new PaletteData(redMask, greenMask, blueMask);
        ImageData imageData = new ImageData(width, height, 32, palette, 1, uncompressed);
        byte[] alpha = new byte[width * height];
        int i = 0;
        while (i < width * height) {
            alpha[i] = uncompressed[i * 4 + 3];
            ++i;
        }
        imageData.alphaData = alpha;
        imageData = imageData.scaledTo(imageData.width, -imageData.height);
        return imageData;
    }

    public static Image getImage(Display display, GLProtoBuf.GLMessage glMsg) {
        if (!glMsg.hasFb()) {
            return null;
        }
        ImageData imageData = null;
        try {
            imageData = ProtoBufUtils.getImageData(glMsg);
        }
        catch (Exception e) {
            GlTracePlugin.getDefault().logMessage("Unexpected error while retrieving framebuffer image: " + e);
            return null;
        }
        if (imageData == null) {
            return null;
        }
        return new Image((Device)display, imageData);
    }
}

