/*
 * Decompiled with CFR 0.152.
 */
package com.android.ant;

import com.android.annotations.Nullable;
import com.android.ant.TaskHelper;
import com.android.io.FolderWrapper;
import com.android.sdklib.build.JarListSanitizer;
import com.android.sdklib.internal.project.IPropertySource;
import com.android.sdklib.internal.project.ProjectProperties;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.tools.ant.BuildException;

public class DependencyHelper {
    private final boolean mVerbose;
    private final File mProjectFolder;
    private final IPropertySource mProperties;
    private final List<File> mLibraries = new ArrayList<File>();

    public static List<File> sanitizePaths(File projectFolder, IPropertySource properties, List<File> paths) {
        ArrayList<File> results = new ArrayList<File>();
        int i = 0;
        while (i < paths.size()) {
            File f = paths.get(i);
            if (f.isFile() && !f.getName().equals("classes.jar")) {
                ++i;
                continue;
            }
            results.add(f);
            paths.remove(i);
        }
        File outputFile = new File(projectFolder, DependencyHelper.getOutDir(properties));
        JarListSanitizer sanitizer = new JarListSanitizer(outputFile);
        try {
            results.addAll(sanitizer.sanitize(paths));
        }
        catch (JarListSanitizer.DifferentLibException e) {
            String[] details;
            for (String s : details = e.getDetails()) {
                System.err.println(s);
            }
            throw new BuildException(e.getMessage(), (Throwable)e);
        }
        catch (JarListSanitizer.Sha1Exception e) {
            throw new BuildException("Failed to compute sha1 for " + e.getJarFile().getAbsolutePath(), (Throwable)e);
        }
        return results;
    }

    public DependencyHelper(File projectFolder, boolean verbose) {
        this.mProjectFolder = projectFolder;
        this.mVerbose = verbose;
        this.mProperties = TaskHelper.getProperties(projectFolder.getAbsolutePath());
        this.init(projectFolder);
    }

    public DependencyHelper(File projectFolder, IPropertySource properties, boolean verbose) {
        this.mProjectFolder = projectFolder;
        this.mProperties = properties;
        this.mVerbose = verbose;
        this.init(projectFolder);
    }

    private void init(File projectFolder) {
        List<File> topLevelLibraries = this.getDirectDependencies(projectFolder, this.mProperties);
        this.resolveFullLibraryDependencies(topLevelLibraries, this.mLibraries);
    }

    public List<File> getLibraries() {
        return this.mLibraries;
    }

    public int getLibraryCount() {
        return this.mLibraries.size();
    }

    public String getProperty(String name) {
        return this.mProperties.getProperty(name);
    }

    public void processLibraries(@Nullable LibraryProcessor processor) {
        for (File library : this.mLibraries) {
            String libRootPath = library.getAbsolutePath();
            if (this.mVerbose) {
                System.out.println(libRootPath);
            }
            if (processor == null) continue;
            processor.processLibrary(libRootPath);
        }
    }

    public List<File> sanitizePaths(List<File> paths) {
        return DependencyHelper.sanitizePaths(this.mProjectFolder, this.mProperties, paths);
    }

    public String getOutDir() {
        return DependencyHelper.getOutDir(this.mProperties);
    }

    private List<File> getDirectDependencies(File baseFolder, IPropertySource properties) {
        String propName;
        String rootPath;
        ArrayList<File> libraries = new ArrayList<File>();
        int index = 1;
        while ((rootPath = properties.getProperty(propName = "android.library.reference." + Integer.toString(index++))) != null) {
            try {
                File library = new File(baseFolder, rootPath).getCanonicalFile();
                File projectProp = new File(library, ProjectProperties.PropertyType.PROJECT.getFilename());
                if (!projectProp.isFile()) {
                    throw new BuildException(String.format("%1$s resolve to a path with no %2$s file for project %3$s", rootPath, ProjectProperties.PropertyType.PROJECT.getFilename(), baseFolder.getAbsolutePath()));
                }
                if (libraries.contains(library)) continue;
                if (this.mVerbose) {
                    System.out.println(String.format("%1$s: %2$s => %3$s", baseFolder.getAbsolutePath(), rootPath, library.getAbsolutePath()));
                }
                libraries.add(library);
            }
            catch (IOException e) {
                throw new BuildException("Failed to resolve library path: " + rootPath, (Throwable)e);
            }
        }
        return libraries;
    }

    private void resolveFullLibraryDependencies(List<File> inLibraries, List<File> outLibraries) {
        for (int i = inLibraries.size() - 1; i >= 0; --i) {
            File library = inLibraries.get(i);
            ProjectProperties projectProp = ProjectProperties.load(new FolderWrapper(library), ProjectProperties.PropertyType.PROJECT);
            List<File> dependencies = this.getDirectDependencies(library, projectProp);
            this.resolveFullLibraryDependencies(dependencies, outLibraries);
            if (outLibraries.contains(library)) continue;
            outLibraries.add(0, library);
        }
    }

    private static String getOutDir(IPropertySource properties) {
        String bin = properties.getProperty("out.dir");
        if (bin == null) {
            return "bin";
        }
        return bin;
    }

    public static class JarProcessor
    extends AdvancedLibraryProcessor {
        private final List<File> mJars = new ArrayList<File>();
        private final FilenameFilter mFilter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase(Locale.US).endsWith(".jar");
            }
        };

        public List<File> getJars() {
            return this.mJars;
        }

        public FilenameFilter getFilter() {
            return this.mFilter;
        }

        @Override
        public void processLibrary(String libRootPath, IPropertySource properties) {
            this.mJars.add(new File(libRootPath + "/" + "bin" + "/" + "classes.jar"));
            File libsFolder = new File(libRootPath, "libs");
            File[] jarFiles = libsFolder.listFiles(this.mFilter);
            if (jarFiles != null) {
                for (File jarFile : jarFiles) {
                    this.mJars.add(jarFile);
                }
            }
        }
    }

    public static abstract class AdvancedLibraryProcessor
    implements LibraryProcessor {
        public abstract void processLibrary(String var1, IPropertySource var2);

        @Override
        public final void processLibrary(String libRootPath) {
            ProjectProperties properties = TaskHelper.getProperties(libRootPath);
            this.processLibrary(libRootPath, properties);
        }
    }

    protected static interface LibraryProcessor {
        public void processLibrary(String var1);
    }
}

