/*
 * Decompiled with CFR 0.152.
 */
package com.android.ant;

import com.android.ant.TaskHelper;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.ExecTask;
import org.apache.tools.ant.types.Path;

public class LintExecTask
extends ExecTask {
    private String mExecutable;
    private String mHtml;
    private String mXml;
    private Path mSourcePath;
    private Path mClassPath;

    public void setExecutable(Path executable) {
        this.mExecutable = TaskHelper.checkSinglePath("executable", executable);
    }

    public void setSrc(Path path) {
        this.mSourcePath = path;
    }

    public void setClasspath(Path path) {
        this.mClassPath = path;
    }

    public void setHtml(Path html) {
        this.mHtml = TaskHelper.checkSinglePath("html", html);
    }

    public void setXml(Path xml) {
        this.mXml = TaskHelper.checkSinglePath("xml", xml);
    }

    public void execute() throws BuildException {
        ExecTask task = new ExecTask();
        task.setProject(this.getProject());
        task.setOwningTarget(this.getOwningTarget());
        task.setExecutable(this.mExecutable);
        task.setTaskName("lint");
        task.setFailonerror(true);
        task.createArg().setValue("--text");
        task.createArg().setValue("stdout");
        if (this.mHtml != null) {
            task.createArg().setValue("--html");
            task.createArg().setValue(this.mHtml);
        }
        if (this.mXml != null) {
            task.createArg().setValue("--xml");
            task.createArg().setValue(this.mXml);
        }
        if (this.mSourcePath != null) {
            task.createArg().setValue("--sources");
            task.createArg().setValue(this.mSourcePath.toString());
        }
        if (this.mClassPath != null) {
            task.createArg().setValue("--classpath");
            task.createArg().setValue(this.mClassPath.toString());
        }
        task.createArg().setValue(this.getProject().getBaseDir().getAbsolutePath());
        task.execute();
    }
}

