/*
 * Decompiled with CFR 0.152.
 */
package com.android.ant;

import com.android.annotations.NonNull;
import com.android.ant.BuildTypedTask;
import com.android.ant.TaskHelper;
import com.android.sdklib.BuildToolInfo;
import com.android.sdklib.build.ManualRenderScriptChecker;
import com.android.sdklib.build.RenderScriptProcessor;
import com.android.sdklib.repository.FullRevision;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.ExecTask;
import org.apache.tools.ant.types.Environment;
import org.apache.tools.ant.types.Path;

public class RenderScriptTask
extends BuildTypedTask {
    private static final Set<String> EXTENSIONS = Sets.newHashSetWithExpectedSize((int)2);
    private String mBuildToolsRoot;
    private String mGenFolder;
    private String mResFolder;
    private String mRsObjFolder;
    private String mLibsFolder;
    private String mBinFolder;
    private final List<Path> mPaths = new ArrayList<Path>();
    private int mTargetApi = 0;
    private boolean mSupportMode = false;
    private OptLevel mOptLevel;
    private boolean mDebug = false;

    public void setBuildToolsRoot(Path buildToolsRoot) {
        this.mBuildToolsRoot = TaskHelper.checkSinglePath("buildToolsRoot", buildToolsRoot);
    }

    public void setGenFolder(Path value) {
        this.mGenFolder = TaskHelper.checkSinglePath("genFolder", value);
    }

    public void setResFolder(Path value) {
        this.mResFolder = TaskHelper.checkSinglePath("resFolder", value);
    }

    public void setRsObjFolder(Path value) {
        this.mRsObjFolder = TaskHelper.checkSinglePath("rsObjFolder", value);
    }

    public void setLibsFolder(Path value) {
        this.mLibsFolder = TaskHelper.checkSinglePath("libsFolder", value);
    }

    public void setTargetApi(String targetApi) {
        try {
            this.mTargetApi = Integer.parseInt(targetApi);
            if (this.mTargetApi <= 0) {
                throw new BuildException("targetApi attribute value must be >= 1");
            }
        }
        catch (NumberFormatException e) {
            throw new BuildException("targetApi attribute value must be an integer", (Throwable)e);
        }
    }

    public void setOptLevel(OptLevel optLevel) {
        this.mOptLevel = optLevel;
    }

    public void setSupportMode(boolean supportMode) {
        this.mSupportMode = supportMode;
    }

    public void setBinFolder(Path binFolder) {
        this.mBinFolder = TaskHelper.checkSinglePath("binFolder", binFolder);
    }

    @Override
    public void setBuildType(String buildType) {
        super.setBuildType(buildType);
        this.mDebug = Boolean.valueOf(buildType);
    }

    public Path createSource() {
        Path p = new Path(this.getProject());
        this.mPaths.add(p);
        return p;
    }

    public void execute() throws BuildException {
        if (this.mBuildToolsRoot == null) {
            throw new BuildException("RenderScriptTask's 'buildToolsRoot' is required.");
        }
        if (this.mGenFolder == null) {
            throw new BuildException("RenderScriptTask's 'genFolder' is required.");
        }
        if (this.mResFolder == null) {
            throw new BuildException("RenderScriptTask's 'resFolder' is required.");
        }
        if (this.mRsObjFolder == null) {
            throw new BuildException("RenderScriptTask's 'rsObjFolder' is required.");
        }
        if (this.mLibsFolder == null) {
            throw new BuildException("RenderScriptTask's 'libsFolder' is required.");
        }
        if (this.mTargetApi == 0) {
            throw new BuildException("RenderScriptTask's 'targetApi' is required.");
        }
        if (this.mBinFolder == null) {
            throw new BuildException("RenderScriptTask's 'binFolder' is required.");
        }
        ArrayList sourceFolders = Lists.newArrayList();
        for (Path path : this.mPaths) {
            String[] values = path.list();
            if (values == null) continue;
            for (String p : values) {
                sourceFolders.add(new File(p));
            }
        }
        try {
            File binFile = new File(this.mBinFolder);
            ManualRenderScriptChecker checker = new ManualRenderScriptChecker(sourceFolders, binFile);
            if (checker.mustCompile() || this.isNewBuild() || this.hasBuildTypeChanged()) {
                checker.cleanDependencies();
                List<File> emptyFileList = Collections.emptyList();
                RenderScriptProcessor processor = new RenderScriptProcessor(checker.getInputFiles(), emptyFileList, binFile, new File(this.mGenFolder), new File(this.mResFolder), new File(this.mRsObjFolder), new File(this.mLibsFolder), new BuildToolInfo(new FullRevision(0), new File(this.mBuildToolsRoot)), this.mTargetApi, this.mDebug, this.mOptLevel.ordinal(), this.mSupportMode);
                processor.cleanOldOutput(checker.getOldOutputs());
                processor.build(new RenderScriptProcessor.CommandLineLauncher(){

                    @Override
                    public void launch(@NonNull File executable, @NonNull List<String> arguments, @NonNull Map<String, String> envVariableMap) throws IOException, InterruptedException {
                        ExecTask task = new ExecTask();
                        task.setTaskName(executable.getName());
                        task.setProject(RenderScriptTask.this.getProject());
                        task.setOwningTarget(RenderScriptTask.this.getOwningTarget());
                        task.setExecutable(executable.getAbsolutePath());
                        task.setFailonerror(true);
                        for (Map.Entry<String, String> entry : envVariableMap.entrySet()) {
                            Environment.Variable var = new Environment.Variable();
                            var.setKey(entry.getKey());
                            var.setValue(entry.getValue());
                            task.addEnv(var);
                        }
                        for (String arg : arguments) {
                            task.createArg().setValue(arg);
                        }
                        System.out.println(String.format("COMMAND: %s %s", executable.getAbsolutePath(), Joiner.on((char)' ').join(arguments)));
                        task.execute();
                    }
                });
            }
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
        catch (InterruptedException e) {
            throw new BuildException((Throwable)e);
        }
    }

    static {
        EXTENSIONS.add("rs");
        EXTENSIONS.add("fs");
    }

    public static enum OptLevel {
        O0,
        O1,
        O2,
        O3;

    }
}

