/*
 * Decompiled with CFR 0.152.
 */
package com.android.ant;

import com.android.ant.SingleInputOutputTask;
import com.android.ant.TaskHelper;
import com.android.sdklib.internal.build.SignedJarBuilder;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.Path;

public class SignApkTask
extends SingleInputOutputTask {
    private String mKeystore;
    private String mStorepass;
    private String mAlias;
    private String mKeypass;

    public void setKeystore(Path keystore) {
        this.mKeystore = TaskHelper.checkSinglePath("keystore", keystore);
    }

    public void setStorepass(String storepass) {
        this.mStorepass = storepass;
    }

    public void setAlias(String alias) {
        this.mAlias = alias;
    }

    public void setKeypass(String keypass) {
        this.mKeypass = keypass;
    }

    @Override
    protected void createOutput() throws BuildException {
        KeyStore.PrivateKeyEntry key = this.loadKeyEntry(this.mKeystore, null, this.mStorepass.toCharArray(), this.mAlias, this.mKeypass.toCharArray());
        if (key == null) {
            throw new BuildException(String.format("Signing key %s not found", this.mAlias));
        }
        SignedJarBuilder mBuilder = null;
        try {
            mBuilder = new SignedJarBuilder(new FileOutputStream(this.getOutput(), false), key.getPrivateKey(), (X509Certificate)key.getCertificate());
            mBuilder.writeZip(new FileInputStream(this.getInput()), new NullZipFilter());
            mBuilder.close();
        }
        catch (FileNotFoundException e) {
            throw new BuildException(String.format("Keystore '%s' is not found!", this.mKeystore));
        }
        catch (Exception e) {
            throw new BuildException(e.getMessage());
        }
        finally {
            if (mBuilder != null) {
                mBuilder.cleanUp();
            }
        }
    }

    private KeyStore.PrivateKeyEntry loadKeyEntry(String osKeyStorePath, String storeType, char[] storePassword, String alias, char[] aliasPassword) {
        FileInputStream fis = null;
        try {
            KeyStore keyStore = KeyStore.getInstance(storeType != null ? storeType : KeyStore.getDefaultType());
            fis = new FileInputStream(osKeyStorePath);
            keyStore.load(fis, storePassword);
            KeyStore.PrivateKeyEntry privateKeyEntry = (KeyStore.PrivateKeyEntry)keyStore.getEntry(alias, new KeyStore.PasswordProtection(aliasPassword));
            return privateKeyEntry;
        }
        catch (Exception e) {
            String msg = e.getMessage();
            String causeMsg = null;
            Throwable cause = e.getCause();
            if (cause != null) {
                causeMsg = cause.getMessage();
            }
            if (msg != null) {
                if (causeMsg == null) {
                    throw new BuildException(msg);
                }
                throw new BuildException(msg + ": " + causeMsg);
            }
            if (causeMsg == null) {
                throw new BuildException((Throwable)e);
            }
            throw new BuildException(causeMsg);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private static final class NullZipFilter
    implements SignedJarBuilder.IZipEntryFilter {
        private NullZipFilter() {
        }

        @Override
        public boolean checkEntry(String archivePath) throws SignedJarBuilder.IZipEntryFilter.ZipAbortException {
            return true;
        }
    }
}

