/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.cocoa.Cocoa;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSSize;

public final class Cursor
extends Resource {
    public int handle;
    static boolean initialized;

    Cursor(Device device) {
        super(device);
    }

    public Cursor(Device device, int n) {
        super(device);
        switch (n) {
            case 21: {
                this.handle = 10;
                break;
            }
            case 0: {
                this.handle = 0;
                break;
            }
            case 1: {
                this.handle = 14;
                break;
            }
            case 2: {
                this.handle = 5;
                break;
            }
            case 3: {
                this.handle = 0;
                break;
            }
            case 4: {
                this.handle = 5;
                break;
            }
            case 5: {
                this.handle = 5;
                break;
            }
            case 6: {
                this.handle = 5;
                break;
            }
            case 7: {
                this.handle = 21;
                break;
            }
            case 8: {
                this.handle = 5;
                break;
            }
            case 9: {
                this.handle = 17;
                break;
            }
            case 10: {
                this.handle = 19;
                break;
            }
            case 11: {
                this.handle = 20;
                break;
            }
            case 12: {
                this.handle = 16;
                break;
            }
            case 13: {
                this.handle = 15;
                break;
            }
            case 14: {
                this.handle = 5;
                break;
            }
            case 15: {
                this.handle = 5;
                break;
            }
            case 16: {
                this.handle = 5;
                break;
            }
            case 17: {
                this.handle = 5;
                break;
            }
            case 18: {
                this.handle = 5;
                break;
            }
            case 19: {
                this.handle = 4;
                break;
            }
            case 20: {
                this.handle = 18;
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.init();
    }

    public Cursor(Device device, ImageData imageData, ImageData imageData2, int n, int n2) {
        super(device);
        int n3;
        if (imageData == null) {
            SWT.error(4);
        }
        if (imageData2 == null) {
            if (imageData.getTransparencyType() != 2) {
                SWT.error(4);
            }
            imageData2 = imageData.getTransparencyMask();
        }
        if (imageData2.width != imageData.width || imageData2.height != imageData.height) {
            SWT.error(5);
        }
        if (n >= imageData.width || n < 0 || n2 >= imageData.height || n2 < 0) {
            SWT.error(5);
        }
        if (OS.VERSION >= 4160) {
            byte[] byArray = new byte[imageData.width * imageData.height * 4];
            int n4 = 0;
            while (n4 < imageData.height) {
                int n5 = n4 * imageData.width * 4;
                int n6 = 0;
                while (n6 < imageData.width) {
                    int n7 = imageData.getPixel(n6, n4);
                    int n8 = imageData2.getPixel(n6, n4);
                    if (n7 == 0 && n8 == 0) {
                        byArray[n5] = -1;
                    } else if (n7 == 0 && n8 == 1) {
                        byArray[n5 + 3] = -1;
                        byArray[n5 + 2] = -1;
                        byArray[n5 + 1] = -1;
                        byArray[n5] = -1;
                    } else if (n7 == 1) {
                        // empty if block
                    }
                    n5 += 4;
                    ++n6;
                }
                ++n4;
            }
            this.createNSCursor(n, n2, byArray, imageData.width, imageData.height);
            return;
        }
        imageData2 = ImageData.convertMask(imageData2);
        imageData = ImageData.convertMask(imageData);
        int n9 = imageData.width;
        int n10 = imageData.height;
        int n11 = 0;
        int n12 = 0;
        if (n9 > 16 || n10 > 16) {
            n11 = n9;
            n12 = n10;
            int n13 = 0;
            int n14 = 0;
            int n15 = 0;
            while (n15 < n10) {
                n3 = 0;
                while (n3 < n9) {
                    if (imageData.getPixel(n3, n15) != 1 || imageData2.getPixel(n3, n15) != 0) {
                        n11 = Math.min(n11, n3);
                        n12 = Math.min(n12, n15);
                        n13 = Math.max(n13, n3);
                        n14 = Math.max(n14, n15);
                    }
                    ++n3;
                }
                ++n15;
            }
            n9 = n13 - n11 + 1;
            n10 = n14 - n12 + 1;
            if (n9 > 16 || n10 > 16) {
                n15 = Math.min(n9, 16);
                n3 = Math.min(n10, 16);
                ImageData imageData3 = new ImageData(n15, n3, imageData.depth, imageData.palette, 1, null, 0, null, null, -1, -1, imageData.type, imageData.x, imageData.y, imageData.disposalMethod, imageData.delayTime);
                ImageData imageData4 = new ImageData(n15, n3, imageData2.depth, imageData2.palette, 1, null, 0, null, null, -1, -1, imageData2.type, imageData2.x, imageData2.y, imageData2.disposalMethod, imageData2.delayTime);
                ImageData.blit(1, imageData.data, imageData.depth, imageData.bytesPerLine, imageData.getByteOrder(), n11, n12, n9, n10, null, null, null, 255, null, 0, n11, n12, imageData3.data, imageData3.depth, imageData3.bytesPerLine, imageData3.getByteOrder(), 0, 0, n15, n3, null, null, null, false, false);
                ImageData.blit(1, imageData2.data, imageData2.depth, imageData2.bytesPerLine, imageData2.getByteOrder(), n11, n12, n9, n10, null, null, null, 255, null, 0, n11, n12, imageData4.data, imageData4.depth, imageData4.bytesPerLine, imageData4.getByteOrder(), 0, 0, n15, n3, null, null, null, false, false);
                n9 = n15;
                n10 = n3;
                n12 = 0;
                n11 = 0;
                imageData = imageData3;
                imageData2 = imageData4;
            }
        }
        org.eclipse.swt.internal.carbon.Cursor cursor = new org.eclipse.swt.internal.carbon.Cursor();
        byte[] byArray = cursor.data;
        byte[] byArray2 = cursor.mask;
        n3 = 0;
        while (n3 < n10) {
            int n16 = 0;
            int n17 = 0;
            int n18 = 0;
            while (n18 < n9) {
                int n19 = 1 << n9 - 1 - n18;
                if (imageData.getPixel(n11 + n18, n12 + n3) == 0) {
                    n17 = (short)(n17 | n19);
                    if (imageData2.getPixel(n11 + n18, n12 + n3) == 0) {
                        n16 = (short)(n16 | n19);
                    }
                } else if (imageData2.getPixel(n11 + n18, n12 + n3) != 0) {
                    n16 = (short)(n16 | n19);
                }
                ++n18;
            }
            byArray[n3 * 2] = (byte)(n16 >> 8);
            byArray[n3 * 2 + 1] = (byte)(n16 & 0xFF);
            byArray2[n3 * 2] = (byte)(n17 >> 8);
            byArray2[n3 * 2 + 1] = (byte)(n17 & 0xFF);
            ++n3;
        }
        cursor.hotSpot_h = (short)Math.max(0, Math.min(15, n - n11));
        cursor.hotSpot_v = (short)Math.max(0, Math.min(15, n2 - n12));
        this.handle = OS.NewPtr(68);
        if (this.handle == 0) {
            SWT.error(2);
        }
        OS.memmove(this.handle, cursor, 68);
        this.init();
    }

    void createNSCursor(int n, int n2, byte[] byArray, int n3, int n4) {
        int n5;
        int n6;
        if (!initialized) {
            initialized = true;
            n6 = Cocoa.objc_msgSend(Cocoa.objc_msgSend(Cocoa.C_NSWindow, Cocoa.S_alloc), Cocoa.S_init);
            Cocoa.objc_msgSend(n6, Cocoa.S_release);
        }
        if ((n6 = Cocoa.objc_msgSend(Cocoa.C_NSImage, Cocoa.S_alloc)) == 0) {
            SWT.error(2);
        }
        if ((n5 = Cocoa.objc_msgSend(Cocoa.C_NSBitmapImageRep, Cocoa.S_alloc)) == 0) {
            SWT.error(2);
        }
        this.handle = Cocoa.objc_msgSend(Cocoa.C_NSCursor, Cocoa.S_alloc);
        if (this.handle == 0) {
            SWT.error(2);
        }
        NSSize nSSize = new NSSize();
        nSSize.width = n3;
        nSSize.height = n4;
        n6 = Cocoa.objc_msgSend(n6, Cocoa.S_initWithSize, nSSize);
        n5 = Cocoa.objc_msgSend(n5, Cocoa.S_initWithBitmapDataPlanes, null, n3, n4, 8, 4, 1, 0, Cocoa.NSDeviceRGBColorSpace(), 3, n3 * 4, 32);
        int n7 = Cocoa.objc_msgSend(n5, Cocoa.S_bitmapData);
        OS.memmove(n7, byArray, byArray.length);
        Cocoa.objc_msgSend(n6, Cocoa.S_addRepresentation, n5);
        NSPoint nSPoint = new NSPoint();
        nSPoint.x = n;
        nSPoint.y = n2;
        this.handle = Cocoa.objc_msgSend(this.handle, Cocoa.S_initWithImage_hotSpot, n6, nSPoint);
        Cocoa.objc_msgSend(n6, Cocoa.S_release);
        Cocoa.objc_msgSend(n5, Cocoa.S_release);
    }

    public Cursor(Device device, ImageData object, int n, int n2) {
        super(device);
        if (object == null) {
            SWT.error(4);
        }
        if (n >= ((ImageData)object).width || n < 0 || n2 >= ((ImageData)object).height || n2 < 0) {
            SWT.error(5);
        }
        if (OS.VERSION >= 4160) {
            int n3;
            int n4;
            Object object2;
            byte[] byArray = new byte[((ImageData)object).width * ((ImageData)object).height * 4];
            PaletteData paletteData = ((ImageData)object).palette;
            if (paletteData.isDirect) {
                ImageData.blit(1, ((ImageData)object).data, ((ImageData)object).depth, ((ImageData)object).bytesPerLine, ((ImageData)object).getByteOrder(), 0, 0, ((ImageData)object).width, ((ImageData)object).height, paletteData.redMask, paletteData.greenMask, paletteData.blueMask, 255, null, 0, 0, 0, byArray, 32, ((ImageData)object).width * 4, 1, 0, 0, ((ImageData)object).width, ((ImageData)object).height, 0xFF0000, 65280, 255, false, false);
            } else {
                object2 = paletteData.getRGBs();
                n4 = ((RGB[])object2).length;
                byte[] byArray2 = new byte[n4];
                byte[] byArray3 = new byte[n4];
                byte[] byArray4 = new byte[n4];
                n3 = 0;
                while (n3 < ((RGB[])object2).length) {
                    RGB rGB = object2[n3];
                    if (rGB != null) {
                        byArray2[n3] = (byte)rGB.red;
                        byArray3[n3] = (byte)rGB.green;
                        byArray4[n3] = (byte)rGB.blue;
                    }
                    ++n3;
                }
                ImageData.blit(1, ((ImageData)object).data, ((ImageData)object).depth, ((ImageData)object).bytesPerLine, ((ImageData)object).getByteOrder(), 0, 0, ((ImageData)object).width, ((ImageData)object).height, byArray2, byArray3, byArray4, 255, null, 0, 0, 0, byArray, 32, ((ImageData)object).width * 4, 1, 0, 0, ((ImageData)object).width, ((ImageData)object).height, 0xFF0000, 65280, 255, false, false);
            }
            if (((ImageData)object).maskData != null || ((ImageData)object).transparentPixel != -1) {
                object2 = ((ImageData)object).getTransparencyMask();
                byte[] byArray5 = object2.data;
                int n5 = object2.bytesPerLine;
                int n6 = 0;
                int n7 = 0;
                n3 = 0;
                while (n3 < ((ImageData)object).height) {
                    int n8 = 0;
                    while (n8 < ((ImageData)object).width) {
                        byArray[n6] = (byArray5[n7 + (n8 >> 3)] & 1 << 7 - (n8 & 7)) != 0 ? -1 : 0;
                        n6 += 4;
                        ++n8;
                    }
                    n7 += n5;
                    ++n3;
                }
            } else if (((ImageData)object).alpha != -1) {
                byte by = (byte)((ImageData)object).alpha;
                n4 = 0;
                while (n4 < byArray.length) {
                    byArray[n4] = by;
                    n4 += 4;
                }
            } else if (((ImageData)object).alphaData != null) {
                object2 = ((ImageData)object).alphaData;
                n4 = 0;
                while (n4 < byArray.length) {
                    byArray[n4] = (byte)object2[n4 / 4];
                    n4 += 4;
                }
            }
            this.createNSCursor(n, n2, byArray, ((ImageData)object).width, ((ImageData)object).height);
        } else {
            int n9;
            Object object3;
            Object object4;
            int n10;
            Object object5 = ((ImageData)object).getTransparencyMask();
            if (((ImageData)object).depth > 1) {
                byte[] byArray;
                ImageData imageData = new ImageData(((ImageData)object).width, ((ImageData)object).height, 1, ImageData.bwPalette(), 1, null, 0, null, null, -1, -1, 0, 0, 0, 0, 0);
                byte[] byArray6 = new byte[2];
                byArray6[1] = -1;
                byte[] byArray7 = byArray = byArray6;
                byte[] byArray8 = byArray;
                PaletteData paletteData = ((ImageData)object).palette;
                if (paletteData.isDirect) {
                    ImageData.blit(1, ((ImageData)object).data, ((ImageData)object).depth, ((ImageData)object).bytesPerLine, ((ImageData)object).getByteOrder(), 0, 0, ((ImageData)object).width, ((ImageData)object).height, paletteData.redMask, paletteData.greenMask, paletteData.blueMask, 255, null, 0, 0, 0, imageData.data, imageData.depth, imageData.bytesPerLine, imageData.getByteOrder(), 0, 0, imageData.width, imageData.height, byArray, byArray7, byArray8, false, false);
                } else {
                    RGB[] rGBArray = paletteData.getRGBs();
                    n10 = rGBArray.length;
                    byte[] byArray9 = new byte[n10];
                    object4 = new byte[n10];
                    object3 = new byte[n10];
                    n9 = 0;
                    while (n9 < rGBArray.length) {
                        RGB rGB = rGBArray[n9];
                        if (rGB != null) {
                            byArray9[n9] = (byte)rGB.red;
                            object4[n9] = (byte)rGB.green;
                            object3[n9] = (byte)rGB.blue;
                        }
                        ++n9;
                    }
                    ImageData.blit(1, ((ImageData)object).data, ((ImageData)object).depth, ((ImageData)object).bytesPerLine, ((ImageData)object).getByteOrder(), 0, 0, ((ImageData)object).width, ((ImageData)object).height, byArray9, (byte[])object4, (byte[])object3, 255, null, 0, 0, 0, imageData.data, imageData.depth, imageData.bytesPerLine, imageData.getByteOrder(), 0, 0, imageData.width, imageData.height, byArray, byArray7, byArray8, false, false);
                }
                object = imageData;
            }
            int n11 = ((ImageData)object).width;
            int n12 = ((ImageData)object).height;
            int n13 = 0;
            int n14 = 0;
            if (n11 > 16 || n12 > 16) {
                n13 = n11;
                n14 = n12;
                int n15 = 0;
                int n16 = 0;
                n10 = 0;
                while (n10 < n12) {
                    int n17 = 0;
                    while (n17 < n11) {
                        if (((ImageData)object).getPixel(n17, n10) != 1 || ((ImageData)object5).getPixel(n17, n10) != 0) {
                            n13 = Math.min(n13, n17);
                            n14 = Math.min(n14, n10);
                            n15 = Math.max(n15, n17);
                            n16 = Math.max(n16, n10);
                        }
                        ++n17;
                    }
                    ++n10;
                }
                n11 = n15 - n13 + 1;
                n12 = n16 - n14 + 1;
                if (n11 > 16 || n12 > 16) {
                    n10 = Math.min(n11, 16);
                    int n18 = Math.min(n12, 16);
                    object4 = new ImageData(n10, n18, ((ImageData)object).depth, ((ImageData)object).palette, 1, null, 0, null, null, -1, -1, ((ImageData)object).type, ((ImageData)object).x, ((ImageData)object).y, ((ImageData)object).disposalMethod, ((ImageData)object).delayTime);
                    object3 = new ImageData(n10, n18, ((ImageData)object5).depth, ((ImageData)object5).palette, 1, null, 0, null, null, -1, -1, ((ImageData)object5).type, ((ImageData)object5).x, ((ImageData)object5).y, ((ImageData)object5).disposalMethod, ((ImageData)object5).delayTime);
                    ImageData.blit(1, ((ImageData)object).data, ((ImageData)object).depth, ((ImageData)object).bytesPerLine, ((ImageData)object).getByteOrder(), n13, n14, n11, n12, null, null, null, 255, null, 0, n13, n14, ((ImageData)object4).data, ((ImageData)object4).depth, ((ImageData)object4).bytesPerLine, ((ImageData)object4).getByteOrder(), 0, 0, n10, n18, null, null, null, false, false);
                    ImageData.blit(1, ((ImageData)object5).data, ((ImageData)object5).depth, ((ImageData)object5).bytesPerLine, ((ImageData)object5).getByteOrder(), n13, n14, n11, n12, null, null, null, 255, null, 0, n13, n14, ((ImageData)object3).data, ((ImageData)object3).depth, ((ImageData)object3).bytesPerLine, ((ImageData)object3).getByteOrder(), 0, 0, n10, n18, null, null, null, false, false);
                    n11 = n10;
                    n12 = n18;
                    n14 = 0;
                    n13 = 0;
                    object = object4;
                    object5 = object3;
                }
            }
            org.eclipse.swt.internal.carbon.Cursor cursor = new org.eclipse.swt.internal.carbon.Cursor();
            byte[] byArray = cursor.data;
            byte[] byArray10 = cursor.mask;
            int n19 = 0;
            while (n19 < n12) {
                int n20 = 0;
                int n21 = 0;
                n9 = 0;
                while (n9 < n11) {
                    int n22 = 1 << n11 - 1 - n9;
                    if (((ImageData)object).getPixel(n9 + n13, n19 + n14) == 0) {
                        if (((ImageData)object5).getPixel(n9 + n13, n19 + n14) != 0) {
                            n20 = (short)(n20 | n22);
                            n21 = (short)(n21 | n22);
                        }
                    } else if (((ImageData)object5).getPixel(n9 + n13, n19 + n14) != 0) {
                        n21 = (short)(n21 | n22);
                    }
                    ++n9;
                }
                byArray[n19 * 2] = (byte)(n20 >> 8);
                byArray[n19 * 2 + 1] = (byte)(n20 & 0xFF);
                byArray10[n19 * 2] = (byte)(n21 >> 8);
                byArray10[n19 * 2 + 1] = (byte)(n21 & 0xFF);
                ++n19;
            }
            cursor.hotSpot_h = (short)Math.max(0, Math.min(15, n - n13));
            cursor.hotSpot_v = (short)Math.max(0, Math.min(15, n2 - n14));
            this.handle = OS.NewPtr(68);
            if (this.handle == 0) {
                SWT.error(2);
            }
            OS.memmove(this.handle, cursor, 68);
        }
        this.init();
    }

    void destroy() {
        switch (this.handle) {
            case 0: 
            case 4: 
            case 5: 
            case 7: 
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                break;
            }
            default: {
                if (OS.VERSION >= 4160) {
                    Cocoa.objc_msgSend(this.handle, Cocoa.S_release);
                    break;
                }
                OS.DisposePtr(this.handle);
            }
        }
        this.handle = -1;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Cursor)) {
            return false;
        }
        Cursor cursor = (Cursor)object;
        return this.device == cursor.device && this.handle == cursor.handle;
    }

    public int hashCode() {
        return this.handle;
    }

    public boolean isDisposed() {
        return this.handle == -1;
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Cursor {*DISPOSED*}";
        }
        return "Cursor {" + this.handle + "}";
    }

    public static Cursor carbon_new(Device device, int n) {
        Cursor cursor = new Cursor(device);
        cursor.handle = n;
        return cursor;
    }
}

