/*
 * Decompiled with CFR 0.152.
 */
package com.android.traceview;

class TickScaler {
    private double mMinVal;
    private double mMaxVal;
    private double mRangeVal;
    private int mNumPixels;
    private int mPixelsPerTick;
    private double mPixelsPerRange;
    private double mTickIncrement;
    private double mMinMajorTick;

    TickScaler(double minVal, double maxVal, int numPixels, int pixelsPerTick) {
        this.mMinVal = minVal;
        this.mMaxVal = maxVal;
        this.mNumPixels = numPixels;
        this.mPixelsPerTick = pixelsPerTick;
    }

    public void setMinVal(double minVal) {
        this.mMinVal = minVal;
    }

    public double getMinVal() {
        return this.mMinVal;
    }

    public void setMaxVal(double maxVal) {
        this.mMaxVal = maxVal;
    }

    public double getMaxVal() {
        return this.mMaxVal;
    }

    public void setNumPixels(int numPixels) {
        this.mNumPixels = numPixels;
    }

    public int getNumPixels() {
        return this.mNumPixels;
    }

    public void setPixelsPerTick(int pixelsPerTick) {
        this.mPixelsPerTick = pixelsPerTick;
    }

    public int getPixelsPerTick() {
        return this.mPixelsPerTick;
    }

    public void setPixelsPerRange(double pixelsPerRange) {
        this.mPixelsPerRange = pixelsPerRange;
    }

    public double getPixelsPerRange() {
        return this.mPixelsPerRange;
    }

    public void setTickIncrement(double tickIncrement) {
        this.mTickIncrement = tickIncrement;
    }

    public double getTickIncrement() {
        return this.mTickIncrement;
    }

    public void setMinMajorTick(double minMajorTick) {
        this.mMinMajorTick = minMajorTick;
    }

    public double getMinMajorTick() {
        return this.mMinMajorTick;
    }

    public int valueToPixel(double value) {
        return (int)Math.ceil(this.mPixelsPerRange * (value - this.mMinVal) - 0.5);
    }

    public double valueToPixelFraction(double value) {
        return this.mPixelsPerRange * (value - this.mMinVal);
    }

    public double pixelToValue(int pixel) {
        return this.mMinVal + (double)pixel / this.mPixelsPerRange;
    }

    public void computeTicks(boolean useGivenEndPoints) {
        int numTicks = this.mNumPixels / this.mPixelsPerTick;
        this.mRangeVal = this.mMaxVal - this.mMinVal;
        this.mTickIncrement = this.mRangeVal / (double)numTicks;
        double dlogTickIncrement = Math.log10(this.mTickIncrement);
        int logTickIncrement = (int)Math.floor(dlogTickIncrement);
        double scale = Math.pow(10.0, logTickIncrement);
        double scaledTickIncr = this.mTickIncrement / scale;
        scaledTickIncr = scaledTickIncr > 5.0 ? 10.0 : (scaledTickIncr > 2.0 ? 5.0 : (scaledTickIncr > 1.0 ? 2.0 : 1.0));
        this.mTickIncrement = scaledTickIncr * scale;
        if (!useGivenEndPoints) {
            double minorTickIncrement = this.mTickIncrement / 5.0;
            double dval = this.mMaxVal / minorTickIncrement;
            int ival = (int)dval;
            if ((double)ival != dval) {
                this.mMaxVal = (double)(ival + 1) * minorTickIncrement;
            }
            ival = (int)(this.mMinVal / this.mTickIncrement);
            this.mMinMajorTick = this.mMinVal = (double)ival * this.mTickIncrement;
        } else {
            int ival = (int)(this.mMinVal / this.mTickIncrement);
            this.mMinMajorTick = (double)ival * this.mTickIncrement;
            if (this.mMinMajorTick < this.mMinVal) {
                this.mMinMajorTick += this.mTickIncrement;
            }
        }
        this.mRangeVal = this.mMaxVal - this.mMinVal;
        this.mPixelsPerRange = (double)this.mNumPixels / this.mRangeVal;
    }
}

