/*
 * Decompiled with CFR 0.152.
 */
package com.android.traceview;

import com.android.traceview.MethodData;
import com.android.traceview.ProfileData;
import com.android.traceview.ThreadData;

interface TimeBase {
    public static final TimeBase CPU_TIME = new CpuTimeBase();
    public static final TimeBase REAL_TIME = new RealTimeBase();

    public long getTime(ThreadData var1);

    public long getElapsedInclusiveTime(MethodData var1);

    public long getElapsedExclusiveTime(MethodData var1);

    public long getElapsedInclusiveTime(ProfileData var1);

    public static final class RealTimeBase
    implements TimeBase {
        @Override
        public long getTime(ThreadData threadData) {
            return threadData.getRealTime();
        }

        @Override
        public long getElapsedInclusiveTime(MethodData methodData) {
            return methodData.getElapsedInclusiveRealTime();
        }

        @Override
        public long getElapsedExclusiveTime(MethodData methodData) {
            return methodData.getElapsedExclusiveRealTime();
        }

        @Override
        public long getElapsedInclusiveTime(ProfileData profileData) {
            return profileData.getElapsedInclusiveRealTime();
        }
    }

    public static final class CpuTimeBase
    implements TimeBase {
        @Override
        public long getTime(ThreadData threadData) {
            return threadData.getCpuTime();
        }

        @Override
        public long getElapsedInclusiveTime(MethodData methodData) {
            return methodData.getElapsedInclusiveCpuTime();
        }

        @Override
        public long getElapsedExclusiveTime(MethodData methodData) {
            return methodData.getElapsedExclusiveCpuTime();
        }

        @Override
        public long getElapsedInclusiveTime(ProfileData profileData) {
            return profileData.getElapsedInclusiveCpuTime();
        }
    }
}

