/*
 * Decompiled with CFR 0.152.
 */
package com.android.manifmerger;

import com.android.annotations.Nullable;
import com.android.manifmerger.KeyResolver;
import com.android.manifmerger.ManifestMerger2;
import com.android.manifmerger.PlaceholderHandler;
import com.android.manifmerger.XmlDocument;
import com.android.utils.PositionXmlParser;
import com.google.common.base.Optional;
import com.google.common.base.Strings;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public final class XmlLoader {
    public static final SourceLocation UNKNOWN = new SourceLocation(){

        @Override
        public String print(boolean shortFormat) {
            return "Unknown location";
        }

        @Override
        public Node toXml(Document document) {
            return document.createElement("source");
        }
    };

    private XmlLoader() {
    }

    public static XmlDocument load(KeyResolver<String> selectors, PlaceholderHandler.KeyBasedValueResolver<ManifestMerger2.SystemProperty> systemPropertyResolver, String displayName, File xmlFile, XmlDocument.Type type, Optional<String> mainManifestPackageName) throws IOException, SAXException, ParserConfigurationException {
        PositionXmlParser positionXmlParser = new PositionXmlParser();
        BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(xmlFile));
        Document domDocument = positionXmlParser.parse(inputStream);
        return domDocument != null ? new XmlDocument(positionXmlParser, new FileSourceLocation(displayName, xmlFile), selectors, systemPropertyResolver, domDocument.getDocumentElement(), type, mainManifestPackageName) : null;
    }

    public static XmlDocument load(KeyResolver<String> selectors, PlaceholderHandler.KeyBasedValueResolver<ManifestMerger2.SystemProperty> systemPropertyResolver, SourceLocation sourceLocation, String xml, XmlDocument.Type type, Optional<String> mainManifestPackageName) throws IOException, SAXException, ParserConfigurationException {
        PositionXmlParser positionXmlParser = new PositionXmlParser();
        Document domDocument = positionXmlParser.parse(xml);
        return domDocument != null ? new XmlDocument(positionXmlParser, sourceLocation, selectors, systemPropertyResolver, domDocument.getDocumentElement(), type, mainManifestPackageName) : null;
    }

    public static SourceLocation locationFromXml(Element location) {
        String scheme = location.getAttribute("scheme");
        if (Strings.isNullOrEmpty(scheme)) {
            return UNKNOWN;
        }
        if (scheme.equals("file://")) {
            return new FileSourceLocation(location.getAttribute("name"), new File(location.getAttribute("value")));
        }
        throw new RuntimeException(scheme + " scheme unsupported");
    }

    private static class FileSourceLocation
    implements SourceLocation {
        private final File mFile;
        private final String mName;

        private FileSourceLocation(@Nullable String name, File file) {
            this.mFile = file;
            this.mName = Strings.isNullOrEmpty(name) ? file.getName() : name;
        }

        @Override
        public String print(boolean shortFormat) {
            return shortFormat ? this.mName : this.mFile.getAbsolutePath();
        }

        @Override
        public Node toXml(Document document) {
            Element location = document.createElement("source");
            location.setAttribute("name", this.mName);
            location.setAttribute("scheme", "file://");
            location.setAttribute("value", this.mFile.getAbsolutePath());
            return location;
        }
    }

    public static interface SourceLocation {
        public String print(boolean var1);

        public Node toXml(Document var1);
    }
}

