/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.monitor;

import com.android.ide.eclipse.monitor.MonitorPlugin;
import com.android.sdkstats.SdkStatsService;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ui.IStartup;

public class MonitorStartup
implements IStartup {
    public void earlyStartup() {
        Job pingJob = new Job("Android SDK Ping"){

            protected IStatus run(IProgressMonitor monitor) {
                SdkStatsService stats = new SdkStatsService();
                File sdkFolder = MonitorPlugin.getDefault().getSdkFolder();
                if (sdkFolder == null) {
                    return Status.OK_STATUS;
                }
                String toolsPath = new File(sdkFolder, "tools").getAbsolutePath();
                MonitorStartup.ping(stats, toolsPath);
                return Status.OK_STATUS;
            }
        };
        pingJob.setPriority(50);
        pingJob.schedule();
    }

    private static void ping(SdkStatsService stats, String toolsLocation) {
        Properties p = new Properties();
        try {
            String revision;
            File sourceProp = toolsLocation != null && toolsLocation.length() > 0 ? new File(toolsLocation, "source.properties") : new File("source.properties");
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(sourceProp);
                p.load(fis);
            }
            catch (Throwable throwable) {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
            if ((revision = p.getProperty("Pkg.Revision")) != null && revision.length() > 0) {
                stats.ping("ddms", revision);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {}
    }
}

