/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.monitor.ddms;

import com.android.ddmlib.DebugPortManager;
import com.android.ddmlib.IDevice;
import com.android.ide.eclipse.ddms.DdmsPlugin;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.preference.IPreferenceStore;

public class DebugPortProvider
implements DebugPortManager.IDebugPortProvider {
    private static DebugPortProvider sThis = new DebugPortProvider();
    public static final String PREFS_STATIC_PORT_LIST = "android.staticPortList";
    private Map<String, Map<String, Integer>> mMap;

    public static DebugPortProvider getInstance() {
        return sThis;
    }

    private DebugPortProvider() {
        this.computePortList();
    }

    public int getPort(IDevice device, String appName) {
        Integer i;
        Map<String, Integer> deviceMap;
        if (this.mMap != null && (deviceMap = this.mMap.get(device.getSerialNumber())) != null && (i = deviceMap.get(appName)) != null) {
            return i;
        }
        return -1;
    }

    public Map<String, Map<String, Integer>> getPortList() {
        return this.mMap;
    }

    private void computePortList() {
        this.mMap = new HashMap<String, Map<String, Integer>>();
        IPreferenceStore store = DdmsPlugin.getDefault().getPreferenceStore();
        String value = store.getString(PREFS_STATIC_PORT_LIST);
        if (value != null && value.length() > 0) {
            String[] portSegments;
            String[] stringArray = portSegments = value.split("\\|");
            int n = portSegments.length;
            int n2 = 0;
            while (n2 < n) {
                String seg = stringArray[n2];
                String[] entry = seg.split(":");
                String deviceName = null;
                deviceName = entry.length == 3 ? entry[2] : "emulator-5554";
                Map<String, Integer> deviceMap = this.mMap.get(deviceName);
                if (deviceMap == null) {
                    deviceMap = new HashMap<String, Integer>();
                    this.mMap.put(deviceName, deviceMap);
                }
                deviceMap.put(entry[0], Integer.valueOf(entry[1]));
                ++n2;
            }
        }
    }

    public void setPortList(Map<String, Map<String, Integer>> map) {
        this.mMap.clear();
        this.mMap.putAll(map);
        StringBuilder sb = new StringBuilder();
        Set<String> deviceKeys = map.keySet();
        for (String deviceKey : deviceKeys) {
            Map<String, Integer> deviceMap = map.get(deviceKey);
            if (deviceMap == null) continue;
            Set<String> appKeys = deviceMap.keySet();
            for (String appKey : appKeys) {
                Integer port = deviceMap.get(appKey);
                if (port == null) continue;
                sb.append(appKey).append(':').append(port).append(':').append(deviceKey).append('|');
            }
        }
        String value = sb.toString();
        IPreferenceStore store = DdmsPlugin.getDefault().getPreferenceStore();
        store.setValue(PREFS_STATIC_PORT_LIST, value);
    }
}

