/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.viewers.model;

import org.eclipse.debug.internal.ui.viewers.model.IInternalTreeModelViewer;
import org.eclipse.debug.internal.ui.viewers.model.ILabelUpdateListener;
import org.eclipse.debug.internal.ui.viewers.model.ITreeModelContentProvider;
import org.eclipse.debug.internal.ui.viewers.model.ITreeModelLabelProvider;
import org.eclipse.debug.internal.ui.viewers.model.TreeModelContentProvider;
import org.eclipse.debug.internal.ui.viewers.model.TreeModelLabelProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelChangedListener;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelDelta;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IStateUpdateListener;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdateListener;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ModelDelta;
import org.eclipse.debug.internal.ui.viewers.model.provisional.TreeModelViewer;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class SubTreeModelViewer
extends TreeModelViewer {
    private TreePath fRootPath = TreePath.EMPTY;
    private DelegatingTreeModelViewer fDelegatingViewer;

    public TreePath getRootPath() {
        return this.fRootPath;
    }

    public SubTreeModelViewer(Composite parent, int style, IPresentationContext context) {
        super(parent, style, context);
    }

    public void setInput(Object input, TreePath rootPath) {
        this.fRootPath = rootPath;
        super.setInput(input);
    }

    private TreePath createFullPath(TreePath subPath) {
        if (this.fRootPath == null) {
            return TreePath.EMPTY;
        }
        Object[] segments = new Object[this.fRootPath.getSegmentCount() + subPath.getSegmentCount()];
        int i = 0;
        while (i < this.fRootPath.getSegmentCount()) {
            segments[i] = this.fRootPath.getSegment(i);
            ++i;
        }
        i = 0;
        while (i < subPath.getSegmentCount()) {
            segments[i + this.fRootPath.getSegmentCount()] = subPath.getSegment(i);
            ++i;
        }
        return new TreePath(segments);
    }

    private TreePath createSubPath(TreePath fullPath) {
        if (this.fRootPath == null) {
            return TreePath.EMPTY;
        }
        if (fullPath.getSegmentCount() <= this.fRootPath.getSegmentCount()) {
            return TreePath.EMPTY;
        }
        Object[] segments = new Object[fullPath.getSegmentCount() - this.fRootPath.getSegmentCount()];
        int i = 0;
        while (i < segments.length) {
            segments[i] = fullPath.getSegment(i + this.fRootPath.getSegmentCount());
            ++i;
        }
        return new TreePath(segments);
    }

    private DelegatingTreeModelViewer getDelegatingViewer() {
        if (this.fDelegatingViewer == null) {
            this.fDelegatingViewer = new DelegatingTreeModelViewer();
        }
        return this.fDelegatingViewer;
    }

    protected ITreeModelContentProvider createContentProvider() {
        return new SubTreeModelContentProvider();
    }

    protected ITreeModelLabelProvider createLabelProvider() {
        return new SubTreeModelLabelProvider(this.getDelegatingViewer());
    }

    public class DelegatingTreeModelViewer
    extends Viewer
    implements IInternalTreeModelViewer {
        public void reveal(TreePath path, int index) {
            if (path.startsWith(SubTreeModelViewer.this.fRootPath, null)) {
                SubTreeModelViewer.this.reveal(SubTreeModelViewer.this.createSubPath(path), index);
            }
        }

        public void replace(Object parentOrTreePath, int index, Object element) {
            if (parentOrTreePath instanceof TreePath) {
                TreePath path = (TreePath)parentOrTreePath;
                if (path.startsWith(SubTreeModelViewer.this.fRootPath, null)) {
                    SubTreeModelViewer.this.replace(SubTreeModelViewer.this.createSubPath(path), index, element);
                }
            } else {
                SubTreeModelViewer.this.replace(parentOrTreePath, index, element);
            }
        }

        public void setChildCount(Object elementOrTreePath, int count) {
            if (elementOrTreePath instanceof TreePath) {
                TreePath path = (TreePath)elementOrTreePath;
                if (path.startsWith(SubTreeModelViewer.this.fRootPath, null)) {
                    SubTreeModelViewer.this.setChildCount(SubTreeModelViewer.this.createSubPath(path), count);
                }
            } else {
                SubTreeModelViewer.this.setChildCount(elementOrTreePath, count);
            }
        }

        public void setHasChildren(Object elementOrTreePath, boolean hasChildren) {
            if (elementOrTreePath instanceof TreePath) {
                TreePath path = (TreePath)elementOrTreePath;
                if (path.startsWith(SubTreeModelViewer.this.fRootPath, null)) {
                    SubTreeModelViewer.this.setHasChildren(SubTreeModelViewer.this.createSubPath(path), hasChildren);
                }
            } else {
                SubTreeModelViewer.this.setHasChildren(elementOrTreePath, hasChildren);
            }
        }

        public void autoExpand(TreePath elementPath) {
        }

        public void setExpandedState(Object elementOrTreePath, boolean expanded) {
            if (elementOrTreePath instanceof TreePath) {
                TreePath path = (TreePath)elementOrTreePath;
                if (path.startsWith(SubTreeModelViewer.this.fRootPath, null)) {
                    SubTreeModelViewer.this.setExpandedState(SubTreeModelViewer.this.createSubPath(path), expanded);
                }
            } else {
                SubTreeModelViewer.this.setExpandedState(elementOrTreePath, expanded);
            }
        }

        public void expandToLevel(Object elementOrTreePath, int level) {
            if (elementOrTreePath instanceof TreePath) {
                TreePath path = (TreePath)elementOrTreePath;
                if (path.startsWith(SubTreeModelViewer.this.fRootPath, null)) {
                    SubTreeModelViewer.this.expandToLevel(SubTreeModelViewer.this.createSubPath(path), level);
                }
            } else {
                SubTreeModelViewer.this.expandToLevel(elementOrTreePath, level);
            }
        }

        public void remove(Object elementOrTreePath) {
            if (elementOrTreePath instanceof TreePath) {
                TreePath path = (TreePath)elementOrTreePath;
                if (path.startsWith(SubTreeModelViewer.this.fRootPath, null)) {
                    SubTreeModelViewer.this.remove(SubTreeModelViewer.this.createSubPath(path));
                }
            } else {
                SubTreeModelViewer.this.remove(elementOrTreePath);
            }
        }

        public void remove(Object parentOrTreePath, int index) {
            if (parentOrTreePath instanceof TreePath) {
                TreePath path = (TreePath)parentOrTreePath;
                if (path.startsWith(SubTreeModelViewer.this.fRootPath, null)) {
                    SubTreeModelViewer.this.remove(SubTreeModelViewer.this.createSubPath(path), index);
                }
            } else {
                SubTreeModelViewer.this.remove(parentOrTreePath, index);
            }
        }

        public void insert(Object parentOrTreePath, Object element, int position) {
            if (parentOrTreePath instanceof TreePath) {
                TreePath path = (TreePath)parentOrTreePath;
                if (path.startsWith(SubTreeModelViewer.this.fRootPath, null)) {
                    SubTreeModelViewer.this.insert(SubTreeModelViewer.this.createSubPath(path), element, position);
                }
            } else {
                SubTreeModelViewer.this.insert(parentOrTreePath, element, position);
            }
        }

        public boolean getExpandedState(Object elementOrTreePath) {
            if (elementOrTreePath instanceof TreePath) {
                TreePath path = (TreePath)elementOrTreePath;
                if (path.startsWith(SubTreeModelViewer.this.fRootPath, null)) {
                    return SubTreeModelViewer.this.getExpandedState(SubTreeModelViewer.this.createSubPath(path));
                }
            } else {
                return SubTreeModelViewer.this.getExpandedState(elementOrTreePath);
            }
            return false;
        }

        public int getChildCount(TreePath path) {
            if (path.startsWith(SubTreeModelViewer.this.fRootPath, null)) {
                return SubTreeModelViewer.this.getChildCount(SubTreeModelViewer.this.createSubPath(path));
            }
            return -1;
        }

        public boolean getHasChildren(Object elementOrTreePath) {
            if (elementOrTreePath instanceof TreePath) {
                TreePath path = (TreePath)elementOrTreePath;
                if (path.startsWith(SubTreeModelViewer.this.fRootPath, null)) {
                    return SubTreeModelViewer.this.getHasChildren(SubTreeModelViewer.this.createSubPath(path));
                }
            } else {
                return SubTreeModelViewer.this.getHasChildren(elementOrTreePath);
            }
            return false;
        }

        public Object getChildElement(TreePath path, int index) {
            if (path.startsWith(SubTreeModelViewer.this.fRootPath, null)) {
                return SubTreeModelViewer.this.getChildElement(SubTreeModelViewer.this.createSubPath(path), index);
            }
            return null;
        }

        public TreePath getTopElementPath() {
            return SubTreeModelViewer.this.createFullPath(SubTreeModelViewer.this.getTopElementPath());
        }

        public int findElementIndex(TreePath parentPath, Object element) {
            if (parentPath.startsWith(SubTreeModelViewer.this.fRootPath, null)) {
                return SubTreeModelViewer.this.findElementIndex(SubTreeModelViewer.this.createSubPath(parentPath), element);
            }
            return -1;
        }

        public boolean getElementChildrenRealized(TreePath parentPath) {
            if (parentPath.startsWith(SubTreeModelViewer.this.fRootPath, null)) {
                return SubTreeModelViewer.this.getElementChildrenRealized(SubTreeModelViewer.this.createSubPath(parentPath));
            }
            return true;
        }

        public void setElementData(TreePath path, int numColumns, String[] labels, ImageDescriptor[] images, FontData[] fontDatas, RGB[] foregrounds, RGB[] backgrounds) {
            if (path.startsWith(SubTreeModelViewer.this.fRootPath, null)) {
                SubTreeModelViewer.this.setElementData(SubTreeModelViewer.this.createSubPath(path), numColumns, labels, images, fontDatas, foregrounds, backgrounds);
            }
        }

        public Control getControl() {
            return SubTreeModelViewer.this.getControl();
        }

        public Object getInput() {
            return SubTreeModelViewer.this.getInput();
        }

        public ISelection getSelection() {
            return SubTreeModelViewer.this.getSelection();
        }

        public void refresh() {
            SubTreeModelViewer.this.refresh();
        }

        public void setInput(Object input) {
            SubTreeModelViewer.this.setInput(input);
        }

        public void setSelection(ISelection selection, boolean reveal) {
            SubTreeModelViewer.this.setSelection(selection, reveal);
        }

        public String[] getVisibleColumns() {
            return SubTreeModelViewer.this.getVisibleColumns();
        }

        public void addLabelUpdateListener(ILabelUpdateListener listener) {
            SubTreeModelViewer.this.addLabelUpdateListener(listener);
        }

        public void addModelChangedListener(IModelChangedListener listener) {
            SubTreeModelViewer.this.addModelChangedListener(listener);
        }

        public void addStateUpdateListener(IStateUpdateListener listener) {
            SubTreeModelViewer.this.addStateUpdateListener(listener);
        }

        public void addViewerUpdateListener(IViewerUpdateListener listener) {
            SubTreeModelViewer.this.addViewerUpdateListener(listener);
        }

        public int getAutoExpandLevel() {
            return SubTreeModelViewer.this.getAutoExpandLevel();
        }

        public Display getDisplay() {
            return SubTreeModelViewer.this.getDisplay();
        }

        public ViewerLabel getElementLabel(TreePath path, String columnId) {
            return SubTreeModelViewer.this.getElementLabel(path, columnId);
        }

        public IPresentationContext getPresentationContext() {
            return SubTreeModelViewer.this.getPresentationContext();
        }

        public void removeLabelUpdateListener(ILabelUpdateListener listener) {
            SubTreeModelViewer.this.removeLabelUpdateListener(listener);
        }

        public void removeModelChangedListener(IModelChangedListener listener) {
            SubTreeModelViewer.this.removeModelChangedListener(listener);
        }

        public void removeStateUpdateListener(IStateUpdateListener listener) {
            SubTreeModelViewer.this.removeStateUpdateListener(listener);
        }

        public void removeViewerUpdateListener(IViewerUpdateListener listener) {
            SubTreeModelViewer.this.removeViewerUpdateListener(listener);
        }

        public boolean saveElementState(TreePath path, ModelDelta delta, int deltaFlags) {
            return SubTreeModelViewer.this.saveElementState(path, delta, deltaFlags);
        }

        public void setAutoExpandLevel(int level) {
            SubTreeModelViewer.this.setAutoExpandLevel(level);
        }

        public void setSelection(ISelection selection, boolean reveal, boolean force) {
            SubTreeModelViewer.this.setSelection(selection, reveal, force);
        }

        public boolean trySelection(ISelection selection, boolean reveal, boolean force) {
            return SubTreeModelViewer.this.trySelection(selection, reveal, force);
        }

        public void updateViewer(IModelDelta delta) {
            SubTreeModelViewer.this.updateViewer(delta);
        }

        public ViewerFilter[] getFilters() {
            return SubTreeModelViewer.this.getFilters();
        }

        public void addFilter(ViewerFilter filter) {
            SubTreeModelViewer.this.addFilter(filter);
        }

        public void setFilters(ViewerFilter[] filters) {
            SubTreeModelViewer.this.setFilters(filters);
        }

        public boolean overrideSelection(ISelection current, ISelection candidate) {
            return SubTreeModelViewer.this.overrideSelection(current, candidate);
        }

        public void refresh(Object element) {
            SubTreeModelViewer.this.refresh(element);
        }

        public void update(Object element) {
            SubTreeModelViewer.this.update(element);
        }

        public void clearSelectionQuiet() {
            SubTreeModelViewer.this.clearSelectionQuiet();
        }

        public TreePath[] getElementPaths(Object element) {
            TreePath[] subViewerPaths = SubTreeModelViewer.this.getElementPaths(element);
            TreePath[] retVal = new TreePath[subViewerPaths.length];
            int i = 0;
            while (i < subViewerPaths.length) {
                retVal[i] = SubTreeModelViewer.this.createFullPath(subViewerPaths[i]);
                ++i;
            }
            return retVal;
        }

        public boolean getElementChecked(TreePath path) {
            return SubTreeModelViewer.this.getElementChecked(SubTreeModelViewer.this.createSubPath(path));
        }

        public boolean getElementGrayed(TreePath path) {
            return SubTreeModelViewer.this.getElementGrayed(SubTreeModelViewer.this.createSubPath(path));
        }

        public void setElementChecked(TreePath path, boolean checked, boolean grayed) {
            SubTreeModelViewer.this.setElementChecked(SubTreeModelViewer.this.createSubPath(path), checked, grayed);
        }
    }

    private class SubTreeModelContentProvider
    implements ITreeModelContentProvider {
        private TreeModelContentProvider fBaseProvider = new TreeModelContentProvider();

        public void updateHasChildren(TreePath path) {
            this.fBaseProvider.updateHasChildren(SubTreeModelViewer.this.createFullPath(path));
        }

        public void updateChildCount(TreePath path, int currentChildCount) {
            this.fBaseProvider.updateChildCount(SubTreeModelViewer.this.createFullPath(path), currentChildCount);
        }

        public void updateElement(TreePath parentPath, int viewIndex) {
            this.fBaseProvider.updateElement(SubTreeModelViewer.this.createFullPath(parentPath), viewIndex);
        }

        public int viewToModelCount(TreePath parentPath, int count) {
            return this.fBaseProvider.viewToModelCount(SubTreeModelViewer.this.createFullPath(parentPath), count);
        }

        public int viewToModelIndex(TreePath parentPath, int index) {
            return this.fBaseProvider.viewToModelIndex(SubTreeModelViewer.this.createFullPath(parentPath), index);
        }

        public void addModelChangedListener(IModelChangedListener listener) {
            this.fBaseProvider.addModelChangedListener(listener);
        }

        public void preserveState(TreePath subPath) {
            this.fBaseProvider.preserveState(SubTreeModelViewer.this.createFullPath(subPath));
        }

        public void addStateUpdateListener(IStateUpdateListener listener) {
            this.fBaseProvider.addStateUpdateListener(listener);
        }

        public void addViewerUpdateListener(IViewerUpdateListener listener) {
            this.fBaseProvider.addViewerUpdateListener(listener);
        }

        public int getModelDeltaMask() {
            return this.fBaseProvider.getModelDeltaMask();
        }

        public int modelToViewChildCount(TreePath parentPath, int count) {
            return this.fBaseProvider.modelToViewChildCount(SubTreeModelViewer.this.createFullPath(parentPath), count);
        }

        public int modelToViewIndex(TreePath parentPath, int index) {
            return this.fBaseProvider.modelToViewIndex(SubTreeModelViewer.this.createFullPath(parentPath), index);
        }

        public void removeModelChangedListener(IModelChangedListener listener) {
            this.fBaseProvider.removeModelChangedListener(listener);
        }

        public void removeStateUpdateListener(IStateUpdateListener listener) {
            this.fBaseProvider.removeStateUpdateListener(listener);
        }

        public void removeViewerUpdateListener(IViewerUpdateListener listener) {
            this.fBaseProvider.removeViewerUpdateListener(listener);
        }

        public void setModelDeltaMask(int mask) {
            this.fBaseProvider.setModelDeltaMask(mask);
        }

        public boolean areTreeModelViewerFiltersApplicable(Object parentElement) {
            return this.fBaseProvider.areTreeModelViewerFiltersApplicable(parentElement);
        }

        public boolean shouldFilter(Object parentElementOrTreePath, Object element) {
            if (parentElementOrTreePath instanceof TreePath) {
                TreePath path = (TreePath)parentElementOrTreePath;
                return this.fBaseProvider.shouldFilter(SubTreeModelViewer.this.createFullPath(path), element);
            }
            return this.fBaseProvider.shouldFilter(parentElementOrTreePath, element);
        }

        public void unmapPath(TreePath path) {
            this.fBaseProvider.unmapPath(SubTreeModelViewer.this.createFullPath(path));
        }

        public void updateModel(IModelDelta delta, int mask) {
            this.fBaseProvider.updateModel(delta, mask);
        }

        public TreePath[] getParents(Object element) {
            return null;
        }

        public void cancelRestore(TreePath path, int flags) {
            this.fBaseProvider.cancelRestore(SubTreeModelViewer.this.createFullPath(path), flags);
        }

        public void dispose() {
            this.fBaseProvider.dispose();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.fBaseProvider.inputChanged(SubTreeModelViewer.this.fDelegatingViewer, oldInput, newInput);
        }

        public void postInputChanged(IInternalTreeModelViewer viewer, Object oldInput, Object newInput) {
            this.fBaseProvider.postInputChanged(viewer, oldInput, newInput);
        }

        public boolean setChecked(TreePath path, boolean checked) {
            return this.fBaseProvider.setChecked(SubTreeModelViewer.this.createFullPath(path), checked);
        }
    }

    private class SubTreeModelLabelProvider
    extends ColumnLabelProvider
    implements ITreeModelLabelProvider {
        private TreeModelLabelProvider fBaseProvider;

        public SubTreeModelLabelProvider(IInternalTreeModelViewer viewer) {
            this.fBaseProvider = new TreeModelLabelProvider(viewer);
        }

        public boolean update(TreePath elementPath) {
            return this.fBaseProvider.update(SubTreeModelViewer.this.createFullPath(elementPath));
        }

        public void addLabelUpdateListener(ILabelUpdateListener listener) {
            this.fBaseProvider.addLabelUpdateListener(listener);
        }

        public Color getColor(RGB rgb) {
            return this.fBaseProvider.getColor(rgb);
        }

        public Font getFont(FontData fontData) {
            return this.fBaseProvider.getFont(fontData);
        }

        public Image getImage(ImageDescriptor descriptor) {
            return this.fBaseProvider.getImage(descriptor);
        }

        public void removeLabelUpdateListener(ILabelUpdateListener listener) {
            this.fBaseProvider.removeLabelUpdateListener(listener);
        }

        public void addListener(ILabelProviderListener listener) {
            this.fBaseProvider.addListener(listener);
        }

        public void dispose() {
            this.fBaseProvider.dispose();
            super.dispose();
        }

        public boolean isLabelProperty(Object element, String property) {
            return this.fBaseProvider.isLabelProperty(element, property);
        }

        public void removeListener(ILabelProviderListener listener) {
            this.fBaseProvider.removeListener(listener);
        }
    }
}

