/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.ddms.views;

import com.android.ddmlib.Client;
import com.android.ddmlib.IDevice;
import com.android.ddmuilib.ImageLoader;
import com.android.ddmuilib.actions.ICommonAction;
import com.android.ddmuilib.explorer.DeviceExplorer;
import com.android.ide.eclipse.ddms.CommonAction;
import com.android.ide.eclipse.ddms.DdmsPlugin;
import com.android.ide.eclipse.ddms.i18n.Messages;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class FileExplorerView
extends ViewPart
implements DdmsPlugin.ISelectionListener {
    public static final String ID = "com.android.ide.eclipse.ddms.views.FileExplorerView";
    private static final String COLUMN_NAME = "com.android.ide.eclipse.ddms.explorer.name";
    private static final String COLUMN_SIZE = "com.android.ide.eclipse.ddms.explorer.size";
    private static final String COLUMN_DATE = "com.android.ide.eclipse.ddms.explorer.data";
    private static final String COLUMN_TIME = "com.android.ide.eclipse.ddms.explorer.time";
    private static final String COLUMN_PERMISSIONS = "com.android.ide.eclipse.ddms.explorer.permissions";
    private static final String COLUMN_INFO = "com.android.ide.eclipse.ddms.explorer.info";
    private DeviceExplorer mExplorer;

    public void createPartControl(Composite parent) {
        ImageLoader loader = ImageLoader.getDdmUiLibLoader();
        DeviceExplorer.COLUMN_NAME = COLUMN_NAME;
        DeviceExplorer.COLUMN_SIZE = COLUMN_SIZE;
        DeviceExplorer.COLUMN_DATE = COLUMN_DATE;
        DeviceExplorer.COLUMN_TIME = COLUMN_TIME;
        DeviceExplorer.COLUMN_PERMISSIONS = COLUMN_PERMISSIONS;
        DeviceExplorer.COLUMN_INFO = COLUMN_INFO;
        this.mExplorer = new DeviceExplorer();
        this.mExplorer.setCustomImages(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE"), PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER"), null, PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ELEMENTS"));
        CommonAction pushAction = new CommonAction(Messages.FileExplorerView_Push_File){

            @Override
            public void run() {
                FileExplorerView.this.mExplorer.pushIntoSelection();
            }
        };
        pushAction.setToolTipText(Messages.FileExplorerView_Push_File_Onto_Device);
        pushAction.setImageDescriptor(loader.loadDescriptor("push.png"));
        pushAction.setEnabled(false);
        CommonAction pullAction = new CommonAction(Messages.FileExplorerView_Pull_File){

            @Override
            public void run() {
                FileExplorerView.this.mExplorer.pullSelection();
            }
        };
        pullAction.setToolTipText(Messages.FileExplorerView_Pull_File_From_File);
        pullAction.setImageDescriptor(loader.loadDescriptor("pull.png"));
        pullAction.setEnabled(false);
        CommonAction deleteAction = new CommonAction(Messages.FileExplorerView_Delete){

            @Override
            public void run() {
                FileExplorerView.this.mExplorer.deleteSelection();
            }
        };
        deleteAction.setToolTipText(Messages.FileExplorerView_Delete_The_Selection);
        deleteAction.setImageDescriptor(loader.loadDescriptor("delete.png"));
        deleteAction.setEnabled(false);
        CommonAction createNewFolderAction = new CommonAction("New Folder"){

            @Override
            public void run() {
                FileExplorerView.this.mExplorer.createNewFolderInSelection();
            }
        };
        createNewFolderAction.setToolTipText("New Folder");
        createNewFolderAction.setImageDescriptor(loader.loadDescriptor("add.png"));
        createNewFolderAction.setEnabled(false);
        this.mExplorer.setActions((ICommonAction)pushAction, (ICommonAction)pullAction, (ICommonAction)deleteAction, (ICommonAction)createNewFolderAction);
        IActionBars actionBars = this.getViewSite().getActionBars();
        IMenuManager menuManager = actionBars.getMenuManager();
        IToolBarManager toolBarManager = actionBars.getToolBarManager();
        menuManager.add((IAction)pullAction);
        menuManager.add((IAction)pushAction);
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IAction)deleteAction);
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IAction)createNewFolderAction);
        toolBarManager.add((IAction)pullAction);
        toolBarManager.add((IAction)pushAction);
        toolBarManager.add((IContributionItem)new Separator());
        toolBarManager.add((IAction)deleteAction);
        toolBarManager.add((IContributionItem)new Separator());
        toolBarManager.add((IAction)createNewFolderAction);
        this.mExplorer.createPanel(parent);
        DdmsPlugin.getDefault().addSelectionListener(this);
    }

    public void setFocus() {
        this.mExplorer.setFocus();
    }

    @Override
    public void selectionChanged(Client selectedClient) {
    }

    @Override
    public void selectionChanged(IDevice selectedDevice) {
        this.mExplorer.switchDevice(selectedDevice);
    }

    public void selectionRemoved() {
    }
}

