/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdkuilib.internal.widgets;

import com.android.sdklib.internal.avd.HardwareProperties;
import com.android.sdkuilib.ui.GridDialog;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeSet;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

class HardwarePropertyChooser
extends GridDialog {
    private final Map<String, HardwareProperties.HardwareProperty> mProperties;
    private final Collection<String> mExceptProperties;
    private HardwareProperties.HardwareProperty mChosenProperty;
    private Label mTypeLabel;
    private Label mDescriptionLabel;

    HardwarePropertyChooser(Shell parentShell, Map<String, HardwareProperties.HardwareProperty> properties, Collection<String> exceptProperties) {
        super(parentShell, 2, false);
        this.mProperties = properties;
        this.mExceptProperties = exceptProperties;
    }

    public HardwareProperties.HardwareProperty getProperty() {
        return this.mChosenProperty;
    }

    @Override
    public void createDialogContent(Composite parent) {
        Label l = new Label(parent, 0);
        l.setText("Property:");
        final Combo c = new Combo(parent, 12);
        final ArrayList indexToName = new ArrayList();
        TreeSet<Map.Entry<String, HardwareProperties.HardwareProperty>> entries = new TreeSet<Map.Entry<String, HardwareProperties.HardwareProperty>>(new Comparator<Map.Entry<String, HardwareProperties.HardwareProperty>>(){

            @Override
            public int compare(Map.Entry<String, HardwareProperties.HardwareProperty> entry0, Map.Entry<String, HardwareProperties.HardwareProperty> entry1) {
                String s0 = entry0.getValue().getAbstract();
                String s1 = entry1.getValue().getAbstract();
                if (s0 != null && s1 != null) {
                    return s0.compareTo(s1);
                }
                return entry0.getKey().compareTo(entry1.getKey());
            }
        });
        entries.addAll(this.mProperties.entrySet());
        for (Map.Entry entry : entries) {
            if (!((HardwareProperties.HardwareProperty)entry.getValue()).isValidForUi() || this.mExceptProperties.contains(entry.getKey())) continue;
            c.add(((HardwareProperties.HardwareProperty)entry.getValue()).getAbstract());
            indexToName.add(entry.getKey());
        }
        boolean hasValues = true;
        if (indexToName.size() == 0) {
            hasValues = false;
            c.add("No properties");
            c.select(0);
            c.setEnabled(false);
        }
        c.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int index = c.getSelectionIndex();
                String name = (String)indexToName.get(index);
                HardwarePropertyChooser.this.processSelection(name, true);
            }
        });
        l = new Label(parent, 0);
        l.setText("Type:");
        this.mTypeLabel = new Label(parent, 0);
        l = new Label(parent, 0);
        l.setText("Description:");
        this.mDescriptionLabel = new Label(parent, 0);
        if (hasValues) {
            c.select(0);
            this.processSelection((String)indexToName.get(0), false);
        }
    }

    private void processSelection(String name, boolean pack) {
        this.mChosenProperty = name == null ? null : this.mProperties.get(name);
        String type = "Unknown";
        String desc = "Unknown";
        if (this.mChosenProperty != null) {
            desc = this.mChosenProperty.getDescription();
            HardwareProperties.HardwarePropertyType vt = this.mChosenProperty.getType();
            if (vt != null) {
                type = vt.getName();
            }
        }
        this.mTypeLabel.setText(type);
        this.mDescriptionLabel.setText(desc);
        if (pack) {
            this.getShell().pack();
        }
    }
}

