/*
 * Decompiled with CFR 0.152.
 */
package antlr.collections.impl;

import antlr.collections.impl.VectorEnumerator;
import java.util.Enumeration;

public class Vector
implements Cloneable {
    protected Object[] data;
    protected int lastElement = -1;

    public Vector() {
        this(10);
    }

    public Vector(int size) {
        this.data = new Object[size];
    }

    public synchronized void appendElement(Object o) {
        this.ensureCapacity(this.lastElement + 2);
        this.data[++this.lastElement] = o;
    }

    public int capacity() {
        return this.data.length;
    }

    public Object clone() {
        Vector v = null;
        try {
            v = (Vector)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("cannot clone Vector.super");
            return null;
        }
        v.data = new Object[this.size()];
        System.arraycopy(this.data, 0, v.data, 0, this.size());
        return v;
    }

    public synchronized Object elementAt(int i) {
        if (i >= this.data.length) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(i) + " >= " + this.data.length);
        }
        if (i < 0) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(i) + " < 0 ");
        }
        return this.data[i];
    }

    public synchronized Enumeration elements() {
        return new VectorEnumerator(this);
    }

    public synchronized void ensureCapacity(int minIndex) {
        if (minIndex + 1 > this.data.length) {
            Object[] oldData = this.data;
            int n = this.data.length * 2;
            if (minIndex + 1 > n) {
                n = minIndex + 1;
            }
            this.data = new Object[n];
            System.arraycopy(oldData, 0, this.data, 0, oldData.length);
        }
    }

    public synchronized boolean removeElement(Object o) {
        int i = 0;
        while (i <= this.lastElement && this.data[i] != o) {
            ++i;
        }
        if (i <= this.lastElement) {
            this.data[i] = null;
            int above = this.lastElement - i;
            if (above > 0) {
                System.arraycopy(this.data, i + 1, this.data, i, above);
            }
            --this.lastElement;
            return true;
        }
        return false;
    }

    public synchronized void setElementAt(Object obj, int i) {
        if (i >= this.data.length) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(i) + " >= " + this.data.length);
        }
        this.data[i] = obj;
        if (i > this.lastElement) {
            this.lastElement = i;
        }
    }

    public int size() {
        return this.lastElement + 1;
    }
}

