/*
 * Decompiled with CFR 0.152.
 */
package cz.startnet.utils.pgdiff.parsers;

import cz.startnet.utils.pgdiff.Resources;
import cz.startnet.utils.pgdiff.parsers.Parser;
import cz.startnet.utils.pgdiff.parsers.ParserUtils;
import cz.startnet.utils.pgdiff.schema.PgDatabase;
import cz.startnet.utils.pgdiff.schema.PgSchema;
import cz.startnet.utils.pgdiff.schema.PgView;
import java.text.MessageFormat;

public class AlterViewParser {
    public static void parse(PgDatabase database, String statement, boolean outputIgnoredStatements) {
        Parser parser = new Parser(statement);
        parser.expect("ALTER", "VIEW");
        String viewName = parser.parseIdentifier();
        String schemaName = ParserUtils.getSchemaName(viewName, database);
        PgSchema schema = database.getSchema(schemaName);
        if (schema == null) {
            throw new RuntimeException(MessageFormat.format(Resources.getString("CannotFindSchema"), schemaName, statement));
        }
        String objectName = ParserUtils.getObjectName(viewName);
        PgView view = schema.getView(objectName);
        if (view == null) {
            throw new RuntimeException(MessageFormat.format(Resources.getString("CannotFindView"), viewName, statement));
        }
        while (!parser.expectOptional(";")) {
            if (parser.expectOptional("ALTER")) {
                parser.expectOptional("COLUMN");
                String columnName = ParserUtils.getObjectName(parser.parseIdentifier());
                if (parser.expectOptional("SET", "DEFAULT")) {
                    String expression = parser.getExpression();
                    view.addColumnDefaultValue(columnName, expression);
                    continue;
                }
                if (parser.expectOptional("DROP", "DEFAULT")) {
                    view.removeColumnDefaultValue(columnName);
                    continue;
                }
                parser.throwUnsupportedCommand();
                continue;
            }
            if (parser.expectOptional("OWNER", "TO")) {
                if (outputIgnoredStatements) {
                    database.addIgnoredStatement("ALTER TABLE " + viewName + " OWNER TO " + parser.parseIdentifier() + ';');
                    continue;
                }
                parser.parseIdentifier();
                continue;
            }
            parser.throwUnsupportedCommand();
        }
    }

    private AlterViewParser() {
    }
}

