/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.remoteapi;

import com.google.appengine.tools.remoteapi.RemoteApiDelegate;
import com.google.appengine.tools.remoteapi.RemoteApiOptions;
import com.google.appengine.tools.remoteapi.RemoteRpc;
import com.google.apphosting.api.ApiProxy;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

class HostedRemoteApiDelegate
extends RemoteApiDelegate {
    private final ApiProxy.Delegate<ApiProxy.Environment> containerDelegate;

    public HostedRemoteApiDelegate(RemoteRpc rpc, RemoteApiOptions options, ApiProxy.Delegate<ApiProxy.Environment> containerDelegate) {
        super(rpc, options);
        if (containerDelegate == null) {
            throw new IllegalArgumentException("Options indicate we are running in an App Engine container but App Engine services are not available.");
        }
        this.containerDelegate = containerDelegate;
    }

    public byte[] makeSyncCall(ApiProxy.Environment env, String serviceName, String methodName, byte[] request) {
        if (serviceName.equals("urlfetch")) {
            return this.containerDelegate.makeSyncCall(env, serviceName, methodName, request);
        }
        return this.makeDefaultSyncCall(env, serviceName, methodName, request);
    }

    public Future<byte[]> makeAsyncCall(ApiProxy.Environment env, String serviceName, String methodName, byte[] request, ApiProxy.ApiConfig apiConfig) {
        try {
            return new FakeFuture<byte[]>(this.makeSyncCall(env, serviceName, methodName, request));
        }
        catch (Exception e) {
            return new FakeFuture<byte[]>(e);
        }
    }

    public void log(ApiProxy.Environment environment, ApiProxy.LogRecord record) {
        this.containerDelegate.log(environment, record);
    }

    public List<Thread> getRequestThreads(ApiProxy.Environment environment) {
        return this.containerDelegate.getRequestThreads(environment);
    }

    public void flushLogs(ApiProxy.Environment environment) {
        this.containerDelegate.flushLogs(environment);
    }

    @Override
    public void shutdown() {
    }

    private static class FakeFuture<T>
    implements Future<T> {
        private final T result;
        private final Exception exception;

        FakeFuture(T result) {
            this(result, null);
        }

        FakeFuture(Exception e) {
            this(null, e);
        }

        private FakeFuture(T result, Exception exception) {
            this.result = result;
            this.exception = exception;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return true;
        }

        @Override
        public T get() throws ExecutionException {
            if (this.exception != null) {
                throw new ExecutionException(this.exception);
            }
            return this.result;
        }

        @Override
        public T get(long timeout, TimeUnit unit) throws ExecutionException {
            if (this.exception != null) {
                throw new ExecutionException(this.exception);
            }
            return this.result;
        }
    }
}

